/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.atom;

import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Transform;
import com.cognos.ccs.utility.Utilities;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class AtomGenerator {
    protected static Transform Spec2Atom = null;
    protected static Transform Spec2Atom_DS = null;
    protected static Transform Spec2Atom_DSFlat = null;
    public static final Namespace atomNS = new Namespace("atom", "http://www.w3.org/2005/Atom");

    public AtomGenerator() {
        this.init();
    }

    private synchronized void init() {
        FileInputStream fileInputStream;
        String string;
        String string2;
        if (Spec2Atom == null) {
            if (System.getProperty("ccstestrun") != null) {
                string2 = System.getProperty("ccstestpath");
                string = (string2 != null ? string2 : "") + "prod/templates/ccs/xslt/raas/";
                try {
                    fileInputStream = new FileInputStream(string + "spec2atom.xsl");
                    Spec2Atom = new Transform(fileInputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            } else {
                Spec2Atom = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/raas/spec2atom.xsl"), null, null);
            }
        }
        if (Spec2Atom_DS == null) {
            if (System.getProperty("ccstestrun") != null) {
                string2 = System.getProperty("ccstestpath");
                string = (string2 != null ? string2 : "") + "prod/templates/ccs/xslt/raas/";
                try {
                    fileInputStream = new FileInputStream(string + "spec2atom_ds.xsl");
                    Spec2Atom_DS = new Transform(fileInputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            } else {
                Spec2Atom_DS = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/raas/spec2atom_ds.xsl"), null, null);
            }
        }
        if (Spec2Atom_DSFlat == null) {
            if (System.getProperty("ccstestrun") != null) {
                string2 = System.getProperty("ccstestpath");
                string = (string2 != null ? string2 : "") + "prod/templates/ccs/xslt/raas/";
                try {
                    fileInputStream = new FileInputStream(string + "spec2atom_dsFlat.xsl");
                    Spec2Atom_DSFlat = new Transform(fileInputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            } else {
                Spec2Atom_DSFlat = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/raas/spec2atom_dsFlat.xsl"), null, null);
            }
        }
    }

    private InputStream getAtomDSStream() {
        if (System.getProperty("ccstestrun") != null) {
            String string = System.getProperty("ccstestpath");
            String string2 = (string != null ? string : "") + "prod/templates/ccs/xslt/raas/";
            try {
                FileInputStream fileInputStream = new FileInputStream(string2 + "spec2atom_ds.xsl");
                return fileInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return null;
            }
        }
        return ConfigMgr.getInstance().getFileStream("/xslt/raas/spec2atom_ds.xsl");
    }

    private InputStream getAtomDS_FlatStream() {
        if (System.getProperty("ccstestrun") != null) {
            String string = System.getProperty("ccstestpath");
            String string2 = (string != null ? string : "") + "prod/templates/ccs/xslt/raas/";
            try {
                FileInputStream fileInputStream = new FileInputStream(string2 + "spec2atom_dsFlat.xsl");
                return fileInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                return null;
            }
        }
        return ConfigMgr.getInstance().getFileStream("/xslt/raas/spec2atom_dsFlat.xsl");
    }

    public Element convertSpec(String string, String string2, String string3) {
        try {
            Element element = Spec2Atom.convert(string);
            if (string2 != null && string3 == null) {
                return this.filterFeed(string2, element);
            }
            return this.processSubFeeds(string2, string3, element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected Element filterFeed(String string, Element element) {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        simpleNamespaceContext.addNamespace("atom", "http://www.w3.org/2005/Atom");
        simpleNamespaceContext.addNamespace("d", "@extensionnamespace@");
        XPath xPath = element.createXPath("//atom:entry[d:partID='" + string + "']");
        List list = xPath.selectNodes((Object)element);
        Iterator iterator = list.iterator();
        Element element2 = DocumentHelper.createElement((QName)new QName("feed", atomNS));
        this.addFeedElement(element2, "id", "tag:cognos.com,2007:" + string);
        this.addFeedElement(element2, "title", "@report_title@");
        this.addFeedElement(element2, "updated", "@report_updated@");
        Element element3 = element2.addElement(new QName("author", atomNS));
        this.addFeedElement(element3, "name", "@report_author@");
        element3.setText("@report_author_email@");
        Element element4 = element2.addElement(new QName("link", atomNS));
        element4.addAttribute("rel", "self");
        element4.addAttribute("type", "application/atom+xml");
        element4.addAttribute("href", "@report_gateway@/rds/atom/report/@report_storeid@?selection=" + string + "&v=@requestversion@");
        while (iterator.hasNext()) {
            Element element5 = (Element)iterator.next();
            element5.detach();
            element2.add(element5);
        }
        return element2;
    }

    private void addFeedElement(Element element, String string, String string2) {
        Element element2 = element.addElement(new QName(string, atomNS));
        element2.addText(string2);
    }

    protected Element processSubFeeds(String string, String string2, Element element) {
        if (Utilities.isNullOrEmpty(string)) {
            List list = element.selectNodes("//subFeed");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((Element)iterator.next()).detach();
            }
            return element;
        }
        String string3 = "'";
        if (string.contains("'")) {
            string3 = "\"";
        }
        Element element2 = (Element)element.selectSingleNode("//subFeed[@name=" + string3 + CCSFormatter.decodeName(string) + string3 + "][@type='" + string2 + "']/*[1]");
        element2.detach();
        List list = element2.elements();
        for (Element element3 : list) {
            if (!element3.getName().equals("subFeed") || !string2.equals("page")) continue;
            List list2 = element3.element("feed").elements();
            for (Element element4 : list2) {
                if (!element4.getName().equals("subFeed")) continue;
                element4.detach();
            }
        }
        return element2;
    }

    public Element convertSpec_DS_Analysis(String string, String string2, String string3, String string4) {
        try {
            Transform transform = new Transform(this.getAtomDSStream(), new String[]{"useLocalizedNames", "locale"}, new String[]{"true", string4});
            Element element = transform.convert(string);
            return this.processSubFeeds(string2, string3, element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Element convertSpec_DS_AnalysisFlat(String string, String string2, String string3, String string4) {
        try {
            Transform transform = new Transform(this.getAtomDS_FlatStream(), new String[]{"useLocalizedNames", "locale"}, new String[]{"true", string4});
            Element element = transform.convert(string);
            return this.processSubFeeds(string2, string3, element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Element convertSpec_DS(String string, String string2, String string3) {
        try {
            Element element = Spec2Atom_DS.convert(string);
            return this.processSubFeeds(string2, string3, element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Element convertSpec_DSFlat(String string, String string2, String string3) {
        try {
            Element element = Spec2Atom_DSFlat.convert(string);
            return this.processSubFeeds(string2, string3, element);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Element sortFeed(Element element, boolean bl) {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        simpleNamespaceContext.addNamespace("atom", "http://www.w3.org/2005/Atom");
        XPath xPath = element.createXPath("/atom:feed/atom:entry");
        xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        List list = xPath.selectNodes((Object)element);
        Iterator iterator = list.iterator();
        TreeMap<String, Element> treeMap = new TreeMap<String, Element>(String.CASE_INSENSITIVE_ORDER);
        Element element2 = null;
        Element element3 = null;
        while (iterator.hasNext()) {
            Element element4 = (Element)iterator.next();
            element4.detach();
            if (element4.elementText("title").equals("@header_title@")) {
                element2 = element4;
                continue;
            }
            if (element4.elementText("title").equals("@footer_title@")) {
                element3 = element4;
                continue;
            }
            treeMap.put(element4.elementText("title"), element4);
        }
        if (bl) {
            this.addElementsInAscendingOrder(element, treeMap, element2, element3);
        } else {
            this.addElementsInDescendingOrder(element, treeMap, element2, element3);
        }
        return element;
    }

    private void addElementsInAscendingOrder(Element element, TreeMap<String, Element> treeMap, Element element2, Element element3) {
        Iterator<Element> iterator = treeMap.values().iterator();
        if (element2 != null) {
            element.add(element2);
        }
        while (iterator.hasNext()) {
            element.add(iterator.next());
        }
        if (element3 != null) {
            element.add(element3);
        }
    }

    private void addElementsInDescendingOrder(Element element, TreeMap<String, Element> treeMap, Element element2, Element element3) {
        if (element2 != null) {
            element.add(element2);
        }
        Element[] elementArray = new Element[treeMap.size()];
        elementArray = treeMap.values().toArray(elementArray);
        for (int i = elementArray.length - 1; i >= 0; --i) {
            Element element4 = elementArray[i];
            element.add(element4);
        }
        if (element3 != null) {
            element.add(element3);
        }
    }
}

