/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth;

import com.cognos.ccs.auth.ACommand;
import com.cognos.ccs.auth.rest.AccountInfoRestCommand;
import com.cognos.ccs.auth.rest.LogoffRestCommand;
import com.cognos.ccs.auth.rest.LogonRestCommand;
import com.cognos.ccs.auth.rest.PassThroughRestCommand;
import com.cognos.ccs.auth.rest.RestCommand;
import com.cognos.ccs.auth.rest.WSDLRestCommand;
import com.cognos.ccs.auth.soap.LogoffSOAPCommand;
import com.cognos.ccs.auth.soap.LogonSOAPCommand;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class AuthService {
    private static final String WSDL = "wsdl";
    private static final String AUTH_SOAP_ACTION = "http://developer.cognos.com/schemas/rds/auth";
    private static final String ACCOUNT_INFO = "accountInfo";
    private static final String LOGOFF = "logoff";
    private static final String LOGON = "logon";
    private static final String PASSTHROUGH = "passthrough";
    private static final String LOGOFF_REQUEST = "logoffRequest";
    private static final String LOGON_REQUEST = "logonRequest";
    private static final String CCS_AUTH_PREFIX = "/rds/auth";
    private static final String PATH_INFO = "path_info";
    protected Namespace namespace = new Namespace("auth", "http://developer.cognos.com/schemas/ccs/auth/types/1");

    public void ProcessAuthCommand(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        messageContext.setFault(null);
        ACommand aCommand = this.getCommand(bIBusEnvelope, messageContext);
        aCommand.processCommand(bIBusEnvelope, messageContext);
    }

    private ACommand getCommand(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        String string = messageContext.getStrProperty(PATH_INFO);
        if (string != null && string.startsWith(CCS_AUTH_PREFIX)) {
            return this.getRestCommand(string);
        }
        return this.getSOAPCommand(bIBusEnvelope, messageContext);
    }

    private ACommand getSOAPCommand(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        messageContext.setFault(null);
        Element element = (Element)bIBusEnvelope.getBody().elements().get(0);
        if (element.getName().equals(LOGON_REQUEST)) {
            return new LogonSOAPCommand(this.namespace);
        }
        if (element.getName().equals(LOGOFF_REQUEST)) {
            return new LogoffSOAPCommand(this.namespace);
        }
        messageContext.setFault(new Fault("", new Exception(CCLMessage.getResMessage("REQUEST_ERROR", ConfigMgr.getInstance().getServerLocale()))));
        return null;
    }

    private ACommand getRestCommand(String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length >= 4) {
            String string2 = stringArray[3];
            if (string2.equals(LOGON)) {
                return new LogonRestCommand(this.namespace);
            }
            if (string2.equals(LOGOFF)) {
                return new LogoffRestCommand(this.namespace);
            }
            if (string2.equals(PASSTHROUGH)) {
                return new PassThroughRestCommand(this.namespace);
            }
            if (string2.equals(ACCOUNT_INFO)) {
                return new AccountInfoRestCommand(this.namespace);
            }
            if (string2.equals(WSDL)) {
                return new WSDLRestCommand(this.namespace, WSDL);
            }
            if (string2.equals("BiBus.xsd")) {
                return new WSDLRestCommand(this.namespace, "BiBus.xsd");
            }
            if (string2.equals("AuthService.xsd")) {
                return new WSDLRestCommand(this.namespace, "AuthService.xsd");
            }
        }
        RestCommand.generateErrorMessage(CCLMessage.getResMessage("REQUEST_ERROR", ConfigMgr.getInstance().getServerLocale()));
        return null;
    }

    public static boolean isAuthCommand(MessageContext messageContext) {
        String string = messageContext.getStrProperty(PATH_INFO);
        if (null != string && string.startsWith(CCS_AUTH_PREFIX)) {
            return true;
        }
        InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty("request.headers");
        String[] stringArray = internetHeaders.getHeader("soapAction");
        return stringArray != null && stringArray.length > 0 && stringArray[0].indexOf(AUTH_SOAP_ACTION) >= 0;
    }
}

