/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth;

import com.cognos.ccs.auth.IConnection;
import com.cognos.ccs.auth.credential.AccountInfo;
import com.cognos.ccs.auth.credential.Credential;
import com.cognos.ccs.auth.credential.CredentialElement;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SetCookieVar;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.UserCapabilityCache;
import com.cognos.pogo.util.CROneCookie;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import org.apache.axis.client.Stub;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class Connection
implements IConnection {
    private Cognos8Connector m_connector;
    ContentManagerService_PortType cmService;
    Account userAccount;
    private String browserDefaultLocale;

    public Connection() throws CCSGeneralException {
        try {
            this.m_connector = new Cognos8Connector();
            this.m_connector.connectToReportServer();
            this.cmService = this.m_connector.getCognosCMService();
            this.init();
        }
        catch (Exception exception) {
            throw new CCSGeneralException("CRN_CONNECT_ERROR", exception, 500);
        }
    }

    public Connection(Cognos8Connector cognos8Connector) throws CCSGeneralException {
        try {
            this.m_connector = cognos8Connector;
            this.m_connector.connectToReportServer();
            this.cmService = this.m_connector.getCognosCMService();
            this.init();
        }
        catch (Exception exception) {
            throw new CCSGeneralException("CRN_CONNECT_ERROR", exception, 500);
        }
    }

    private void init() throws CCSGeneralException {
        this.queryUserAccount();
        BiBusHeader biBusHeader = this.getServiceBIBus();
        if (biBusHeader == null) {
            throw new CCSGeneralException("CRN_CONNECT_ERROR", 500);
        }
    }

    @Override
    public void queryUserAccount() {
        PropEnum[] propEnumArray = new PropEnum[]{PropEnum.searchPath, PropEnum.userName, PropEnum.defaultName, PropEnum.productLocale, PropEnum.contentLocale};
        try {
            BaseClass[] baseClassArray = this.m_connector.queryCM("~", propEnumArray);
            if (baseClassArray.length > 0 && baseClassArray[0] instanceof Account) {
                this.userAccount = (Account)baseClassArray[0];
                this.responseHeaderAccountUpdate(this.userAccount);
                return;
            }
        }
        catch (CCSAuthenticationException cCSAuthenticationException) {
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSAuthenticationException.getLocalizedMessage(), null, null, null, cCSAuthenticationException.getStackTrace().toString());
        }
        catch (CCSGeneralException cCSGeneralException) {
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getLocalizedMessage(), null, null, null, cCSGeneralException.getStackTrace().toString());
        }
        this.userAccount = null;
    }

    private void responseHeaderAccountUpdate(Account account) {
        BiBusHeader biBusHeader = this.getServiceBIBus();
        String string = null;
        String string2 = null;
        String string3 = this.browserDefaultLocale;
        if ((null == account.getContentLocale() || null == account.getContentLocale().getValue()) && null != string3) {
            string2 = ConfigMgr.getInstance().mapContentLocale(string3);
        }
        if ((null == account.getProductLocale() || null == account.getProductLocale().getValue()) && null != string3) {
            string = ConfigMgr.getInstance().mapProductLocale(string3);
        }
        if (null != string || null != string2) {
            UserPreferenceVar[] userPreferenceVarArray;
            UserPreferenceVar[] userPreferenceVarArray2 = userPreferenceVarArray = biBusHeader.getUserPreferenceVars();
            int n = userPreferenceVarArray2.length;
            for (int i = 0; i < n; ++i) {
                UserPreferenceVar userPreferenceVar = userPreferenceVarArray2[i];
                if ("productLocale".equals(userPreferenceVar.getName()) && null != string) {
                    userPreferenceVar.setValue(string);
                }
                if (!"contentLocale".equals(userPreferenceVar.getName()) || null == string2) continue;
                userPreferenceVar.setValue(string2);
            }
            biBusHeader.setUserPreferenceVars(userPreferenceVarArray);
            for (UserPreferenceVar userPreferenceVar : userPreferenceVarArray2 = biBusHeader.getHdrSession().getSetCookieVars()) {
                if (!"CRN".equals(userPreferenceVar.getName())) continue;
                CROneCookie cROneCookie = new CROneCookie(userPreferenceVar.getValue());
                Map map = cROneCookie.getPreferences();
                if (string != null) {
                    map.put("productLocale", string);
                }
                if (string2 != null) {
                    map.put("contentLocale", string2);
                }
                String string4 = cROneCookie.getCookieString();
                userPreferenceVar.setValue(string4);
            }
        }
        this.setServiceBIBus(biBusHeader);
    }

    @Override
    public Credential generateCredentialPrompt() throws CCSGeneralException {
        BiBusHeader biBusHeader = this.getServiceBIBus();
        CAM cAM = biBusHeader.getCAM();
        if (cAM == null) {
            return new Credential();
        }
        if (cAM.getException() == null) {
            return new Credential();
        }
        return new Credential(cAM.getException());
    }

    @Override
    public boolean isAuthenticationComplete() {
        BiBusHeader biBusHeader = this.getServiceBIBus();
        CAM cAM = biBusHeader.getCAM();
        if (cAM == null) {
            return false;
        }
        if (cAM.getException() != null) {
            return false;
        }
        if (cAM.getCAMPassport() == null) {
            return false;
        }
        return cAM.getCAMPassport().getId() != null;
    }

    @Override
    public void logoff() throws CCSGeneralException {
        try {
            this.cmService.logoff();
        }
        catch (Exception exception) {
            throw new CCSGeneralException("ERROR", 500);
        }
    }

    @Override
    public void logon(Credential credential) throws CCSGeneralException {
        CredentialElement credentialElement;
        Object[] objectArray = credential.getElements();
        FormFieldVar[] formFieldVarArray = new FormFieldVar[objectArray.length + 1];
        for (int i = 0; i < objectArray.length; ++i) {
            credentialElement = (CredentialElement)objectArray[i];
            formFieldVarArray[i] = new FormFieldVar();
            formFieldVarArray[i].setName(credentialElement.getName());
            formFieldVarArray[i].setValue(credentialElement.getValue());
        }
        formFieldVarArray[objectArray.length] = new FormFieldVar();
        formFieldVarArray[objectArray.length].setName("h_CAM_action");
        formFieldVarArray[objectArray.length].setValue("logonAs");
        BiBusHeader biBusHeader = this.getServiceBIBus();
        credentialElement = biBusHeader.getCAM();
        credentialElement.setAction("logonAs");
        biBusHeader.getHdrSession().setFormFieldVars(formFieldVarArray);
        this.setServiceBIBus(biBusHeader);
        CAMPassport cAMPassport = credentialElement.getCAMPassport();
        if (objectArray.length > 0 || null == cAMPassport) {
            this.queryUserAccount();
        } else {
            String string = cAMPassport.getId();
            cAMPassport.setId(null);
            this.setServiceBIBus(biBusHeader);
            this.queryUserAccount();
            cAMPassport.setId(string);
            this.setServiceBIBus(biBusHeader);
        }
    }

    @Override
    public void populateServiceHeader(BIBusEnvelope bIBusEnvelope) {
        BiBusHeader biBusHeader = this.getServiceBIBus();
        this.copyCAMToService(bIBusEnvelope, biBusHeader);
        this.copyCookiesToService(bIBusEnvelope, biBusHeader);
        this.copyPrefsToService(bIBusEnvelope, biBusHeader);
        this.copyEnvToService(bIBusEnvelope, biBusHeader);
        this.setServiceBIBus(biBusHeader);
    }

    private void copyEnvToService(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader) {
        Element element = bIBusEnvelope.getEnvironmentVars();
        EnvironmentVar[] environmentVarArray = new EnvironmentVar[element.elements("item").size()];
        Iterator iterator = element.elementIterator("item");
        int n = 0;
        while (iterator.hasNext()) {
            EnvironmentVar environmentVar = new EnvironmentVar();
            Element element2 = (Element)iterator.next();
            Element element3 = element2.element("name");
            Element element4 = element2.element("value");
            String string = null;
            if (element3 != null) {
                string = element3.getTextTrim();
                environmentVar.setName(string);
            }
            if (element4 != null) {
                String string2 = element4.getTextTrim();
                environmentVar.setValue(string2);
                if ("HTTP_ACCEPT_LANGUAGE".equals(string)) {
                    this.browserDefaultLocale = Utilities.browserDefaultLocale(string2);
                }
            }
            environmentVarArray[n] = environmentVar;
            ++n;
        }
        biBusHeader.getHdrSession().setEnvironmentVars(environmentVarArray);
    }

    private void copyPrefsToService(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader) {
        Element element = bIBusEnvelope.getUserPreferenceVars();
        UserPreferenceVar[] userPreferenceVarArray = new UserPreferenceVar[element.elements("item").size()];
        Iterator iterator = element.elementIterator("item");
        int n = 0;
        while (iterator.hasNext()) {
            UserPreferenceVar userPreferenceVar = new UserPreferenceVar();
            Element element2 = (Element)iterator.next();
            Element element3 = element2.element("name");
            Element element4 = element2.element("value");
            if (element3 != null) {
                userPreferenceVar.setName(element3.getText());
            }
            if (element4 != null) {
                userPreferenceVar.setValue(element4.getText());
            }
            userPreferenceVarArray[n] = userPreferenceVar;
            ++n;
        }
        biBusHeader.setUserPreferenceVars(userPreferenceVarArray);
    }

    private void copyCookiesToService(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader) {
        Element element = bIBusEnvelope.getCookieVars();
        if (element != null) {
            CookieVar[] cookieVarArray = new CookieVar[element.elements("item").size()];
            Iterator iterator = element.elementIterator("item");
            int n = 0;
            while (iterator.hasNext()) {
                CookieVar cookieVar = new CookieVar();
                Element element2 = (Element)iterator.next();
                Element element3 = element2.element("name");
                Element element4 = element2.element("value");
                if (element3 != null) {
                    cookieVar.setName(element3.getTextTrim());
                }
                if (element4 != null) {
                    cookieVar.setValue(element4.getTextTrim());
                }
                cookieVarArray[n] = cookieVar;
                ++n;
            }
            biBusHeader.getHdrSession().setCookieVars(cookieVarArray);
        }
    }

    private void copyCAMToService(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader) {
        CAM cAM = biBusHeader.getCAM();
        CAMPassport cAMPassport = cAM.getCAMPassport();
        if (null == cAMPassport) {
            cAMPassport = new CAMPassport();
        }
        cAMPassport.setId(bIBusEnvelope.getPassportID());
        cAM.setCAMPassport(cAMPassport);
        if (cAM.getException() != null) {
            cAM.setException(null);
        }
    }

    BiBusHeader getServiceBIBus() {
        SOAPHeaderElement sOAPHeaderElement = ((Stub)this.cmService).getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        if (sOAPHeaderElement == null) {
            sOAPHeaderElement = ((Stub)this.cmService).getHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        }
        ((Stub)this.cmService).clearHeaders();
        ((Stub)this.cmService).setHeader(sOAPHeaderElement);
        return (BiBusHeader)sOAPHeaderElement.getObjectValue();
    }

    private void setServiceBIBus(BiBusHeader biBusHeader) {
        ((Stub)this.cmService).clearHeaders();
        ((Stub)this.cmService).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)biBusHeader);
    }

    @Override
    public void populateClientHeader(BIBusEnvelope bIBusEnvelope) {
        BiBusHeader biBusHeader = this.getServiceBIBus();
        this.copyPrefsToClient(bIBusEnvelope, biBusHeader);
        this.copyCookiesToClient(bIBusEnvelope, biBusHeader);
        this.copySetCookiesToClient(bIBusEnvelope, biBusHeader);
        this.copyCAMToClient(bIBusEnvelope, biBusHeader);
        this.copyUserCapabilityCacheToClient(bIBusEnvelope, biBusHeader);
    }

    private void copyCAMToClient(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader) {
        if (biBusHeader.getCAM() != null) {
            Element element = bIBusEnvelope.getCAM();
            if (null != element) {
                element.detach();
            }
            Element element2 = DocumentHelper.createElement((QName)BIBusEnvelope.BUS_CAM);
            element2.addAttribute(BIBusEnvelope.XSI_TYPE, element2.getQualifiedName());
            if (biBusHeader.getCAM().getCAMPassport() != null) {
                Element element3 = element2.addElement(BIBusEnvelope.BUS_CAMPASSPORT);
                element3.addAttribute(BIBusEnvelope.XSI_TYPE, element3.getQualifiedName());
                Element element4 = element3.addElement("id");
                element4.addAttribute(BIBusEnvelope.XSI_TYPE, BIBusEnvelope.XSD_STRING);
                element4.setText(biBusHeader.getCAM().getCAMPassport().getId());
            }
            bIBusEnvelope.setCAM(element2);
        }
    }

    private void copySetCookiesToClient(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader) {
        SetCookieVar[] setCookieVarArray = biBusHeader.getHdrSession().getSetCookieVars();
        if (setCookieVarArray == null) {
            return;
        }
        for (int i = 0; i < setCookieVarArray.length; ++i) {
            if (setCookieVarArray[i] == null) continue;
            String string = setCookieVarArray[i].getName();
            String string2 = setCookieVarArray[i].getValue();
            int n = setCookieVarArray[i].getMaxAge();
            bIBusEnvelope.setSetCookie(string, string2, n);
        }
    }

    private void copyCookiesToClient(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader) {
        CookieVar[] cookieVarArray = biBusHeader.getHdrSession().getCookieVars();
        if (cookieVarArray == null) {
            return;
        }
        for (int i = 0; i < cookieVarArray.length; ++i) {
            bIBusEnvelope.setCookie(cookieVarArray[i].getName(), cookieVarArray[i].getValue());
        }
    }

    private void copyPrefsToClient(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader) {
        UserPreferenceVar[] userPreferenceVarArray = biBusHeader.getUserPreferenceVars();
        if (userPreferenceVarArray == null) {
            return;
        }
        for (int i = 0; i < userPreferenceVarArray.length; ++i) {
            bIBusEnvelope.setUserPreference(userPreferenceVarArray[i].getName(), userPreferenceVarArray[i].getValue());
        }
    }

    private void copyUserCapabilityCacheToClient(BIBusEnvelope bIBusEnvelope, BiBusHeader biBusHeader) {
        if (biBusHeader.getUserCapabilityCache() != null) {
            Element element = bIBusEnvelope.getUserCapabilitiesCache();
            if (element != null) {
                element.detach();
            }
            UserCapabilityEnum[] userCapabilityEnumArray = biBusHeader.getUserCapabilityCache().getUserCapabilities();
            element = bIBusEnvelope.getUserCapabilitiesCache();
            Element element2 = element.addElement("userCapabilities");
            element2.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            element2.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, "bus:userCapabilityEnum[" + userCapabilityEnumArray.length + "]");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < userCapabilityEnumArray.length; ++i) {
                arrayList.add(userCapabilityEnumArray[i].getValue());
            }
            UserCapabilityCache userCapabilityCache = bIBusEnvelope.getBiBusHeader().getUserCapabilityCache();
            userCapabilityCache.addCapabilities(arrayList);
            String string = Base64.encode((byte[])biBusHeader.getUserCapabilityCache().getSignature());
            userCapabilityCache.addSignature(string);
        }
    }

    @Override
    public void setClientCookies(MessageContext messageContext) {
        BiBusHeader biBusHeader = this.getServiceBIBus();
        SetCookieVar[] setCookieVarArray = biBusHeader.getHdrSession().getSetCookieVars();
        if (setCookieVarArray != null) {
            InternetHeaders internetHeaders = new InternetHeaders();
            for (int i = 0; i < setCookieVarArray.length; ++i) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(setCookieVarArray[i].getName());
                stringBuffer.append("=");
                stringBuffer.append(setCookieVarArray[i].getValue());
                if (null != setCookieVarArray[i].getPath()) {
                    stringBuffer.append("; Path=");
                    stringBuffer.append(setCookieVarArray[i].getPath());
                }
                internetHeaders.addHeader("Set-Cookie", stringBuffer.toString());
            }
            messageContext.setProperty("response.headers", (Object)internetHeaders);
        }
    }

    @Override
    public AccountInfo generateAccountInfo() throws CCSGeneralException {
        AccountInfo accountInfo = new AccountInfo(this.userAccount);
        return accountInfo;
    }
}

