/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.credential;

import com.cognos.ccs.auth.credential.CredentialElement;
import com.cognos.ccs.auth.credential.IAuthElement;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.developer.schemas.bibus._3.CAMException;
import com.cognos.developer.schemas.bibus._3.DisplayObject;
import com.cognos.developer.schemas.bibus._3.PromptInfo;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class Credential
implements IAuthElement {
    private static final String CREDENTIAL_ELEMENTS = "credentialElements";
    Vector credentialElements = new Vector();

    public Credential() {
    }

    public Credential(CAMException cAMException) throws CCSGeneralException {
        PromptInfo promptInfo = cAMException.getPromptInfo();
        DisplayObject[] displayObjectArray = promptInfo.getDisplayObjects();
        if (displayObjectArray == null) {
            throw new CCSGeneralException("CRN_INVALID_LOGINREQ_RESP", 400);
        }
        for (int i = 0; i < displayObjectArray.length; ++i) {
            if (displayObjectArray[i].getName().equals("h_CAM_action")) continue;
            this.credentialElements.add(new CredentialElement(displayObjectArray[i]));
        }
    }

    public Credential(Element element) throws CCSGeneralException {
        List list = element.elements(CREDENTIAL_ELEMENTS);
        for (Element element2 : list) {
            this.credentialElements.add(new CredentialElement(element2));
        }
    }

    @Override
    public Element toElement(String string, Namespace namespace) {
        Element element = DocumentHelper.createElement((QName)new QName(string, namespace));
        Iterator iterator = this.credentialElements.iterator();
        while (iterator.hasNext()) {
            element.add(((CredentialElement)iterator.next()).toElement(CREDENTIAL_ELEMENTS, namespace));
        }
        return element;
    }

    public Object[] getElements() {
        return this.credentialElements.toArray();
    }
}

