/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.credential;

import com.cognos.ccs.auth.credential.AComplexElement;
import com.cognos.ccs.auth.credential.CredentialValue;
import com.cognos.ccs.auth.credential.StringElement;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.developer.schemas.bibus._3.DisplayObject;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CredentialElement
extends AComplexElement {
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    private static final String NAME = "name";

    public CredentialElement(DisplayObject displayObject) {
        this.children.put(NAME, new StringElement(displayObject.getName()));
        if (displayObject.getCaption() != null) {
            this.children.put(LABEL, new StringElement(displayObject.getCaption()));
        }
        this.children.put(VALUE, new CredentialValue(displayObject));
    }

    public CredentialElement(Element element) throws CCSGeneralException {
        this.parseStringValue(NAME, element, true);
        this.parseStringValue(LABEL, element, false);
        this.parseCredentialValue(element);
    }

    @Override
    public Element toElement(String string, Namespace namespace) {
        QName qName = new QName(string, namespace);
        Element element = DocumentHelper.createElement((QName)qName);
        element.add(this.getChild(NAME).toElement(NAME, namespace));
        if (this.children.containsKey(LABEL)) {
            element.add(this.getChild(LABEL).toElement(LABEL, namespace));
        }
        element.add(this.getChild(VALUE).toElement(VALUE, namespace));
        return element;
    }

    private void parseCredentialValue(Element element) throws CCSGeneralException {
        Element element2 = this.getChildElement(VALUE, element, true);
        this.children.put(VALUE, new CredentialValue(element2));
    }

    private void parseStringValue(String string, Element element, boolean bl) throws CCSGeneralException {
        Element element2 = this.getChildElement(string, element, bl);
        if (null != element2) {
            this.children.put(string, new StringElement(element2.getText()));
        }
    }

    private Element getChildElement(String string, Element element, boolean bl) throws CCSGeneralException {
        Element element2 = element.element(string);
        if (bl && null == element2) {
            throw new CCSGeneralException("AUTH_INVALID_CREDENTIAL", 400);
        }
        return element2;
    }

    public boolean hasValueSet() {
        CredentialValue credentialValue = (CredentialValue)this.getChild(VALUE);
        return credentialValue.hasValueSet();
    }

    public String getName() {
        StringElement stringElement = (StringElement)this.getChild(NAME);
        return stringElement.getElementValue();
    }

    public String getValue() {
        CredentialValue credentialValue = (CredentialValue)this.getChild(VALUE);
        return credentialValue.getActualValue().getElementValue();
    }
}

