/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.credential;

import com.cognos.ccs.auth.credential.AComplexElement;
import com.cognos.ccs.auth.credential.MissingValue;
import com.cognos.ccs.auth.credential.StringElement;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.developer.schemas.bibus._3.DisplayObject;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class CredentialValue
extends AComplexElement {
    private static final String MISSING_VALUE = "missingValue";
    private static final String ACTUAL_VALUE = "actualValue";

    public CredentialValue(DisplayObject displayObject) {
        if (displayObject.getValue() != null) {
            this.children.put(ACTUAL_VALUE, new StringElement(displayObject.getValue()));
        } else {
            this.children.put(MISSING_VALUE, new MissingValue(displayObject));
        }
    }

    public CredentialValue(Element element) throws CCSGeneralException {
        if (!this.addActual(element)) {
            this.addMissing(element);
        }
    }

    private boolean addActual(Element element) throws CCSGeneralException {
        Element element2 = element.element(ACTUAL_VALUE);
        if (null != element2) {
            this.children.put(ACTUAL_VALUE, new StringElement(element2.getText()));
            return true;
        }
        return false;
    }

    private void addMissing(Element element) throws CCSGeneralException {
        Element element2 = element.element(MISSING_VALUE);
        if (null == element2) {
            throw new CCSGeneralException("AUTH_INVALID_CREDENTIAL", 400);
        }
        this.children.put(MISSING_VALUE, new MissingValue(element2));
    }

    @Override
    public Element toElement(String string, Namespace namespace) {
        Element element = DocumentHelper.createElement((QName)new QName(string, namespace));
        this.addElementIfExists(ACTUAL_VALUE, namespace, element);
        this.addElementIfExists(MISSING_VALUE, namespace, element);
        return element;
    }

    private void addElementIfExists(String string, Namespace namespace, Element element) {
        if (this.children.containsKey(string)) {
            element.add(this.getChild(string).toElement(string, namespace));
        }
    }

    public boolean hasValueSet() {
        return this.children.containsKey(ACTUAL_VALUE);
    }

    public StringElement getActualValue() {
        return (StringElement)this.getChild(ACTUAL_VALUE);
    }
}

