/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.credential;

import com.cognos.ccs.auth.credential.IAuthElement;
import com.cognos.ccs.auth.credential.StringElement;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.developer.schemas.bibus._3.PromptOption;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class EnumerationElement
implements IAuthElement {
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    StringElement enumerationLabel;
    StringElement enumerationValue;

    public EnumerationElement(PromptOption promptOption) {
        this.enumerationLabel = new StringElement(promptOption.getValue());
        this.enumerationValue = new StringElement(promptOption.getId());
    }

    public EnumerationElement(Element element) throws CCSGeneralException {
        this.enumerationLabel = new StringElement(this.getChildElement(LABEL, element).getText());
        this.enumerationValue = new StringElement(this.getChildElement(VALUE, element).getText());
    }

    private Element getChildElement(String string, Element element) throws CCSGeneralException {
        Element element2 = element.element(string);
        if (null == element2) {
            throw new CCSGeneralException("AUTH_INVALID_CREDENTIAL", 400);
        }
        return element2;
    }

    @Override
    public Element toElement(String string, Namespace namespace) {
        Element element = DocumentHelper.createElement((QName)new QName(string, namespace));
        element.add(this.enumerationLabel.toElement(LABEL, namespace));
        element.add(this.enumerationValue.toElement(VALUE, namespace));
        return element;
    }
}

