/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.credential;

import com.cognos.ccs.auth.credential.EnumerationElement;
import com.cognos.ccs.auth.credential.IAuthElement;
import com.cognos.ccs.auth.credential.StringElement;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.developer.schemas.bibus._3.DisplayObject;
import com.cognos.developer.schemas.bibus._3.PromptOption;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class MissingValue
implements IAuthElement {
    private static final String ENUMERATION = "enumeration";
    private static final String VALUE_TYPE = "valueType";
    private StringElement valueType;
    private EnumerationElement[] enumeration;

    public MissingValue(DisplayObject displayObject) {
        this.valueType = new StringElement(displayObject.getType());
        this.parseEnumerations(displayObject.getPromptOptions());
    }

    public MissingValue(Element element) throws CCSGeneralException {
        this.parseValueType(element);
        this.parseEnumerations(element);
    }

    private void parseValueType(Element element) throws CCSGeneralException {
        Element element2 = element.element(VALUE_TYPE);
        if (null == element2) {
            throw new CCSGeneralException("AUTH_INVALID_CREDENTIAL", 400);
        }
        this.valueType = new StringElement(element2.getText());
    }

    private void parseEnumerations(PromptOption[] promptOptionArray) {
        if (promptOptionArray != null) {
            this.enumeration = new EnumerationElement[promptOptionArray.length];
            for (int i = 0; i < promptOptionArray.length; ++i) {
                this.enumeration[i] = new EnumerationElement(promptOptionArray[i]);
            }
            return;
        }
        this.enumeration = new EnumerationElement[0];
    }

    private void parseEnumerations(Element element) throws CCSGeneralException {
        List list = element.elements(ENUMERATION);
        if (list != null) {
            this.enumeration = new EnumerationElement[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                this.enumeration[i] = new EnumerationElement(element2);
            }
            return;
        }
        this.enumeration = new EnumerationElement[0];
    }

    @Override
    public Element toElement(String string, Namespace namespace) {
        Element element = DocumentHelper.createElement((QName)new QName(string, namespace));
        element.add(this.valueType.toElement(VALUE_TYPE, namespace));
        for (int i = 0; i < this.enumeration.length; ++i) {
            element.add(this.enumeration[i].toElement(ENUMERATION, namespace));
        }
        return element;
    }
}

