/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.rest;

import com.cognos.ccs.auth.IConnection;
import com.cognos.ccs.auth.credential.AccountInfo;
import com.cognos.ccs.auth.credential.Credential;
import com.cognos.ccs.auth.rest.RestCommand;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Namespace;

public class LogonRestCommand
extends RestCommand {
    private static final String CREDENTIAL_TAG = "credentialPrompt";
    private static final String ACCOUNT_TAG = "accountInfo";

    public LogonRestCommand(Namespace namespace) {
        super(namespace);
    }

    public LogonRestCommand(Namespace namespace, IConnection iConnection) {
        super(namespace, iConnection);
    }

    @Override
    public String doAction(BIBusEnvelope bIBusEnvelope, Locale locale, MessageContext messageContext) {
        try {
            return this.login(bIBusEnvelope);
        }
        catch (DocumentException documentException) {
            return LogonRestCommand.generateErrorMessage(CCLMessage.getResMessage("AUTH_INVALID_CREDENTIAL", locale));
        }
        catch (CCSGeneralException cCSGeneralException) {
            return LogonRestCommand.generateErrorMessage(cCSGeneralException.getUserLocaleMessage(locale));
        }
    }

    private String login(BIBusEnvelope bIBusEnvelope) throws DocumentException, CCSGeneralException {
        Document document = this.getXMLFormData(bIBusEnvelope);
        this.connection.logon(new Credential(document.getRootElement()));
        if (this.connection.isAuthenticationComplete()) {
            AccountInfo accountInfo = this.connection.generateAccountInfo();
            return accountInfo.toElement(ACCOUNT_TAG, this.namespace).asXML();
        }
        Credential credential = this.connection.generateCredentialPrompt();
        return credential.toElement(CREDENTIAL_TAG, this.namespace).asXML();
    }
}

