/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.rest;

import com.cognos.ccs.auth.IConnection;
import com.cognos.ccs.auth.credential.AccountInfo;
import com.cognos.ccs.auth.credential.Credential;
import com.cognos.ccs.auth.rest.RestCommand;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.util.Locale;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Namespace;

public class PassThroughRestCommand
extends RestCommand {
    private static final String CREDENTIAL_TAG = "credentialPrompt";
    private static final String ACCOUNT_TAG = "accountInfo";

    public PassThroughRestCommand(Namespace namespace) {
        super(namespace);
    }

    public PassThroughRestCommand(Namespace namespace, IConnection iConnection) {
        super(namespace, iConnection);
    }

    @Override
    public String doAction(BIBusEnvelope bIBusEnvelope, Locale locale, MessageContext messageContext) {
        try {
            this.connection.queryUserAccount();
            return this.passThrough(bIBusEnvelope, messageContext);
        }
        catch (DocumentException documentException) {
            return PassThroughRestCommand.generateErrorMessage(CCLMessage.getResMessage("AUTH_INVALID_CREDENTIAL", locale));
        }
        catch (CCSGeneralException cCSGeneralException) {
            return PassThroughRestCommand.generateErrorMessage(cCSGeneralException.getUserLocaleMessage(locale));
        }
    }

    private String passThrough(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) throws DocumentException, CCSGeneralException {
        Document document = this.getXMLFormData(bIBusEnvelope);
        if (!this.connection.isAuthenticationComplete()) {
            this.connection.logon(new Credential(document.getRootElement()));
        }
        if (this.connection.isAuthenticationComplete()) {
            String string = bIBusEnvelope.getFormValue("location");
            string = string == null ? ConfigMgr.getInstance().getCognosGateway() : CCSFormatter.decodeName(string);
            messageContext.setProperty("response.status_code", (Object)"307");
            InternetHeaders internetHeaders = (InternetHeaders)messageContext.getProperty("response.headers");
            internetHeaders.addHeader("Location", string);
            messageContext.setProperty("response.headers", (Object)internetHeaders);
            AccountInfo accountInfo = this.connection.generateAccountInfo();
            return accountInfo.toElement(ACCOUNT_TAG, this.namespace).asXML();
        }
        Credential credential = this.connection.generateCredentialPrompt();
        return credential.toElement(CREDENTIAL_TAG, this.namespace).asXML();
    }
}

