/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.rest;

import com.cognos.ccs.auth.ACommand;
import com.cognos.ccs.auth.IConnection;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.CCSResponder;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.transports.XMLTransport;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Namespace;
import org.dom4j.io.SAXReader;

public abstract class RestCommand
extends ACommand {
    public static final String NOERROR = "<noerror/>";

    public RestCommand(Namespace namespace) {
        super(namespace);
    }

    public RestCommand(Namespace namespace, IConnection iConnection) {
        super(namespace, iConnection);
        this.connected = true;
    }

    @Override
    public void processCommand(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        CCSResponder cCSResponder = new CCSResponder();
        messageContext.setProperty("pogo.responder", (Object)cCSResponder);
        Boolean bl = (Boolean)messageContext.getProperty("balancedRequest");
        if (bl.booleanValue()) {
            cCSResponder.setBalanced(true);
        }
        XMLTransport xMLTransport = new XMLTransport();
        Locale locale = ConfigMgr.getJavaLocale(bIBusEnvelope.getUserPreferenceValue("productLocale"));
        BIBusEnvelope bIBusEnvelope2 = xMLTransport.prepareResponse(bIBusEnvelope, messageContext, new Namespace[]{this.namespace});
        if (this.connected) {
            this.connection.populateServiceHeader(bIBusEnvelope);
            String string = this.doAction(bIBusEnvelope, locale, messageContext);
            cCSResponder.setBuffer(string, xMLTransport);
            this.connection.populateClientHeader(bIBusEnvelope2);
        } else {
            RestCommand.generateErrorMessage(CCLMessage.getResMessage("CRN_CONNECT_ERROR", locale));
        }
    }

    public abstract String doAction(BIBusEnvelope var1, Locale var2, MessageContext var3);

    public String doAction(BIBusEnvelope bIBusEnvelope, Locale locale) {
        return this.doAction(bIBusEnvelope, locale, null);
    }

    protected Document getXMLFormData(BIBusEnvelope bIBusEnvelope) throws DocumentException, CCSGeneralException {
        String string = bIBusEnvelope.getFormValue("xmlData");
        if (string == null) {
            throw new CCSGeneralException("AUTH_INVALID_CREDENTIAL", 400);
        }
        SAXReader sAXReader = Utilities.getSAXReader();
        Document document = sAXReader.read((Reader)new StringReader(string));
        return document;
    }

    public static String generateErrorMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<error>");
        stringBuffer.append(string);
        stringBuffer.append("</error>");
        return stringBuffer.toString();
    }
}

