/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.rest;

import com.cognos.ccs.auth.rest.RestCommand;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.dom4j.Namespace;

public class WSDLRestCommand
extends RestCommand {
    private String m_fType = null;

    public WSDLRestCommand(Namespace namespace, String string) {
        super(namespace);
        this.m_fType = string;
    }

    @Override
    public String doAction(BIBusEnvelope bIBusEnvelope, Locale locale, MessageContext messageContext) {
        try {
            if (this.m_fType.equals("wsdl")) {
                return this.getWSDL();
            }
            if (this.m_fType.equals("BiBus.xsd")) {
                return Utilities.readFile("/wsdl/BiBus.xsd");
            }
            if (this.m_fType.equals("AuthService.xsd")) {
                return Utilities.readFile("/wsdl/AuthService.xsd");
            }
            return WSDLRestCommand.generateErrorMessage("FILE_ERROR");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return WSDLRestCommand.generateErrorMessage("FILE_ERROR");
        }
        catch (IOException iOException) {
            return WSDLRestCommand.generateErrorMessage("FILE_ERROR");
        }
    }

    private String getWSDL() throws UnsupportedEncodingException, IOException {
        String string = Utilities.readFile("/wsdl/AuthService.wsdl");
        string = string.replaceAll("\\@AUTH_ENDPOINT\\@", ConfigMgr.getInstance().getCognosGateway());
        return string;
    }
}

