/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.soap;

import com.cognos.ccs.auth.ACommand;
import com.cognos.ccs.auth.IConnection;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.transports.SOAPTransport;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import java.util.List;
import java.util.Locale;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public abstract class ASOAPCommand
extends ACommand {
    public static String RESPONSE_NO_ERROR = "NO_ERROR";
    public static String RESPONSE_ERROR = "ERROR";

    protected ASOAPCommand(Namespace namespace) {
        super(namespace);
    }

    protected ASOAPCommand(Namespace namespace, IConnection iConnection) {
        super(namespace, iConnection);
    }

    @Override
    public void processCommand(BIBusEnvelope bIBusEnvelope, MessageContext messageContext) {
        BIBusEnvelope bIBusEnvelope2 = new SOAPTransport().prepareResponse(bIBusEnvelope, messageContext, new Namespace[]{this.namespace});
        Locale locale = ConfigMgr.getJavaLocale(bIBusEnvelope.getUserPreferenceValue("productLocale"));
        this.connection.populateServiceHeader(bIBusEnvelope);
        if (this.connected) {
            this.doAction(bIBusEnvelope, bIBusEnvelope2, locale);
        } else {
            Element element = this.generateResponseBody(bIBusEnvelope2);
            this.generateResponseCode(RESPONSE_ERROR, CCLMessage.getResMessage("CRN_CONNECT_ERROR", locale), element);
        }
        this.connection.populateClientHeader(bIBusEnvelope2);
    }

    public abstract void doAction(BIBusEnvelope var1, BIBusEnvelope var2, Locale var3);

    public void generateResponseCode(String string, Element element) {
        this.generateResponseCode(string, null, element);
    }

    public void generateResponseCode(String string, String string2, Element element) {
        Element element2 = this.createTextElement("responseCode", string);
        Element element3 = null;
        if (null != string2) {
            element3 = this.createTextElement("responseMessage", string2);
        }
        List list = element.elements();
        if (null != element3) {
            this.insertElementAtStart(list, element3);
        }
        this.insertElementAtStart(list, element2);
    }

    private void insertElementAtStart(List list, Element element) {
        if (list.size() == 0) {
            list.add(element);
        } else {
            list.add(0, element);
        }
    }

    private Element createTextElement(String string, String string2) {
        Element element = DocumentHelper.createElement((QName)new QName(string, this.namespace));
        element.setText(string2);
        return element;
    }

    protected abstract Element generateResponseBody(BIBusEnvelope var1);
}

