/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.auth.soap;

import com.cognos.ccs.auth.IConnection;
import com.cognos.ccs.auth.credential.Credential;
import com.cognos.ccs.auth.soap.ASOAPCommand;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.Locale;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class LogonSOAPCommand
extends ASOAPCommand {
    private static final String RESULT = "result";
    private static final String ACCOUNT_INFO = "accountInfo";
    private static final String CREDENTIALS = "credentials";
    private static final String CREDENTIAL_PROMPT = "credentialPrompt";
    private static final String LOGON_RESPONSE = "logonResponse";
    private static final String LOGON_REQUEST = "logonRequest";

    public LogonSOAPCommand(Namespace namespace) {
        super(namespace);
    }

    public LogonSOAPCommand(Namespace namespace, IConnection iConnection) {
        super(namespace, iConnection);
    }

    @Override
    public void doAction(BIBusEnvelope bIBusEnvelope, BIBusEnvelope bIBusEnvelope2, Locale locale) {
        Element element = this.generateResponseBody(bIBusEnvelope2);
        Element element2 = bIBusEnvelope.getBody().element(LOGON_REQUEST).element(CREDENTIALS);
        this.login(element2, locale, element);
    }

    @Override
    protected Element generateResponseBody(BIBusEnvelope bIBusEnvelope) {
        Element element = bIBusEnvelope.getBody().addElement(new QName(LOGON_RESPONSE, this.namespace));
        return element;
    }

    private void login(Element element, Locale locale, Element element2) {
        try {
            this.doLogin(element, element2);
        }
        catch (CCSGeneralException cCSGeneralException) {
            this.generateResponseCode(ASOAPCommand.RESPONSE_ERROR, cCSGeneralException.getUserLocaleMessage(locale), element2);
            Element element3 = element2.element(RESULT);
            if (element3 != null) {
                element3.detach();
            }
            element3 = element2.addElement(new QName(RESULT, this.namespace));
            element3.addElement(new QName("noResult", this.namespace));
        }
    }

    private void doLogin(Element element, Element element2) throws CCSGeneralException {
        if (null == element) {
            throw new CCSGeneralException("AUTH_INVALID_CREDENTIAL", 400);
        }
        this.connection.logon(new Credential(element));
        Element element3 = element2.addElement(new QName(RESULT, this.namespace));
        if (this.connection.isAuthenticationComplete()) {
            element3.add(this.connection.generateAccountInfo().toElement(ACCOUNT_INFO, this.namespace));
        } else {
            Credential credential = this.connection.generateCredentialPrompt();
            element3.add(credential.toElement(CREDENTIAL_PROMPT, this.namespace));
        }
        this.generateResponseCode(ASOAPCommand.RESPONSE_NO_ERROR, element2);
    }
}

