/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.collaboration;

import com.cognos.ccs.collaboration.HTSConnector;
import com.cognos.ccs.collaboration.LotusActConnector;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.Document;
import org.dom4j.Element;

public abstract class CollabConnector {
    private static CollabConnector collabSingleton = null;

    private static CollabConnector getCollabSingleton() {
        if (collabSingleton == null) {
            collabSingleton = "lotusConnectionActivities".equals(ConfigMgr.getInstance().getCollaborationService()) ? new LotusActConnector(ConfigMgr.getInstance().getCollaborationServiceURI()) : new HTSConnector();
        }
        return collabSingleton;
    }

    protected abstract String addTopic(Cookie[] var1, BIBusEnvelope var2, String var3, Document var4, String var5) throws CCSGeneralException, CCSAuthenticationException;

    protected abstract Document getTopicFeed(Cookie[] var1, BIBusEnvelope var2, String var3) throws CCSGeneralException, CCSAuthenticationException;

    protected abstract Element getTopicElement(Cookie[] var1, BIBusEnvelope var2, String var3) throws CCSGeneralException, CCSAuthenticationException;

    protected abstract String addComment(Cookie[] var1, BIBusEnvelope var2, String var3, Document var4) throws CCSGeneralException, CCSAuthenticationException;

    protected abstract Document getCommentsFeed(Cookie[] var1, BIBusEnvelope var2, String var3) throws CCSGeneralException, CCSAuthenticationException;

    protected abstract String markTaskComplete(Cookie[] var1, BIBusEnvelope var2, String var3) throws CCSGeneralException, CCSAuthenticationException;

    protected abstract String markTaskIncomplete(Cookie[] var1, BIBusEnvelope var2, String var3) throws CCSGeneralException, CCSAuthenticationException;

    public static String getTopicsAndComments(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        Document document = CollabConnector.getCollabSingleton().getTopicFeed(cookieArray, bIBusEnvelope, string);
        List list = document.getRootElement().elements("entry");
        for (Element element : list) {
            String string2 = element.elementText("id");
            string2 = string2.substring(9);
            Document document2 = CollabConnector.getCollabSingleton().getCommentsFeed(cookieArray, bIBusEnvelope, string2);
            List list2 = document2.getRootElement().elements("entry");
            for (Element element2 : list2) {
                document.getRootElement().add(element2.createCopy());
            }
        }
        return document.asXML();
    }

    public static String getTopicsByReport(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        Document document = CollabConnector.getCollabSingleton().getTopicFeed(cookieArray, bIBusEnvelope, string);
        return document.asXML();
    }

    public static Element getTopic(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        return CollabConnector.getCollabSingleton().getTopicElement(cookieArray, bIBusEnvelope, string);
    }

    public static String deleteTopic(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException {
        throw new CCSGeneralException("REQUEST_ERROR", 400);
    }

    public static String createTopic(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string, Document document, String string2) throws CCSGeneralException, CCSAuthenticationException {
        return CollabConnector.getCollabSingleton().addTopic(cookieArray, bIBusEnvelope, string, document, string2);
    }

    public static String createComment(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string, Document document) throws CCSGeneralException, CCSAuthenticationException {
        return CollabConnector.getCollabSingleton().addComment(cookieArray, bIBusEnvelope, string, document);
    }

    public static String getCommentsByTopic(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        Document document = CollabConnector.getCollabSingleton().getCommentsFeed(cookieArray, bIBusEnvelope, string);
        return document.asXML();
    }

    public static String completeTask(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        return CollabConnector.getCollabSingleton().markTaskComplete(cookieArray, bIBusEnvelope, string);
    }

    public static String reopenTask(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        return CollabConnector.getCollabSingleton().markTaskIncomplete(cookieArray, bIBusEnvelope, string);
    }
}

