/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.collaboration;

import com.cognos.ccs.collaboration.CollabConnector;
import com.cognos.ccs.content.HTTPRequest;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.command.AAtomPubCommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.Iterator;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class HTSConnector
extends CollabConnector {
    @Override
    protected Document getTopicFeed(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        String string2 = string;
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string3 = "<ns1:query xmlns:ns1=\"http://www.example.org/WS-HT/api/xsd\"><ns1:selectClause></ns1:selectClause><ns1:whereClause>Task.CmStoreId=" + string2 + "</ns1:whereClause>" + "<ns1:orderByClause>Task.CreateDate desc</ns1:orderByClause>" + "</ns1:query>";
        hTTPRequest.setSoapRequestBody(string3);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        String string4 = hTTPRequest.retrieveContent();
        return this.processTaskResponse(string4, string);
    }

    public Document processTaskResponse(String string, String string2) throws CCSGeneralException, CCSAuthenticationException {
        Document document = null;
        try {
            Document document2 = Utilities.parseText(string);
            HTSConnector.checkForSOAPFaults(document2);
            Element element = document2.getRootElement();
            document = AAtomPubCommand.startFeed(string2, string2);
            Element element2 = element.element("Body");
            element2 = element2.element("queryResponse");
            element2 = element2.element("query");
            Iterator iterator = element2.elementIterator("row");
            while (iterator.hasNext()) {
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                Element element3 = (Element)iterator.next();
                element2 = element3.element("id");
                if (element2 != null) {
                    string3 = element2.getText();
                }
                if ((element2 = element3.element("presentationSubject")) != null) {
                    string4 = element2.getText();
                }
                if ((element2 = element3.element("presentationDescription")) != null) {
                    string6 = element2.getText();
                }
                if ((element2 = element3.element("createdOn")) != null) {
                    string5 = element2.getText();
                }
                String string7 = element3.elementText("locale");
                String string8 = element3.elementText("formattedCreatedBy");
                String string9 = element3.elementText("createdBy");
                Element element4 = AAtomPubCommand.addEntry(document, string4, string3, string5, string6, string8, string9, string7, null);
                Element element5 = element4.addElement("category");
                element5.addAttribute("scheme", "http://www.ibm.com/xmlns/prod/cognos/collaboration");
                element5.addAttribute("term", "topic");
                element5.addAttribute("label", "Topic");
            }
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        return document;
    }

    @Override
    public String addTopic(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string, Document document, String string2) throws CCSGeneralException, CCSAuthenticationException {
        Document document2;
        Element element = document.getRootElement();
        Element element2 = element.element("title");
        String string3 = element2.getText();
        element2 = element.element("summary");
        String string4 = element2.getText();
        String string5 = string;
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string6 = "<tns:createTopicTask xsi:schemaLocation=\"http://www.ibm.com/xmlns/prod/cognos/internal/hts/topictask/_1 Untitled15.xsd\" xmlns:ht=\"http://www.example.org/WS-HT\" xmlns:hts=\"http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1\" xmlns:tns=\"http://www.ibm.com/xmlns/prod/cognos/internal/hts/topictask/_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\t<hts:beplTask name=\"\">\t\t<hts:peopleAssignments>\t\t\t<ht:taskStakeholders>\t\t\t\t<ht:from logicalPeopleGroup=\"CM\">\t\t            <ht:literal>\t\t\t                <ht:organizationalEntity>\t\t                    <ht:groups>\t\t                        <ht:group>" + string5 + "</ht:group>" + "\t\t                    </ht:groups>" + "\t\t                </ht:organizationalEntity>" + "\t\t            </ht:literal>" + "\t\t        </ht:from>" + "\t\t    </ht:taskStakeholders>" + "\t\t</hts:peopleAssignments>" + "\t\t<hts:priority>1</hts:priority>" + "\t</hts:beplTask>" + "\t<tns:topicTask>" + "\t\t<subject>" + "<![CDATA[" + string3 + "]]>" + "</subject>" + "\t\t<description>" + "<![CDATA[" + string4 + "]]>" + "</description>" + "\t\t<approveText>String</approveText>" + "\t\t<doEmailNotification>true</doEmailNotification>" + "\t</tns:topicTask>" + "</tns:createTopicTask>";
        hTTPRequest.setSoapRequestBody(string6);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        String string7 = hTTPRequest.retrieveContent();
        try {
            document2 = Utilities.parseText(string7);
            HTSConnector.checkForSOAPFaults(document2);
            element = document2.getRootElement();
            element2 = element.element("Body");
            element2 = element2.element("createTopicTaskResponse");
            element2 = element2.element("taskId");
            string7 = element2.getText();
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        document2 = this.getTopicElement(cookieArray, bIBusEnvelope, string7);
        string2 = string2 + string7;
        element2 = document2.addElement("link");
        element2.addAttribute("rel", "edit");
        element2.addAttribute("href", string2);
        element2 = document2.addElement("link");
        element2.addAttribute("rel", "self");
        element2.addAttribute("href", string2);
        return document2.asXML();
    }

    @Override
    protected String addComment(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string, Document document) throws CCSGeneralException, CCSAuthenticationException {
        Document document2;
        String string2 = "";
        String string3 = "";
        Element element = document.getRootElement();
        Element element2 = element.element("title");
        element2 = element.element("summary");
        if (element2 != null) {
            string3 = element2.getText();
        }
        if ((element2 = element.element("in-reply-to")) != null) {
            string2 = element2.getText();
        }
        if (string2.equals(string)) {
            string2 = "";
        }
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string4 = "";
        string4 = string2 == null || string2.equals("") ? string4 + "<n1:addComment xmlns:n1=\"http://www.example.org/WS-HT/api/xsd\" > <n1:identifier>" + string + "</n1:identifier> " + "<n1:text>" + "<![CDATA[" + string3 + "]]>" + "</n1:text> " + this.createTodoSection(document) + "</n1:addComment> " : string4 + "<ext:addCommentReply xmlns:ext=\"http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"> <ext:identifier>" + string2 + "</ext:identifier> " + "<ext:text>" + "<![CDATA[" + string3 + "]]>" + "</ext:text> " + this.createTodoSection(document) + "</ext:addCommentReply> ";
        hTTPRequest.setSoapRequestBody(string4);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        String string5 = hTTPRequest.retrieveContent();
        try {
            document2 = Utilities.parseText(string5);
            HTSConnector.checkForSOAPFaults(document2);
            element = document2.getRootElement();
            Element element3 = element.element("Body");
            element2 = element3.element("addCommentResponse");
            if (element2 == null) {
                element2 = element3.element("addCommentReplyResponse");
            }
            element2 = element2.element("commentId");
            string5 = element2.getText();
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        document2 = this.getComment(cookieArray, bIBusEnvelope, string5, string);
        return document2.asXML();
    }

    @Override
    protected Document getCommentsFeed(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        String string2 = HTSConnector.getCommentsSOAPResponse(cookieArray, bIBusEnvelope, string);
        Document document = null;
        try {
            Document document2 = Utilities.parseText(string2);
            HTSConnector.checkForSOAPFaults(document2);
            Element element = document2.getRootElement();
            document = AAtomPubCommand.startFeed(string, string);
            document.getRootElement().addNamespace("thr", "http://purl.org/syndication/thread/1.0");
            Element element2 = element.element("Body");
            element2 = element2.element("getCommentsByTypeResponse");
            element2 = element2.element("getCommentsByTypeGroup");
            if (element2 != null) {
                Iterator iterator = element2.elementIterator("comment");
                while (iterator.hasNext()) {
                    Element element3 = (Element)iterator.next();
                    this.buildCommentEntry(cookieArray, bIBusEnvelope, string, document, element3);
                }
            }
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        return document;
    }

    private Element buildCommentEntry(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string, Document document, Element element) throws CCSGeneralException, CCSAuthenticationException {
        String string2 = element.elementText("taskId");
        if (string2 != null && !string2.equals("")) {
            Element element2 = this.getTodoElement(cookieArray, bIBusEnvelope, string2).createCopy();
            document.getRootElement().add(element2);
            String string3 = element.elementText("parentId");
            if (string3 == null || string3.equals("")) {
                string3 = string;
            }
            Element element3 = element2.addElement("thr:in-reply-to");
            element3.setText(string3);
            return element2;
        }
        return HTSConnector.buildEntryFromComment(document, element, string);
    }

    private static Element buildEntryFromComment(Document document, Element element, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        Element element2 = element.element("id");
        if (element2 != null) {
            string2 = element2.getText();
        }
        string3 = string2;
        element2 = element.element("text");
        if (element2 != null) {
            string5 = element2.getText();
        }
        if ((element2 = element.element("addedAt")) != null) {
            string4 = element2.getText();
        }
        element2 = element.element("addedBy");
        String string8 = element.elementText("locale");
        String string9 = element.elementText("formattedAddedBy");
        String string10 = element.elementText("addedBy");
        Element element3 = AAtomPubCommand.addEntry(document, string3, string2, string4, string5, string9, string10, string8, null);
        element2 = element.element("parentId");
        if (element2 != null) {
            string6 = element2.getText();
        }
        if (string6.equals("")) {
            string6 = string;
        }
        element2 = element3.addElement("thr:in-reply-to");
        element2.setText(string6);
        element2 = element.element("replyCount");
        if (element2 != null) {
            string7 = element2.getText();
        }
        if (!string7.equals("")) {
            element2 = element3.addElement("reply-count");
            element2.setText(string7);
        }
        Element element4 = element3.addElement("category");
        element4.addAttribute("scheme", "http://www.ibm.com/xmlns/prod/cognos/collaboration");
        element4.addAttribute("term", "comment");
        element4.addAttribute("label", "Comment");
        return element3;
    }

    private static String getCommentsSOAPResponse(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException {
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string2 = "<ext:getCommentsByType xmlns:ext=\"http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\t<ext:commentType>USER</ext:commentType>\t<ext:identifier>" + string + "</ext:identifier>" + "</ext:getCommentsByType>";
        hTTPRequest.setSoapRequestBody(string2);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        String string3 = hTTPRequest.retrieveContent();
        return string3;
    }

    private Element getComment(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string, String string2) throws CCSGeneralException, CCSAuthenticationException {
        String string3 = HTSConnector.getCommentsSOAPResponse(cookieArray, bIBusEnvelope, string2);
        Document document = null;
        try {
            Document document2 = Utilities.parseText(string3);
            HTSConnector.checkForSOAPFaults(document2);
            Element element = document2.getRootElement();
            document = AAtomPubCommand.startFeed(string2, string2);
            document.getRootElement().addNamespace("thr", "http://purl.org/syndication/thread/1.0");
            Element element2 = element.element("Body");
            element2 = element2.element("getCommentsByTypeResponse");
            element2 = element2.element("getCommentsByTypeGroup");
            Iterator iterator = element2.elementIterator("comment");
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                if (!element3.elementText("id").equals(string)) continue;
                return this.buildCommentEntry(cookieArray, bIBusEnvelope, string2, document, element3);
            }
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        return null;
    }

    @Override
    protected Element getTopicElement(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        Document document = this.getResponseDoc(cookieArray, bIBusEnvelope, string);
        Element element = this.getTaskElement(cookieArray, bIBusEnvelope, string, document);
        Element element2 = element.addElement("category");
        element2.addAttribute("scheme", "http://www.ibm.com/xmlns/prod/cognos/collaboration");
        element2.addAttribute("term", "topic");
        element2.addAttribute("label", "Topic");
        return element;
    }

    protected Element getTodoElement(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        Element element;
        Object object;
        Iterator iterator;
        Document document = this.getResponseDoc(cookieArray, bIBusEnvelope, string);
        Element element2 = this.getTaskElement(cookieArray, bIBusEnvelope, string, document);
        Element element3 = document.getRootElement().element("Body").element("getTaskInfoResponse").element("task");
        if (element3.element("deadlines") != null) {
            iterator = element3.element("deadlines").elementIterator("deadlineInstance");
            while (iterator.hasNext()) {
                object = (Element)iterator.next();
                if (!object.elementText("type").equals("COMPLETE")) continue;
                element = element2.addElement("dueDate");
                element.setText(object.elementText("date"));
            }
        }
        if (element3.elementText("formattedActualOwner") != null) {
            iterator = element2.addElement("owner");
            object = iterator.addElement("name");
            object.setText(element3.elementText("formattedActualOwner"));
            element = iterator.addElement("camId");
            element.setText(element3.elementText("actualOwner"));
        }
        iterator = element2.addElement("status");
        object = element3.elementText("status");
        if (((String)object).equals("COMPLETED")) {
            iterator.setText("complete");
        } else {
            iterator.setText("incomplete");
        }
        element = element2.addElement("category");
        element.addAttribute("scheme", "http://www.ibm.com/xmlns/prod/cognos/collaboration");
        element.addAttribute("term", "todo");
        element.addAttribute("label", "To Do");
        return element2;
    }

    protected Document getResponseDoc(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException {
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string2 = "<n1:getTaskInfo xmlns:n1=\"http://www.example.org/WS-HT/api/xsd\"><n1:identifier>" + string + "</n1:identifier>" + "</n1:getTaskInfo>";
        hTTPRequest.setSoapRequestBody(string2);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        String string3 = hTTPRequest.retrieveContent();
        try {
            Document document = Utilities.parseText(string3);
            return document;
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
    }

    private Element getTaskElement(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string, Document document) throws CCSGeneralException, CCSAuthenticationException {
        Element element = document.getRootElement().element("Body").element("getTaskInfoResponse");
        if (element == null) {
            throw new CCSGeneralException("SERVER_ERROR", 500);
        }
        Element element2 = element.element("task");
        String string2 = element2.elementText("createdOn");
        String string3 = element2.elementText("formattedCreatedBy");
        String string4 = element2.elementText("createdBy");
        Document document2 = AAtomPubCommand.startFeed(string, string);
        String string5 = string;
        String string6 = element2.elementText("presentationSubject");
        String string7 = HTSConnector.getDescription(cookieArray, bIBusEnvelope, string);
        String string8 = element2.elementText("locale");
        Element element3 = AAtomPubCommand.addEntry(document2, string6, string5, string2, string7, string3, string4, string8, null);
        return element3;
    }

    public static String getDescription(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string2 = "<n1:getTaskDescription xmlns:n1=\"http://www.example.org/WS-HT/api/xsd\"><n1:identifier>" + string + "</n1:identifier>" + "<n1:contentType>" + "text/plain" + "</n1:contentType>" + "</n1:getTaskDescription>";
        hTTPRequest.setSoapRequestBody(string2);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        String string3 = hTTPRequest.retrieveContent();
        try {
            Document document = Utilities.parseText(string3);
            HTSConnector.checkForSOAPFaults(document);
            Element element = document.getRootElement().element("Body").element("getTaskDescriptionResponse");
            return element.elementText("description");
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
    }

    public static String deleteTopicEntry(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException {
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string2 = "<ext:deleteTask xmlns:ext=\"http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext\"><ext:identifier>" + string + "</ext:identifier>" + "</ext:deleteTask>";
        hTTPRequest.setSoapRequestBody(string2);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        String string3 = hTTPRequest.retrieveContent();
        return string3;
    }

    public String createTodoSection(Document document) {
        Element element = document.getRootElement();
        if (element.element("category") == null || !element.element("category").attributeValue("term").equals("todo")) {
            return "";
        }
        String string = "<tns:createTodoTask xmlns:ext=\"http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext\" xmlns:ht=\"http://www.example.org/WS-HT\" xmlns:hts=\"http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1\" xmlns:tns=\"http://www.ibm.com/xmlns/prod/cognos/internal/hts/todotask/_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">       <hts:beplTask name=\"todo1\">         <hts:peopleAssignments>           <ht:potentialOwners>             <ht:from logicalPeopleGroup=\"CAM\">               <ht:literal>                 <ht:organizationalEntity>                   <ht:users>                     <ht:user>" + element.element("owner").elementText("camId") + "</ht:user>" + "                   </ht:users>" + "                 </ht:organizationalEntity>" + "               </ht:literal>" + "             </ht:from>" + "           </ht:potentialOwners>" + "         </hts:peopleAssignments>" + "         <hts:priority>1</hts:priority>" + "       </hts:beplTask>" + "       <tns:todoTask>" + "         <subject xmlns=\"\">" + element.elementText("title") + "</subject>" + "         <description xmlns=\"\">" + element.elementText("summary") + "</description>" + "         <completeUntil xmlns=\"\">" + element.elementText("dueDate") + "</completeUntil>" + "         <doEmailNotification xmlns=\"\">true</doEmailNotification>" + "       </tns:todoTask>" + "     </tns:createTodoTask>";
        return string;
    }

    @Override
    protected String markTaskComplete(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string2 = "<n1:complete xmlns:n1=\"http://www.example.org/WS-HT/api/xsd\">\t<n1:identifier>" + string + "</n1:identifier>" + "\t<n1:taskData>" + "\t\t<approveOutput>" + "\t\t\t<approvedReports>" + "\t\t\t\t<path>////sdfsjdlfjsldfj</path>" + "\t\t\t\t<path>////sdfsjdlfjsldfj</path>" + "\t\t\t</approvedReports>" + "\t\t\t<rejectedReports>" + "\t\t\t\t<path>////sdfsjdlfjsldfj</path>" + "\t\t\t</rejectedReports>" + "\t\t</approveOutput>" + "\t</n1:taskData>" + "</n1:complete>";
        hTTPRequest.setSoapRequestBody(string2);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        hTTPRequest.retrieveContent();
        return this.getTodoElement(cookieArray, bIBusEnvelope, string).asXML();
    }

    @Override
    protected String markTaskIncomplete(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope, String string) throws CCSGeneralException, CCSAuthenticationException {
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string2 = "<reopen xmlns=\"http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext\">  <identifier>" + string + "</identifier>" + "</reopen>";
        hTTPRequest.setSoapRequestBody(string2);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        hTTPRequest.retrieveContent();
        return this.getTodoElement(cookieArray, bIBusEnvelope, string).asXML();
    }

    protected static void checkForSOAPFaults(Document document) throws CCSAuthenticationException {
        Element element = document.getRootElement().element("Body");
        Iterator iterator = element.elementIterator("Fault");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (!"MSG_US_INVALID_USER_DATA".equals(element2.elementText("faultcode"))) continue;
            throw new CCSAuthenticationException();
        }
    }
}

