/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.collaboration;

import com.cognos.ccs.content.HTTPRequest;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.command.AAtomPubCommand;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class InboxConnector {
    public static String getInboxFeed(String string, Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope) throws CCSGeneralException, CCSAuthenticationException {
        Locale locale = ConfigMgr.getJavaLocale(bIBusEnvelope.getUserPreferenceValue("productLocale"));
        HTTPRequest hTTPRequest = new HTTPRequest(cookieArray, bIBusEnvelope);
        String string2 = "<ns1:query xmlns:ns1=\"http://www.example.org/WS-HT/api/xsd\"><ns1:whereClause>Task.folderName=INBOX</ns1:whereClause><ns1:orderByClause/></ns1:query>";
        hTTPRequest.setSoapRequestBody(string2);
        hTTPRequest.setSoapAction("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
        String string3 = hTTPRequest.retrieveContent();
        Document document = null;
        try {
            Document document2 = Utilities.parseText(string3);
            InboxConnector.checkForSOAPFaults(document2);
            Element element = document2.getRootElement();
            document = AAtomPubCommand.startFeed("My Inbox", "My Inbox");
            Namespace namespace = new Namespace("d", "http://www.ibm.com/xmlns/prod/cognos/inbox");
            document.getRootElement().add(namespace);
            Element element2 = document.getRootElement();
            element2 = element2.addElement("link");
            element2.addAttribute("type", "text/html");
            element2.addAttribute("rel", "alternate");
            element2.addAttribute("href", ConfigMgr.getInstance().getCognosGateway() + "/myinbox");
            element2 = element.element("Body");
            element2 = element2.element("queryResponse");
            element2 = element2.element("query");
            Iterator iterator = element2.elementIterator("row");
            while (iterator.hasNext()) {
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                Element element3 = (Element)iterator.next();
                element2 = element3.element("id");
                if (element2 != null) {
                    string4 = element2.getText();
                }
                if ((element2 = element3.element("presentationSubject")) != null) {
                    string5 = element2.getText();
                }
                if ((element2 = element3.element("presentationDescription")) != null) {
                    string7 = element2.getText();
                }
                if ((element2 = element3.element("createdOn")) != null) {
                    string6 = element2.getText();
                }
                String string8 = element3.elementText("locale");
                String string9 = element3.elementText("formattedActualOwner");
                if (string9 == null || string9.equals("")) {
                    string9 = CCLMessage.getResMessage("USER_UNAVAILABLE", locale);
                } else if (string9.equals("Anonymous")) {
                    string9 = CCLMessage.getResMessage("NONE", locale);
                }
                String string10 = "";
                Element element4 = AAtomPubCommand.addEntry(document, string5, string4, string6, string7, string9, null, string8, string10);
                Element element5 = element4.addElement("category");
                element5.addAttribute("scheme", "http://www.ibm.com/xmlns/prod/cognos/collaboration");
                element5.addAttribute("term", "task");
                element5.addAttribute("label", "Task");
                Element element6 = element4.addElement(new QName("dueDate", namespace));
                element6.setText(element3.elementText("dueDate"));
                Element element7 = element4.addElement(new QName("status", namespace));
                element7.setText(element3.elementText("status"));
                element2 = element4.addElement("link");
                element2.addAttribute("type", "text/html");
                element2.addAttribute("rel", "alternate");
                element2.addAttribute("href", ConfigMgr.getInstance().getCognosGateway() + "/myinbox?MsgTaskId=" + string4);
                element2 = element4.addElement("link");
                element2.addAttribute("type", "image/gif");
                element2.addAttribute("rel", "http://www.ibm.com/xmlns/prod/cognos/rel/icon16");
                element2.addAttribute("href", string + "/" + element3.elementText("taskIconPath"));
            }
        }
        catch (DocumentException documentException) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        return document.asXML();
    }

    protected static void checkForSOAPFaults(Document document) throws CCSAuthenticationException, CCSGeneralException {
        Element element = document.getRootElement().element("Header");
        if (element == null) {
            return;
        }
        Element element2 = element.element("biBusHeader");
        if (element2 == null) {
            return;
        }
        Element element3 = element2.element("CAM");
        if (element3 == null) {
            return;
        }
        Element element4 = element3.element("exception");
        if (element4 != null) {
            throw new CCSAuthenticationException(element4);
        }
        Element element5 = document.getRootElement().element("Body");
        Element element6 = element5.element("Fault");
        if (element6 != null) {
            throw new CCSGeneralException("INBOX_ERROR", 500);
        }
    }
}

