/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.ccs.atom.AtomGenerator;
import com.cognos.ccs.cache.ConversationCache;
import com.cognos.ccs.cache.PromptAnswersCache;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.PromptPage;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.content.RDSSchema;
import com.cognos.ccs.content.SearchPromptValue;
import com.cognos.ccs.content.StyleGroup;
import com.cognos.ccs.content.StyleParser;
import com.cognos.ccs.drill.ContextData;
import com.cognos.ccs.drill.ContextList;
import com.cognos.ccs.drill.MetadataMap;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.BaseRDSSession;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.CCSSession;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.ManagedAttachment;
import com.cognos.ccs.service.Transform;
import com.cognos.ccs.utility.OutputFormatEnums;
import com.cognos.ccs.utility.Utilities;
import com.cognos.ccs.wsdl.SpecValidator;
import com.cognos.developer.schemas.bibus._3.Analysis;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class Cognos8ContentProvider
extends ContentProvider {
    protected ManagedAttachment m_attachment = null;
    protected String m_SavedXML;
    protected static Transform MetaTransform = null;
    protected static Transform ColoradoMetaTransform = null;
    protected static Transform V3MetaTransform = null;
    protected static Transform PromptsTransform = null;
    protected static Transform V3PromptsTransform = null;
    protected static Transform LayoutTransform = null;
    protected static Transform ColoradoLayoutTransform = null;
    protected static Transform V3LayoutTransform = null;
    protected static Transform UpgradeMetaTransform = null;
    protected static Transform TreePromptTranform = null;
    protected static Transform V3TreePromptTranform = null;
    protected static String m_XHTMLEntities = null;
    protected static Transform Spec2Atom = null;
    private HashSet<String> m_addedParameters;
    private static String INIT_OUTPUT = "output";
    private static String INIT_DRILL = "drill";
    private SpecValidator wsdlValidator = null;

    Cognos8ContentProvider(String string, Cognos8Connector cognos8Connector) {
        this.m_ReportPath = string;
        this.m_Connection = cognos8Connector;
        this.m_Schema = RDSSchema.getInstance(Constants.NamespaceVersion.V1);
        this.m_attachment = null;
        this.m_SavedXML = null;
        this.m_addedParameters = new HashSet();
    }

    protected static synchronized void initTransforms() {
        if (null == MetaTransform) {
            MetaTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog8/meta.xsl"));
        }
        if (null == PromptsTransform) {
            PromptsTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog8/prompts.xsl"));
        }
        if (null == LayoutTransform) {
            LayoutTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog8/layout.xsl"));
        }
        if (null == UpgradeMetaTransform) {
            UpgradeMetaTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog8/upgradeMeta.xsl"));
        }
        if (Spec2Atom == null) {
            Spec2Atom = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/raas/spec2atom.xsl"), null, null);
        }
        if (TreePromptTranform == null) {
            TreePromptTranform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog8/treeprompts.xsl"), null, null);
        }
        if (ColoradoMetaTransform == null) {
            ColoradoMetaTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog10/meta.xsl"));
        }
        if (ColoradoLayoutTransform == null) {
            ColoradoLayoutTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog10/layout.xsl"));
        }
        if (V3MetaTransform == null) {
            V3MetaTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog10/V3/meta.xsl"));
        }
        if (V3LayoutTransform == null) {
            V3LayoutTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog10/V3/layout.xsl"));
        }
        if (null == V3PromptsTransform) {
            V3PromptsTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog8/V3/prompts.xsl"));
        }
        if (V3TreePromptTranform == null) {
            V3TreePromptTranform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/cog8/V3/treeprompts.xsl"), null, null);
        }
    }

    @Override
    public InputStream[] getInputStreams() throws CCSGeneralException {
        try {
            if (this.m_SavedXML != null) {
                Object object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    object = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
                    ((Writer)object).write(this.m_SavedXML);
                    ((OutputStreamWriter)object).flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                object = byteArrayOutputStream.toByteArray();
                return new InputStream[]{new ByteArrayInputStream((byte[])object)};
            }
            if (this.m_attachment != null) {
                return new InputStream[]{this.m_attachment.getStream()};
            }
        }
        catch (Exception exception) {
            throw new CCSGeneralException("PARSE_STREAM_ERROR", 500);
        }
        return null;
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, false, false, false);
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl3, false, false);
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3, boolean bl4) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl3, bl4, false);
    }

    @Override
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3, boolean bl4, boolean bl5) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        try {
            conversation = this.beginRetrieveData(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl5);
            conversation.setProperty("GENERATE_RELATIVE_URL", bl3);
            conversation.setProperty("useGatewayURI", bl4);
            while (!conversation.getProperty("status").equals("complete")) {
                conversation = this.checkDataStatus(conversation);
            }
            this.retrieveDataOutput(conversation);
            return conversation;
        }
        catch (CCSPromptException cCSPromptException) {
            cCSPromptException.setProvider(this);
            throw cCSPromptException;
        }
    }

    @Override
    @Deprecated
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveMetaContent(promptValueArray, bl, false, false);
    }

    @Override
    @Deprecated
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl, boolean bl2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveMetaContent(promptValueArray, bl, bl2, false);
    }

    @Override
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl, boolean bl2, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        try {
            String string = this.getSession().getGatewayURL(bl, bl2);
            String string2 = this.m_Connection.getReportSpecification(this.m_ReportPath, PromptValue.toPValueArray(promptValueArray), this.getSession(), true, string);
            if (this.wsdlValidator != null) {
                this.wsdlValidator.validateSpec(string2);
            }
            this.convertSpecToInfo(promptValueArray, string2, true);
        }
        catch (CCSPromptException cCSPromptException) {
            cCSPromptException.setProvider(this);
            throw cCSPromptException;
        }
    }

    @Override
    public void retrieveV1MetaContent(PromptValue[] promptValueArray, boolean bl) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveV1MetaContent(promptValueArray, bl, false);
    }

    @Override
    public void retrieveV1MetaContent(PromptValue[] promptValueArray, boolean bl, boolean bl2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        try {
            MetaTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xsltv1/cog8/meta.xsl"));
            LayoutTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xsltv1/cog8/layout.xsl"));
            this.retrieveMetaContent(promptValueArray, bl, bl2, false);
        }
        catch (CCSPromptException cCSPromptException) {
            cCSPromptException.setProvider(this);
            throw cCSPromptException;
        }
    }

    private void convertSpecToInfoV2orV3(PromptValue[] promptValueArray, String string, Constants.RequestVersion requestVersion) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        Object object;
        Object object2;
        Object object32;
        StyleParser styleParser2;
        List list;
        Object object4;
        Cognos8ContentProvider.initTransforms();
        String string2 = requestVersion == Constants.RequestVersion.V3 ? "http://www.ibm.com/xmlns/prod/cognos/rds/types/201310" : "http://developer.cognos.com/schemas/rds/types/2";
        String string3 = requestVersion == Constants.RequestVersion.V3 ? "http://www.ibm.com/xmlns/prod/cognos/layoutData/201310" : "http://www.ibm.com/xmlns/prod/cognos/layoutData/200904";
        Transform transform = requestVersion == Constants.RequestVersion.V3 ? V3MetaTransform : ColoradoMetaTransform;
        Transform transform2 = requestVersion == Constants.RequestVersion.V3 ? V3LayoutTransform : ColoradoLayoutTransform;
        Element element = transform.convert(string);
        Element element2 = transform2.convert(string);
        element.add(element2);
        Namespace namespace = element.getNamespaceForURI(string2);
        Element element3 = this.getParameters(string, requestVersion == Constants.RequestVersion.V3 ? Constants.NamespaceVersion.V3 : Constants.NamespaceVersion.V2);
        if (null != element3) {
            element.add(element3);
        }
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        simpleNamespaceContext.addNamespace("rds", string2);
        XPath xPath = element.createXPath("./rds:document/rds:page//rds:lcr");
        xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        List list2 = xPath.selectNodes((Object)element);
        Iterator iterator = list2.iterator();
        HashMap<String, Document> hashMap = new HashMap<String, Document>();
        Element element4 = null;
        Element element5 = null;
        String string4 = null;
        Element element6 = null;
        String string5 = null;
        String string6 = null;
        Document document = null;
        while (iterator.hasNext()) {
            element4 = (Element)iterator.next();
            element5 = element4.element("lcrID");
            string4 = element5.getTextTrim();
            element6 = element4.element("path");
            string6 = element6.getTextTrim();
            document = (Document)hashMap.get(string6);
            if (null == document) {
                object4 = this.getSession().getAbsoluteGatewayURL();
                string5 = this.m_Connection.getReportSpecification(string6, PromptValue.toPValueArray(promptValueArray), this.getSession(), true, (String)object4);
                list = transform.convert(string5);
                hashMap.put(string6, list.getDocument());
            }
            object4 = document.createXPath("/temp/rds:document/rds:page//ldx:id");
            object4.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            list = object4.selectNodes((Object)document);
            for (StyleParser styleParser2 : list) {
                if (!string4.equals(styleParser2.getTextTrim())) continue;
                element4.getParent().add((Element)styleParser2.getParent().clone());
                break;
            }
            element4.detach();
        }
        list2.clear();
        hashMap.clear();
        object4 = element2.createXPath("//rds:CSSStyle | //rds:RefStyle");
        object4.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        list = object4.selectNodes((Object)element2);
        Iterator iterator2 = list.iterator();
        styleParser2 = new StyleParser(requestVersion == Constants.RequestVersion.V3 ? Constants.NamespaceVersion.V3 : Constants.NamespaceVersion.V2);
        while (iterator2.hasNext()) {
            Element element7;
            object32 = (Element)iterator2.next();
            if (object32.getName().equals("RefStyle")) {
                object2 = object32.getTextTrim();
                object = object32.getParent();
                element7 = object.addElement(new QName("style", new Namespace("ldx", string3)));
                element7.setText((String)object2);
            } else {
                object2 = styleParser2.parseSingleCSSStyle(object32.getTextTrim());
                object = object32.getParent();
                element7 = object.addElement(new QName("style", new Namespace("ldx", string3)));
                element7.setText((String)object2);
            }
            object32.detach();
        }
        object4 = element2.createXPath("//rds:ClassStyle");
        object4.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        list = object4.selectNodes((Object)element2);
        for (Object object32 : list) {
            object2 = object32.element("Value");
            object = object32.element("Name");
            if (object != null && object2 != null) {
                styleParser2.parseNamedCSSStyle(object2.getTextTrim(), object.getTextTrim());
            }
            object32.detach();
        }
        object32 = styleParser2.getStyles();
        object2 = object32.iterator();
        while (object2.hasNext()) {
            object = (StyleGroup)object2.next();
            element2.add(((StyleGroup)object).toXML());
        }
        object = element.asXML();
        this.m_SavedXML = object = ((String)object).replaceAll(string2, this.getSession().getResponseNamespace().getURI());
    }

    private void convertSpecToInfo(PromptValue[] promptValueArray, String string, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        if (!bl) {
            this.convertSpecToInfoV2orV3(promptValueArray, string, this.getRequestVersion());
        } else {
            Object object;
            Object object2;
            Object object32;
            StyleParser styleParser2;
            List list;
            Object object4;
            Cognos8ContentProvider.initTransforms();
            Element element = MetaTransform.convert(string);
            Element element2 = LayoutTransform.convert(string);
            element.add(element2);
            Element element3 = this.getParameters(string, Constants.NamespaceVersion.V1);
            if (null != element3) {
                element.add(element3);
            }
            SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
            simpleNamespaceContext.addNamespace("rds", "http://developer.cognos.com/schemas/rds/types/1");
            XPath xPath = element.createXPath("./rds:document/rds:page//rds:lcr");
            xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            List list2 = xPath.selectNodes((Object)element);
            Iterator iterator = list2.iterator();
            HashMap<String, Document> hashMap = new HashMap<String, Document>();
            Element element4 = null;
            Element element5 = null;
            String string2 = null;
            Element element6 = null;
            String string3 = null;
            String string4 = null;
            Document document = null;
            while (iterator.hasNext()) {
                element4 = (Element)iterator.next();
                element5 = element4.element("lcrID");
                string2 = element5.getTextTrim();
                element6 = element4.element("path");
                string4 = element6.getTextTrim();
                document = (Document)hashMap.get(string4);
                if (null == document) {
                    object4 = this.getSession().getAbsoluteGatewayURL();
                    string3 = this.m_Connection.getReportSpecification(string4, PromptValue.toPValueArray(promptValueArray), this.getSession(), true, (String)object4);
                    list = MetaTransform.convert(string3);
                    hashMap.put(string4, list.getDocument());
                }
                object4 = document.createXPath("/temp/rds:document/rds:page//rdsCM:id");
                object4.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
                list = object4.selectNodes((Object)document);
                for (StyleParser styleParser2 : list) {
                    if (!string2.equals(styleParser2.getTextTrim())) continue;
                    element4.getParent().add((Element)styleParser2.getParent().clone());
                    break;
                }
                element4.detach();
            }
            list2.clear();
            hashMap.clear();
            object4 = element2.createXPath("//rds:CSSStyle | //rds:RefStyle");
            object4.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            list = object4.selectNodes((Object)element2);
            Iterator iterator2 = list.iterator();
            styleParser2 = new StyleParser(Constants.NamespaceVersion.V1);
            while (iterator2.hasNext()) {
                Element element7;
                object32 = (Element)iterator2.next();
                if (object32.getName().equals("RefStyle")) {
                    object2 = object32.getTextTrim();
                    object = object32.getParent();
                    element7 = object.addElement(this.m_Schema.getStyleIDQN());
                    element7.setText((String)object2);
                } else {
                    object2 = styleParser2.parseSingleCSSStyle(object32.getTextTrim());
                    object = object32.getParent();
                    element7 = object.addElement(this.m_Schema.getStyleIDQN());
                    element7.setText((String)object2);
                }
                object32.detach();
            }
            object4 = element2.createXPath("//rds:ClassStyle");
            object4.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            list = object4.selectNodes((Object)element2);
            for (Object object32 : list) {
                object2 = object32.element("Value");
                object = object32.element("Name");
                if (object != null && object2 != null) {
                    styleParser2.parseNamedCSSStyle(object2.getTextTrim(), object.getTextTrim());
                }
                object32.detach();
            }
            object32 = styleParser2.getStyles();
            object2 = object32.iterator();
            while (object2.hasNext()) {
                object = (StyleGroup)object2.next();
                element2.add(((StyleGroup)object).toXML());
            }
            object = element.asXML();
            this.m_SavedXML = object = ((String)object).replaceAll("http://developer.cognos.com/schemas/rds/types/1", this.getSession().getResponseNamespace().getURI());
        }
    }

    private static synchronized String getXHTMLEntities() {
        try {
            if (m_XHTMLEntities != null) {
                return m_XHTMLEntities;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(ConfigMgr.getInstance().getFileStream("/xslt/misc/xhtml.txt"), "UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("FLRESP_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            return null;
        }
    }

    @Override
    public Conversation retrievePromptDescription(PromptValue[] promptValueArray, SearchPromptValue searchPromptValue, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        return this.retrievePromptDescription(promptValueArray, searchPromptValue, conversation, false);
    }

    @Override
    public Conversation retrievePromptDescription(PromptValue[] promptValueArray, SearchPromptValue searchPromptValue, Conversation conversation, boolean bl) throws CCSGeneralException, CCSAuthenticationException {
        PromptPage promptPage;
        Cognos8ContentProvider.initTransforms();
        ParameterValue[] parameterValueArray = null;
        if (promptValueArray != null) {
            parameterValueArray = new ParameterValue[promptValueArray.length];
            for (int i = 0; i < promptValueArray.length; ++i) {
                parameterValueArray[i] = promptValueArray[i].toPValue();
            }
        }
        if ((promptPage = this.m_Connection.getPromptPages(this.m_ReportPath, conversation, parameterValueArray, searchPromptValue, this.getSession(), bl)) != null) {
            String string = Cognos8ContentProvider.getXHTMLEntities();
            StringBuffer stringBuffer = new StringBuffer(promptPage.getPromptXML());
            if (null != string) {
                stringBuffer.insert(0, string);
            }
            Element element = this.getRequestVersion() == Constants.RequestVersion.V3 ? V3PromptsTransform.convert(stringBuffer.toString()) : PromptsTransform.convert(stringBuffer.toString());
            PromptValue[] promptValueArray2 = promptPage.getAnswers();
            if (promptValueArray2 != null) {
                for (int i = 0; i < promptValueArray2.length; ++i) {
                    element.add(promptValueArray2[i].toXML(this.getSession().getResponseNamespace(), true));
                }
            }
            this.m_SavedXML = element.asXML();
            return promptPage.getConversation();
        }
        this.m_SavedXML = this.getRequestVersion() == Constants.RequestVersion.V3 ? "<rds:prompts xmlns:rds=\"http://www.ibm.com/xmlns/prod/cognos/rds/types/201310\"/>" : "<rds:prompts xmlns:rds=\"http://developer.cognos.com/schemas/rds/types/2\"/>";
        return null;
    }

    @Override
    public void upgradeIDs(String string, String[] stringArray, BaseRDSSession baseRDSSession, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        this.upgradeIDs(string, stringArray, baseRDSSession, bl, false);
    }

    @Override
    public void upgradeIDs(String string, String[] stringArray, BaseRDSSession baseRDSSession, boolean bl, boolean bl2) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        this.m_SavedXML = "";
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("temp");
        String string2 = this.getSession().getGatewayURL(bl, bl2);
        String string3 = baseRDSSession.getC8Connector().getReportSpecification(string, null, this.getSession(), true, string2);
        UpgradeMetaTransform.convertToCCS(string3, element);
        List list = Cognos8ContentProvider.getIdNodes(document.getRootElement());
        for (int i = 0; i < stringArray.length; ++i) {
            String string4;
            Element element2;
            String string5 = null;
            boolean bl3 = false;
            boolean bl4 = false;
            Iterator iterator = list.iterator();
            Element element3 = null;
            while (iterator.hasNext()) {
                element3 = (Element)iterator.next();
                if (stringArray[i].equals(element3.getTextTrim())) {
                    bl3 = true;
                    break;
                }
                element2 = element3.getParent().element("name");
                if (element2 == null || !(string4 = element2.getTextTrim()).equals(stringArray[i])) continue;
                bl3 = true;
                bl4 = true;
                break;
            }
            if (bl4) {
                string5 = stringArray[i];
            } else if (bl3) {
                element2 = element3.getParent().element("name");
                string5 = element2 == null ? null : element2.getTextTrim();
            }
            element2 = DocumentHelper.createElement((QName)this.m_Schema.getUMappingQN());
            element2.addElement(this.m_Schema.getUOldQN()).addText(stringArray[i]);
            string4 = element2.addElement(this.m_Schema.getUNewQN());
            if (string5 != null) {
                string4.addText(string5);
            }
            element2.addElement(this.m_Schema.getUFoundQN()).addText(bl3 ? "true" : "false");
            this.m_SavedXML = this.m_SavedXML + element2.asXML();
        }
    }

    public static List getIdNodes(Element element) {
        List list = element.selectNodes("//*[local-name()='id']");
        return list;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.m_attachment != null) {
            this.m_attachment.delete();
        }
    }

    @Override
    @Deprecated
    public Conversation beginRetrieveData(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.beginRetrieveData(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, false);
    }

    @Override
    public Conversation beginRetrieveData(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string6;
        boolean bl4 = false;
        String string7 = "layoutDataXML";
        boolean bl5 = false;
        if (conversation != null && !Utilities.isNullOrEmpty(string6 = (String)conversation.getProperty("PROVIDER_OUTPUT_FORMAT"))) {
            string7 = string6;
            bl5 = true;
        }
        if ("VERSION_NAME".equals(string) || !Utilities.isNullOrEmpty(string5) || !Utilities.isNullOrEmpty(string4)) {
            bl4 = true;
        }
        int n = 100;
        if ("LIMITED_DATA".equals(string)) {
            n = 101;
        } else if ("NO_DATA".equals(string)) {
            n = 102;
        } else if ("LATEST".equals(string) && !bl3) {
            bl4 = this.m_Connection.hasVersion(this.m_ReportPath, string7);
        } else if ("LOND".equals(string)) {
            n = 102;
            bl4 = this.m_Connection.hasVersion(this.m_ReportPath, string7);
        }
        ParameterValue[] parameterValueArray = PromptValue.toPValueArray(promptValueArray);
        if (conversation == null) {
            conversation = new Conversation(this.m_Connection.getRSBus());
        }
        conversation.setProperty("searchPath", this.m_ReportPath);
        conversation.setProperty("promptValues", parameterValueArray);
        if (bl4) {
            conversation.setProperty("burstID", string5);
            conversation.setProperty("burstKey", string4);
            conversation.setProperty("versionName", string3);
            conversation.setProperty("versionPath", string2);
            conversation.setProperty("versionType", string);
            conversation.setProperty("versioned", "true");
            conversation.setProperty("status", "complete");
        } else {
            conversation.setProperty("DATA_MODE_KEY", new Integer(n));
            conversation.setProperty("initialize", "output");
            conversation.setProperty("PAGED_KEY", new Boolean(bl));
            conversation.setProperty("PROMPT_KEY", new Boolean(bl2));
            conversation.setProperty("status", "working");
        }
        if (bl5) {
            conversation.setProperty("PROVIDER_OUTPUT_FORMAT", string7);
        }
        return conversation;
    }

    @Override
    public void retrieveDrillOutput(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        this.m_attachment = this.m_Connection.getDrillOutput(conversation, this.getSession());
    }

    @Override
    public Conversation checkDataStatus(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string = (String)conversation.getProperty("initialize");
        String string2 = this.getGatewayURL(conversation);
        if (INIT_OUTPUT.equals(string)) {
            conversation.removeProperty("initialize");
            String string3 = (String)conversation.getProperty("searchPath");
            Boolean bl = (Boolean)conversation.getProperty("PAGED_KEY");
            Boolean bl2 = (Boolean)conversation.getProperty("PROMPT_KEY");
            Integer n = (Integer)conversation.getProperty("DATA_MODE_KEY");
            ParameterValue[] parameterValueArray = (ParameterValue[])conversation.getProperty("promptValues");
            return this.m_Connection.beginRunRequest(string3, parameterValueArray, bl, n, conversation, bl2, this.m_Compatability, string2);
        }
        if (INIT_DRILL.equals(string)) {
            String string4 = (String)conversation.getProperty("sourceID");
            String string5 = (String)conversation.getProperty("context");
            String string6 = (String)conversation.getProperty("direction");
            return this.beginDrill(string5, string4, string6);
        }
        return this.m_Connection.checkRunRequest(conversation, string2);
    }

    @Override
    public void retrieveDataOutput(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        try {
            String string = (String)conversation.getProperty("versioned");
            if (null != string) {
                String string2 = (String)conversation.getProperty("versionType");
                String string3 = (String)conversation.getProperty("versionPath");
                String string4 = (String)conversation.getProperty("versionName");
                String string5 = (String)conversation.getProperty("burstKey");
                String string6 = (String)conversation.getProperty("burstID");
                ParameterValue[] parameterValueArray = (ParameterValue[])conversation.getProperty("promptValues");
                this.m_VersionBase = this.m_Connection.generateBaseVersion(this.m_ReportPath, string2, string4, string3, string5, string6);
                this.m_attachment = this.m_Connection.getReportVersion(this.m_ReportPath, parameterValueArray, 0, string2, string4, string3, string5, string6, this.getSession(), conversation);
            } else {
                Boolean bl = (Boolean)conversation.getProperty("includePageBreaks");
                if (bl != null && bl.booleanValue()) {
                    this.m_VersionBase = this.m_Connection.generateVersionBaseWithPGBreaks((String)conversation.getProperty("reportStoreId"));
                }
                this.m_attachment = conversation.getAttachment();
                if (this.m_attachment != null) {
                    conversation.removeProperty("ATTACHMENTS_KEY");
                } else {
                    String string7 = this.getGatewayURL(conversation);
                    this.m_attachment = this.m_Connection.getRunOutput(conversation, string7);
                }
            }
        }
        catch (CCSPromptException cCSPromptException) {
            cCSPromptException.setProvider(this);
            throw cCSPromptException;
        }
    }

    @Override
    public void saveDataContent(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.m_Connection.saveOutput(conversation);
    }

    @Override
    public void cancelConversation(Conversation conversation) throws CCSGeneralException {
        this.m_Connection.cancelRunRequest(conversation);
    }

    @Override
    public void releaseConversation(Conversation conversation) throws CCSGeneralException {
        if (conversation != null && !"true".equals((String)conversation.getProperty("versioned"))) {
            this.m_Connection.releaseConversation(conversation);
        }
    }

    @Override
    public Conversation beginDrill(String string, String string2, String string3) throws CCSGeneralException {
        try {
            CCSSession cCSSession = this.getSession();
            ConversationCache conversationCache = this.m_Connection.conversationCache();
            Conversation conversation = conversationCache.getConversation(string2);
            this.m_Connection.beginDrill(conversation, string, string3, cCSSession);
            conversation.removeProperty("initialize");
            conversationCache.updateConversation(string2, conversation);
            return conversation;
        }
        catch (Exception exception) {
            throw new CCSGeneralException("DRILL_REQUEST_ERROR", 500);
        }
    }

    @Override
    public void drill(String string, String string2, String string3) throws CCSGeneralException {
        try {
            Conversation conversation = this.beginDrill(string, string2, string3);
            while (!conversation.getProperty("status").equals("complete")) {
                conversation = this.checkDataStatus(conversation);
            }
            this.retrieveDrillOutput(conversation);
        }
        catch (Exception exception) {
            throw new CCSGeneralException("DRILL_REQUEST_ERROR", 500);
        }
    }

    @Override
    public String generateAtomFeed(String string, String string2, String string3, String string4) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        try {
            String string5 = this.m_Connection.getReportSpecification(this.m_ReportPath, null, this.getSession(), true, string4);
            AtomGenerator atomGenerator = new AtomGenerator();
            Element element = atomGenerator.convertSpec(string5, string2, string3);
            return this.prepareFeed(string, element, string4);
        }
        catch (CCSPromptException cCSPromptException) {
            cCSPromptException.setProvider(this);
            throw cCSPromptException;
        }
    }

    @Override
    public Conversation beginRetrieveMeta(PromptValue[] promptValueArray, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        return this.beginRetrieveMeta(promptValueArray, bl, false);
    }

    @Override
    public Conversation beginRetrieveMeta(PromptValue[] promptValueArray, boolean bl, boolean bl2) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        CCSSession cCSSession = this.getSession();
        String string = cCSSession.getGatewayURL(bl, bl2);
        Conversation conversation = this.m_Connection.beginReportSpecRequest(this.m_ReportPath, PromptValue.toPValueArray(promptValueArray), string);
        conversation.setProperty("searchPath", this.m_ReportPath);
        return conversation;
    }

    @Override
    public void retrieveMetaOutput(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        try {
            String string = Utilities.removeNamespaceFormSpec((String)conversation.getProperty("reportspec"));
            boolean bl = Utilities.parseOptionalObjectBoolean(conversation.getProperty("ReportInfoLegacyCall"), true);
            this.convertSpecToInfo(null, string, bl);
        }
        catch (CCSPromptException cCSPromptException) {
            cCSPromptException.setProvider(this);
            throw cCSPromptException;
        }
    }

    @Override
    public Conversation retrieveTreePromptNode(Conversation conversation, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        if (promptValueArray == null) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        Cognos8ContentProvider.initTransforms();
        PromptPage promptPage = this.m_Connection.getTreePromptNodeChildren(conversation, PromptValue.toPValueArray(promptValueArray));
        Element element = this.getRequestVersion() == Constants.RequestVersion.V3 ? V3TreePromptTranform.convert(promptPage.getPromptXML()) : TreePromptTranform.convert(promptPage.getPromptXML());
        this.m_SavedXML = element.asXML();
        return promptPage.getConversation();
    }

    @Override
    public String getViewerURL(String string) throws CCSGeneralException, CCSAuthenticationException {
        return this.m_Connection.getViewerURL(this.m_ReportPath, string);
    }

    protected Element getParameters(String string, Constants.NamespaceVersion namespaceVersion) throws CCSGeneralException {
        try {
            Document document = Utilities.parseText(string);
            List list = document.selectNodes("//*[local-name()='filterExpression']");
            Element element = namespaceVersion == Constants.NamespaceVersion.V3 ? DocumentHelper.createElement((QName)new QName("parameters", new Namespace("", "http://www.ibm.com/xmlns/prod/cognos/rds/types/201310"))) : (namespaceVersion == Constants.NamespaceVersion.V2 ? DocumentHelper.createElement((QName)new QName("parameters", new Namespace("", "http://developer.cognos.com/schemas/rds/types/2"))) : DocumentHelper.createElement((QName)new QName("parameters", this.getSession().getResponseNamespace())));
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                Element element2 = (Element)list.get(i);
                String[] stringArray = element2.getText().split("\\?");
                if (stringArray.length <= 0) continue;
                bl = this.addFilterParameters(element, stringArray, namespaceVersion);
            }
            if (bl) {
                return element;
            }
            return null;
        }
        catch (Exception exception) {
            throw new CCSGeneralException("PARSE_STREAM_ERROR", 500);
        }
    }

    protected boolean addFilterParameters(Element element, String[] stringArray, Constants.NamespaceVersion namespaceVersion) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if ((i & 1) == 0) continue;
            bl = true;
            if (this.m_addedParameters.contains(stringArray[i])) continue;
            Element element2 = namespaceVersion != Constants.NamespaceVersion.V1 ? element.addElement("parameter") : element.addElement(new QName("parameter", this.getSession().getResponseNamespace()));
            element2.setText(stringArray[i]);
            this.m_addedParameters.add(stringArray[i]);
        }
        return bl;
    }

    @Override
    public ContentProvider.PromptStruct getPromptPage(String string, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        PromptAnswersCache promptAnswersCache = this.m_Connection.promptAnswersCache();
        String string2 = "";
        string2 = promptValueArray != null && promptValueArray.length > 0 ? promptAnswersCache.addPromptAnswers(promptValueArray) : promptAnswersCache.newPrompt();
        String string3 = this.m_Connection.formCCSPromptURL(string, this.m_ReportPath, string2);
        return new ContentProvider.PromptStruct(this, string3, string2);
    }

    @Override
    public String generateAtomFeed_DS(String string, String string2, String string3, String string4, String string5, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        Object object = CCSLogger.getInstance().startTimer(0, "execute", "Cognos8ContentProvider:generateAtomFeed_DS", null);
        try {
            String[] stringArray;
            PropEnum[] propEnumArray = new PropEnum[]{PropEnum.permissions};
            BaseClass[] baseClassArray = this.m_Connection.queryCM(this.m_ReportPath, propEnumArray);
            boolean bl2 = false;
            boolean bl3 = false;
            if (baseClassArray.length > 0) {
                if (baseClassArray[0] instanceof Analysis) {
                    bl2 = true;
                }
                stringArray = baseClassArray[0].getPermissions().getValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("read")) continue;
                    bl3 = true;
                    break;
                }
            }
            if (!bl3) {
                throw new CCSGeneralException("INSUFFICIENT_PERMISSIONS", 400);
            }
            stringArray = this.getSession().getAbsoluteGatewayURL();
            String string6 = this.m_Connection.getReportSpecification(this.m_ReportPath, null, this.getSession(), true, (String)stringArray);
            AtomGenerator atomGenerator = new AtomGenerator();
            Element element = null;
            element = bl ? (bl2 ? atomGenerator.convertSpec_DS_AnalysisFlat(string6, string2, string3, string4) : atomGenerator.convertSpec_DSFlat(string6, string2, string3)) : (bl2 ? atomGenerator.convertSpec_DS_Analysis(string6, string2, string3, string4) : atomGenerator.convertSpec_DS(string6, string2, string3));
            String string7 = this.prepareFeed(string, element, string5);
            return string7;
        }
        catch (CCSPromptException cCSPromptException) {
            cCSPromptException.setProvider(this);
            throw cCSPromptException;
        }
        finally {
            CCSLogger.getInstance().stopTimer(object);
        }
    }

    @Override
    public Conversation restoreConversation(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string = this.getGatewayURL(conversation);
        conversation = this.m_Connection.restoreConversation(conversation, string);
        return this.m_Connection.checkRunRequest(conversation, string);
    }

    @Override
    public ContextList getContextList(Conversation conversation, String[] stringArray) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.m_Connection.getContext(conversation, this.getSession(), stringArray);
    }

    @Override
    public MetadataMap getMetaDataMap(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.m_Connection.getMetadata(conversation, this.getSession());
    }

    @Override
    public ContextData getDataContext(Conversation conversation, String string) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String[] stringArray;
        Object object = null;
        if (string != null) {
            stringArray = ContextList.extractIds(string);
            object = this.m_Connection.getContext(conversation, this.getSession(), stringArray);
        }
        stringArray = object;
        final MetadataMap metadataMap = this.m_Connection.getMetadata(conversation, this.getSession());
        ContextData contextData = new ContextData((ContextList)stringArray){
            final /* synthetic */ ContextList val$contextsFinal;
            {
                this.val$contextsFinal = contextList;
            }

            @Override
            public MetadataMap metadataMap() {
                return metadataMap;
            }

            @Override
            public ContextList contextList() {
                return this.val$contextsFinal;
            }
        };
        return contextData;
    }

    @Override
    public Element collectPrompts(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        return this.m_Connection.collectParameterValues(conversation, this.m_ReportPath, this.getSession());
    }

    @Override
    public Element promptForward(Conversation conversation, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        Object object = conversation.getProperty("reprompt");
        SearchPromptValue searchPromptValue = null;
        boolean bl = false;
        if (object != null) {
            bl = true;
        }
        if (bl) {
            searchPromptValue = (SearchPromptValue)conversation.getProperty("search");
        }
        ParameterValue[] parameterValueArray = PromptValue.toPValueArray(promptValueArray);
        return this.m_Connection.nextPromptPage(conversation, bl, parameterValueArray, searchPromptValue, this.getSession());
    }

    @Override
    public void runForward(Conversation conversation, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        Object object = conversation.getProperty("reprompt");
        SearchPromptValue searchPromptValue = null;
        boolean bl = false;
        if (object != null) {
            bl = true;
        }
        if (bl) {
            searchPromptValue = (SearchPromptValue)conversation.getProperty("search");
        }
        ParameterValue[] parameterValueArray = PromptValue.toPValueArray(promptValueArray);
        this.m_attachment = conversation.getAttachment();
        if (this.m_attachment != null) {
            conversation.removeProperty("ATTACHMENTS_KEY");
        } else {
            this.m_attachment = this.m_Connection.forwardPageAsAttachment(conversation, bl, parameterValueArray, searchPromptValue, this.getSession());
        }
    }

    @Override
    public Element promptBack(Conversation conversation, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        ParameterValue[] parameterValueArray = PromptValue.toPValueArray(promptValueArray);
        return this.m_Connection.perviousPromptPage(conversation, parameterValueArray, this.getSession());
    }

    @Override
    public Conversation nextPage(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string = this.getGatewayURL(conversation);
        return this.m_Connection.nextReportPage(conversation, string);
    }

    @Override
    public Conversation previousPage(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string = this.getGatewayURL(conversation);
        return this.m_Connection.previousReportPage(conversation, string);
    }

    @Override
    public Conversation firstPage(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string = this.getGatewayURL(conversation);
        return this.m_Connection.firstReportPage(conversation, string);
    }

    @Override
    public Conversation lastPage(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        String string = this.getGatewayURL(conversation);
        return this.m_Connection.lastReportPage(conversation, string);
    }

    @Override
    public String getSavedOutputStoreID(String string, String string2, String string3) throws CCSGeneralException, CCSAuthenticationException {
        String string4 = this.m_Connection.getSavedOutputStoreID(this.m_ReportPath, string3, string2, string);
        return string4;
    }

    @Override
    public String getSavedOutput(String string, String string2, String string3) throws CCSGeneralException, CCSAuthenticationException {
        this.m_attachment = this.m_Connection.getSavedOutput(this.m_ReportPath, string3, string2, string);
        return this.m_attachment.getContentType();
    }

    public void setWSDLValidator(SpecValidator specValidator) {
        this.wsdlValidator = specValidator;
    }

    @Override
    public String getReportOutputContentType(String string) {
        if (OutputFormatEnums.formatXML.equalsIgnoreCaseName(string = string.toUpperCase()) || OutputFormatEnums.formatLDX.equalsIgnoreCaseName(string) || OutputFormatEnums.formatPagedLDX.equalsIgnoreCaseName(string)) {
            return "text/xml";
        }
        if (OutputFormatEnums.formatPDF.equalsIgnoreCaseName(string)) {
            return "application/pdf";
        }
        if (OutputFormatEnums.formatCSV.equalsIgnoreCaseName(string)) {
            return "text/csv";
        }
        if (OutputFormatEnums.formatSingleXLS.equalsIgnoreCaseName(string) || OutputFormatEnums.formatXLS.equalsIgnoreCaseName(string) || OutputFormatEnums.formatXLWA.equalsIgnoreCaseName(string) || OutputFormatEnums.formatXlsxData.equalsIgnoreCaseName(string)) {
            return "application/vnd.ms-excel";
        }
        if (OutputFormatEnums.formatSpreadsheetML.equalsIgnoreCaseName(string)) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (OutputFormatEnums.formatHTML.equalsIgnoreCaseName(string) || OutputFormatEnums.formatHTMLFragment.equalsIgnoreCaseName(string)) {
            return "text/html";
        }
        if (OutputFormatEnums.formatMHT.equalsIgnoreCaseName(string)) {
            return "message/rfc822";
        }
        if (OutputFormatEnums.formatXHTML.equalsIgnoreCaseName(string)) {
            return "application/xhtml+xml";
        }
        return "";
    }

    @Override
    public HashSet<String> getUserCapabilities() throws CCSGeneralException, CCSAuthenticationException {
        return this.m_Connection.getCapabilities();
    }

    @Override
    public String[] getSupportedOutputFormats() throws CCSGeneralException, CCSAuthenticationException {
        return this.getSupportedOutputFormats(this.getUserCapabilities());
    }

    @Override
    public String[] getSupportedOutputFormats(HashSet<String> hashSet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (hashSet.contains(OutputFormatEnums.capabilityCanGenerateCSVOutput.toString())) {
            arrayList.add(OutputFormatEnums.formatCSV.toString());
        }
        if (hashSet.contains(OutputFormatEnums.capabilityCanGeneratePDFOutput.toString())) {
            arrayList.add(OutputFormatEnums.formatPDF.toString());
        }
        if (hashSet.contains(OutputFormatEnums.capabilityCanGenerateXLSOutput.toString())) {
            arrayList.add(OutputFormatEnums.formatSpreadsheetML.toString());
            arrayList.add(OutputFormatEnums.formatXLWA.toString());
            arrayList.add(OutputFormatEnums.formatXlsxData.toString());
        }
        if (hashSet.contains(OutputFormatEnums.capabilityCanGenerateXMLOutput.toString())) {
            arrayList.add(OutputFormatEnums.formatXML.toString());
        }
        arrayList.add(OutputFormatEnums.formatMHT.toString());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public BiBusHeader getBiBusHeader() {
        return this.m_Connection.getRSBus();
    }

    @Override
    public ManagedAttachment getAttachment() {
        return this.m_attachment;
    }
}

