/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.ccs.cache.PromptAnswersCache;
import com.cognos.ccs.content.Cognos8ContentProvider;
import com.cognos.ccs.content.DashboardContentProvider;
import com.cognos.ccs.content.MetricsManagerContentProvider;
import com.cognos.ccs.content.PowerPlay8ContentProvider;
import com.cognos.ccs.content.PowerPlayContentProvider;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.content.RDSSchema;
import com.cognos.ccs.content.SearchPromptValue;
import com.cognos.ccs.dashboard.Dashboard;
import com.cognos.ccs.drill.ContextData;
import com.cognos.ccs.drill.ContextList;
import com.cognos.ccs.drill.MetadataMap;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.BaseRDSSession;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.CCSSession;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.ManagedAttachment;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.PowerPlay8Report;
import com.cognos.developer.schemas.bibus._3.PowerPlayReport;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.TimeZone;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public abstract class ContentProvider {
    static final String PATH_PREFIX = "[@name=";
    static final String PATH_SUFFIX = "]";
    public static final int FULL_DATA = 100;
    public static final int LIMITED_DATA = 101;
    public static final int NO_DATA = 102;
    protected RDSSchema m_Schema;
    protected Cognos8Connector m_Connection;
    protected String m_ReportPath;
    protected String m_VersionBase = null;
    protected CCSSession session = null;
    protected Constants.Compatibility m_Compatability = Constants.Compatibility.C10_3;

    public static ContentProvider getProvider(String string, Cognos8Connector cognos8Connector, Cookie[] cookieArray, CCSSession cCSSession) throws CCSGeneralException, CCSAuthenticationException {
        ContentProvider contentProvider = null;
        if (string.startsWith("metrics(")) {
            contentProvider = new MetricsManagerContentProvider(string, cognos8Connector, cookieArray);
        } else {
            Cognos8Connector.CheckReportTypeResult checkReportTypeResult = cognos8Connector.checkReportType(string);
            if (checkReportTypeResult == null) {
                if (System.getProperty("ccstestrun") != null) {
                    contentProvider = ContentProvider.getTestProvider(string, cognos8Connector, cookieArray);
                    contentProvider.setSession(cCSSession);
                    return contentProvider;
                }
                throw new CCSGeneralException("DISCOVER_ERROR", 404);
            }
            string = checkReportTypeResult.getSearchPath();
            cCSSession.setRoutingServerGroup(checkReportTypeResult.getRoutingSG());
            if (checkReportTypeResult.getBaseClass() == PowerPlayReport.class) {
                contentProvider = new PowerPlayContentProvider(checkReportTypeResult.getPPGateway(), string, cognos8Connector, cookieArray);
            } else if (checkReportTypeResult.getBaseClass() == PowerPlay8Report.class) {
                contentProvider = new PowerPlay8ContentProvider(string, cognos8Connector, cookieArray);
            } else if (checkReportTypeResult.getBaseClass() == com.cognos.developer.schemas.bibus._3.Dashboard.class) {
                Dashboard dashboard = new Dashboard(string, cognos8Connector, cookieArray, cCSSession);
                contentProvider = new DashboardContentProvider(string, cognos8Connector, dashboard);
            } else {
                contentProvider = new Cognos8ContentProvider(string, cognos8Connector);
            }
        }
        contentProvider.setSession(cCSSession);
        return contentProvider;
    }

    public abstract InputStream[] getInputStreams() throws CCSGeneralException;

    public abstract ManagedAttachment getAttachment();

    void setSession(CCSSession cCSSession) {
        this.session = cCSSession;
    }

    CCSSession getSession() {
        return this.session;
    }

    public String getVersionBase() {
        return this.m_VersionBase;
    }

    @Deprecated
    public abstract Conversation retrieveDataContent(String var1, String var2, String var3, String var4, String var5, PromptValue[] var6, boolean var7, boolean var8, Conversation var9) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    @Deprecated
    public abstract Conversation retrieveDataContent(String var1, String var2, String var3, String var4, String var5, PromptValue[] var6, boolean var7, boolean var8, Conversation var9, boolean var10) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    @Deprecated
    public abstract Conversation retrieveDataContent(String var1, String var2, String var3, String var4, String var5, PromptValue[] var6, boolean var7, boolean var8, Conversation var9, boolean var10, boolean var11) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    public abstract Conversation retrieveDataContent(String var1, String var2, String var3, String var4, String var5, PromptValue[] var6, boolean var7, boolean var8, Conversation var9, boolean var10, boolean var11, boolean var12) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    @Deprecated
    public abstract void retrieveMetaContent(PromptValue[] var1, boolean var2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    @Deprecated
    public abstract void retrieveMetaContent(PromptValue[] var1, boolean var2, boolean var3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    public abstract void retrieveMetaContent(PromptValue[] var1, boolean var2, boolean var3, boolean var4) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    public void retrieveV1MetaContent(PromptValue[] promptValueArray, boolean bl) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveMetaContent(promptValueArray, bl, false, false);
    }

    public void retrieveV1MetaContent(PromptValue[] promptValueArray, boolean bl, boolean bl2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveMetaContent(promptValueArray, bl, bl2, false);
    }

    public abstract void saveDataContent(Conversation var1) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    public abstract Conversation retrievePromptDescription(PromptValue[] var1, SearchPromptValue var2, Conversation var3) throws CCSGeneralException, CCSAuthenticationException;

    public Conversation retrievePromptDescription(PromptValue[] promptValueArray, SearchPromptValue searchPromptValue, Conversation conversation, boolean bl) throws CCSGeneralException, CCSAuthenticationException {
        return this.retrievePromptDescription(promptValueArray, searchPromptValue, conversation);
    }

    public abstract Conversation retrieveTreePromptNode(Conversation var1, PromptValue[] var2) throws CCSGeneralException, CCSAuthenticationException;

    @Deprecated
    public abstract void upgradeIDs(String var1, String[] var2, BaseRDSSession var3, boolean var4) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public abstract void upgradeIDs(String var1, String[] var2, BaseRDSSession var3, boolean var4, boolean var5) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public abstract void drill(String var1, String var2, String var3) throws CCSGeneralException;

    @Deprecated
    public abstract Conversation beginRetrieveData(String var1, String var2, String var3, String var4, String var5, PromptValue[] var6, boolean var7, boolean var8, Conversation var9) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public abstract Conversation beginRetrieveData(String var1, String var2, String var3, String var4, String var5, PromptValue[] var6, boolean var7, boolean var8, Conversation var9, boolean var10) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    @Deprecated
    public abstract Conversation beginRetrieveMeta(PromptValue[] var1, boolean var2) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public abstract Conversation beginRetrieveMeta(PromptValue[] var1, boolean var2, boolean var3) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public abstract Conversation checkDataStatus(Conversation var1) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public abstract void retrieveDataOutput(Conversation var1) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public abstract void retrieveMetaOutput(Conversation var1) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public abstract void cancelConversation(Conversation var1) throws CCSGeneralException;

    public abstract void releaseConversation(Conversation var1) throws CCSGeneralException;

    public abstract String generateAtomFeed(String var1, String var2, String var3, String var4) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public abstract String generateAtomFeed_DS(String var1, String var2, String var3, String var4, String var5, boolean var6) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException;

    public Conversation beginDrill(String string, String string2, String string3) throws CCSGeneralException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public void retrieveDrillOutput(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    protected String prepareFeed(String string, Element element, String string2) throws CCSGeneralException, CCSAuthenticationException {
        PropEnum[] propEnumArray = new PropEnum[]{PropEnum.defaultName, PropEnum.defaultOutputFormat, PropEnum.name, PropEnum.modificationTime, PropEnum.storeID, PropEnum.searchPath, PropEnum.contact, PropEnum.owner, PropEnum.contactEMail, PropEnum.email, PropEnum.defaultDescription};
        Sort[] sortArray = new Sort[]{new Sort()};
        sortArray[0].setOrder(OrderEnum.ascending);
        sortArray[0].setPropName(PropEnum.defaultName);
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setDataEncoding(EncodingEnum.base64);
        BaseClass[] baseClassArray = this.m_Connection.queryCM(this.m_ReportPath, sortArray, propEnumArray, queryOptions);
        return this.populateFeedFields(string, element, string2, baseClassArray, propEnumArray);
    }

    protected String populateFeedFields(String string, Element element, String string2, BaseClass[] baseClassArray, PropEnum[] propEnumArray) throws CCSGeneralException, CCSAuthenticationException {
        Object object;
        Object object2;
        Object object3;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = CCLMessage.getResMessage("NONE", this.session.getUserJavaLocale());
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = ContentProvider.convertSearchPathToResourcePath(this.m_ReportPath, this.m_Connection);
        String string14 = string13.replace("/", " > ");
        if (null == string) {
            string = "/cognos8";
        }
        if (baseClassArray.length > 0) {
            String string15;
            int n;
            BaseClass[] baseClassArray2;
            Object object4;
            BaseClass[] baseClassArray3;
            object3 = new Sort[]{new Sort()};
            object3[0].setOrder(OrderEnum.ascending);
            object3[0].setPropName(PropEnum.defaultName);
            object2 = new QueryOptions();
            object2.setDataEncoding(EncodingEnum.base64);
            object = null;
            if (baseClassArray[0].getOwner() != null) {
                if (baseClassArray[0].getOwner().getValue() != null && baseClassArray[0].getOwner().getValue().length > 0) {
                    object = (Account)baseClassArray[0].getOwner().getValue()[0];
                    baseClassArray3 = this.m_Connection.queryCM(object.getSearchPath().getValue(), (Sort[])object3, propEnumArray, (QueryOptions)object2);
                    if (baseClassArray3 != null && baseClassArray3.length > 0) {
                        string8 = baseClassArray3[0].getDefaultName().getValue();
                        string9 = ((Account)baseClassArray3[0]).getEmail().getValue();
                    } else {
                        string8 = CCLMessage.getResMessage("RDS_UNKNOWN_USER", this.session.getUserJavaLocale());
                        string9 = null;
                    }
                }
            } else {
                string8 = CCLMessage.getResMessage("NONE", this.session.getUserJavaLocale());
                string9 = null;
            }
            string3 = baseClassArray[0].getDefaultName().getValue();
            string7 = baseClassArray[0].getStoreID().getValue().get_value();
            baseClassArray3 = baseClassArray[0].getModificationTime().getValue();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.applyPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            string5 = simpleDateFormat.format(baseClassArray3.getTime());
            string6 = string4 = baseClassArray[0].getSearchPath().getValue();
            if (baseClassArray[0] instanceof BaseReport) {
                string10 = ((BaseReport)baseClassArray[0]).getDefaultDescription().getValue();
                object4 = (BaseReport)baseClassArray[0];
                if (object4.getContact() != null && object4.getContact().getValue() != null && object4.getContact().getValue().length > 0) {
                    baseClassArray2 = this.m_Connection.queryCM(object4.getContact().getValue()[0].getSearchPath().getValue(), (Sort[])object3, propEnumArray, (QueryOptions)object2);
                    if (baseClassArray2 != null && baseClassArray2.length > 0) {
                        string11 = baseClassArray2[0].getDefaultName().getValue();
                        if (baseClassArray2[0] instanceof Account) {
                            string12 = ((Account)baseClassArray2[0]).getEmail().getValue();
                        }
                    } else {
                        string11 = CCLMessage.getResMessage("RDS_UNKNOWN_USER", this.session.getUserJavaLocale());
                        string12 = null;
                    }
                } else if (object4.getContactEMail().getValue() != null) {
                    string11 = object4.getContactEMail().getValue();
                    string12 = object4.getContactEMail().getValue();
                } else {
                    string11 = CCLMessage.getResMessage("NONE", this.session.getUserJavaLocale());
                    string12 = null;
                }
            } else if (baseClassArray[0] instanceof com.cognos.developer.schemas.bibus._3.Dashboard) {
                object4 = (com.cognos.developer.schemas.bibus._3.Dashboard)baseClassArray[0];
                string10 = object4.getDefaultDescription().getValue();
                if (object4.getContact() != null && object4.getContact().getValue() != null && object4.getContact().getValue().length > 0) {
                    baseClassArray2 = this.m_Connection.queryCM(object4.getContact().getValue()[0].getSearchPath().getValue(), (Sort[])object3, propEnumArray, (QueryOptions)object2);
                    if (baseClassArray2 != null && baseClassArray2.length > 0) {
                        string11 = baseClassArray2[0].getDefaultName().getValue();
                        if (baseClassArray2[0] instanceof Account) {
                            string12 = ((Account)baseClassArray2[0]).getEmail().getValue();
                        }
                    } else {
                        string11 = CCLMessage.getResMessage("RDS_UNKNOWN_USER", this.session.getUserJavaLocale());
                        string12 = null;
                    }
                } else if (object4.getContactEMail().getValue() != null) {
                    string11 = object4.getContactEMail().getValue();
                    string12 = object4.getContactEMail().getValue();
                }
            }
            if (string6.startsWith("/")) {
                string6 = string6.substring(1, string6.length());
            }
            object4 = "report[@name='";
            int n2 = string6.indexOf((String)object4) + ((String)object4).length();
            int n3 = string6.lastIndexOf("']");
            string4 = "";
            if (n2 < n3 && (n = string13.indexOf(string15 = string6.substring(n2, n3))) > 0) {
                String string16 = string13.substring(0, n);
                string4 = Utilities.IRIEncode(string16, true) + CCSFormatter.encodeName(string15);
            }
            if (string4.length() == 0) {
                string4 = Utilities.IRIEncode(string13, true);
            }
        }
        object3 = element.asXML();
        object3 = ((String)object3).replace("@report_title@", Utilities.escapeXML(string3));
        object3 = ((String)object3).replace("@report_storeid@", string7);
        object3 = ((String)object3).replace("@report_gateway@", string2);
        object3 = ((String)object3).replace("@report_id@", string4);
        object3 = ((String)object3).replace("@report_updated@", string5);
        object3 = ((String)object3).replace("@webcontent_root@", string);
        object3 = ((String)object3).replace("@report_path@", Utilities.escapeXML(string6));
        object3 = ((String)object3).replace("@header_title@", CCLMessage.getResMessage("HEADER_TITLE", this.session.getUserJavaLocale()));
        object3 = ((String)object3).replace("@body_title@", CCLMessage.getResMessage("BODY_TITLE", this.session.getUserJavaLocale()));
        object3 = ((String)object3).replace("@footer_title@", CCLMessage.getResMessage("FOOTER_TITLE", this.session.getUserJavaLocale()));
        object3 = ((String)object3).replace("@report_author@", Utilities.escapeXML(string8));
        object3 = ((String)object3).replace("@report_location@", Utilities.escapeXML(string14));
        object3 = ((String)object3).replace("@requestversion@", this.session.getRequestVersion() == Constants.RequestVersion.V3 ? "3" : "");
        object3 = ((String)object3).replace("@extensionnamespace@", this.session.getRequestVersion() == Constants.RequestVersion.V3 ? "http://www.ibm.com/xmlns/prod/cognos/layoutData/201310" : "http://developer.cognos.com/schemas/rds/contentmodel/1");
        object3 = ((String)object3).replace("@output@", this.session.getRequestVersion() == Constants.RequestVersion.V3 ? "ReportData" : "output");
        if (string9 != null) {
            string9 = Utilities.escapeXML(string9);
            string9 = Utilities.escapeRegExp(string9);
            object3 = ((String)object3).replaceAll("\\@report_author_email\\@", "<atom:email>" + string9 + "</atom:email>");
            object3 = ((String)object3).replaceAll("\\@report_owner_email\\@", string9);
        } else {
            object3 = ((String)object3).replaceAll("\\@report_author_email\\@", "");
            object3 = ((String)object3).replaceAll("\\@report_owner_email\\@", "");
        }
        if (string10 != null) {
            string10 = Utilities.escapeXML(string10);
            string10 = Utilities.escapeRegExp(string10);
            object3 = ((String)object3).replaceAll("\\@report_description\\@", "<atom:summary>" + string10 + "</atom:summary>");
            object3 = ((String)object3).replaceAll("\\@report_description_text\\@", string10);
        } else {
            object3 = ((String)object3).replaceAll("\\@report_description\\@", "");
            object3 = ((String)object3).replaceAll("\\@report_description_text\\@", "");
        }
        if (string11 != null) {
            string11 = Utilities.escapeXML(string11);
            object3 = ((String)object3).replace("@report_contact_name@", string11);
            object2 = new StringBuffer();
            ((StringBuffer)object2).append("<atom:contributor><atom:name>");
            ((StringBuffer)object2).append(string11);
            ((StringBuffer)object2).append("</atom:name>");
            if (string12 != null) {
                string12 = Utilities.escapeXML(string12);
                object3 = ((String)object3).replace("@report_contact_email@", string12);
                ((StringBuffer)object2).append("<atom:email>");
                ((StringBuffer)object2).append(string12);
                ((StringBuffer)object2).append("</atom:email>");
            } else {
                object3 = ((String)object3).replace("@report_contact_email@", "");
            }
            ((StringBuffer)object2).append("</atom:contributor>");
            object = Utilities.escapeRegExp(((StringBuffer)object2).toString());
            object3 = ((String)object3).replaceAll("\\@report_contributor\\@", (String)object);
        } else {
            object3 = ((String)object3).replaceAll("\\@report_contributor\\@", "");
            object3 = ((String)object3).replace("@report_contact_name@", "");
        }
        return object3;
    }

    private static String getRootName(String string, Cognos8Connector cognos8Connector) throws CCSGeneralException, CCSAuthenticationException {
        String[] stringArray = string.split("/");
        String string2 = stringArray[0];
        if (string.startsWith("/")) {
            string2 = stringArray[1];
        }
        if (string2.startsWith("CAMID")) {
            return string2;
        }
        PropEnum[] propEnumArray = new PropEnum[]{PropEnum.defaultName};
        BaseClass[] baseClassArray = cognos8Connector.queryCM(string2, propEnumArray);
        if (baseClassArray.length > 0) {
            return baseClassArray[0].getDefaultName().getValue();
        }
        return "";
    }

    public static String convertSearchPathToResourcePath(String string, Cognos8Connector cognos8Connector) throws CCSGeneralException, CCSAuthenticationException {
        PropEnum[] propEnumArray;
        BaseClass[] baseClassArray;
        if (string.startsWith("storeID") && (baseClassArray = cognos8Connector.queryCM(string, propEnumArray = new PropEnum[]{PropEnum.searchPath})) != null && baseClassArray.length > 0) {
            string = baseClassArray[0].getSearchPath().getValue();
        }
        propEnumArray = ContentProvider.getRootName(string, cognos8Connector);
        return ContentProvider.doConversion(string, (String)propEnumArray);
    }

    static String doConversion(String string, String string2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        int n2 = 0;
        int n3 = 39;
        while (n2 < string.length() && -1 != (n = string.indexOf(PATH_PREFIX, n2))) {
            n3 = string.charAt(n + PATH_PREFIX.length());
            n = n + PATH_PREFIX.length() + 1;
            int n4 = string.indexOf(n3, n);
            String string3 = string.substring(n, n4);
            if (n2 != 0 || !string3.equalsIgnoreCase(string2)) {
                stringBuffer.append("/");
                if (string3.contains("/") || string3.contains("?")) {
                    string3 = CCSFormatter.encodeName(string3);
                }
                stringBuffer.append(string3);
            }
            n2 = n4;
        }
        return stringBuffer.toString();
    }

    public static String convertResourcePathtoSearchPath(String string, boolean bl) {
        String[] stringArray = string.split("/");
        char c = '\'';
        if (string.indexOf(c) != -1) {
            c = '\"';
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = string2 = bl ? CCSFormatter.decodeName(stringArray[i]) : stringArray[i];
            if (string2.startsWith("CAMID")) {
                stringBuffer.append(string2);
                continue;
            }
            if (string2.length() == 0) continue;
            stringBuffer.append("/*[@name=");
            stringBuffer.append(c);
            stringBuffer.append(string2);
            stringBuffer.append(c);
            stringBuffer.append(PATH_SUFFIX);
        }
        return stringBuffer.toString();
    }

    public String getReportName() throws CCSAuthenticationException, CCSGeneralException {
        PropEnum[] propEnumArray = new PropEnum[]{PropEnum.defaultName};
        BaseClass[] baseClassArray = this.m_Connection.queryCM(this.m_ReportPath, propEnumArray);
        if (baseClassArray.length > 0) {
            String string = baseClassArray[0].getDefaultName().getValue();
            return string;
        }
        return null;
    }

    public PromptStruct getPromptPage(String string, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        PromptAnswersCache promptAnswersCache = this.m_Connection.promptAnswersCache();
        String string2 = promptAnswersCache.newPrompt();
        String string3 = string + "?b_action=xts.run&m=portal/close.xts";
        return new PromptStruct(string3, string2);
    }

    public abstract String getViewerURL(String var1) throws CCSGeneralException, CCSAuthenticationException;

    public abstract Conversation restoreConversation(Conversation var1) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException;

    public ContextList getContextList(Conversation conversation, String[] stringArray) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public MetadataMap getMetaDataMap(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public String getStoreID() throws CCSAuthenticationException, CCSGeneralException {
        PropEnum[] propEnumArray = new PropEnum[]{PropEnum.storeID};
        BaseClass[] baseClassArray = this.m_Connection.queryCM(this.m_ReportPath, propEnumArray);
        if (baseClassArray.length > 0) {
            String string = baseClassArray[0].getStoreID().getValue().get_value();
            return string;
        }
        return null;
    }

    public ContextData getDataContext(Conversation conversation, String string) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public Element collectPrompts(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        Constants.RequestVersion requestVersion = this.getRequestVersion();
        Element element = DocumentHelper.createElement((QName)new QName("document", new Namespace("ldx", requestVersion == Constants.RequestVersion.V3 ? "http://www.ibm.com/xmlns/prod/cognos/layoutData/201310" : "http://www.ibm.com/xmlns/prod/cognos/layoutData/200904")));
        return element;
    }

    public Element promptForward(Conversation conversation, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public void runForward(Conversation conversation, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public Element promptBack(Conversation conversation, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public Conversation firstPage(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public Conversation nextPage(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public Conversation previousPage(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public Conversation lastPage(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public String getSavedOutput(String string, String string2, String string3) throws CCSGeneralException, CCSAuthenticationException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public String getSavedOutputStoreID(String string, String string2, String string3) throws CCSGeneralException, CCSAuthenticationException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    public void setDowngrade(Constants.Compatibility compatibility) {
        this.m_Compatability = compatibility;
    }

    public String getReportOutputContentType(String string) {
        return "";
    }

    public String[] getSupportedOutputFormats() throws CCSGeneralException, CCSAuthenticationException {
        return new String[0];
    }

    public String[] getSupportedOutputFormats(HashSet<String> hashSet) {
        return new String[0];
    }

    public HashSet<String> getUserCapabilities() throws CCSGeneralException, CCSAuthenticationException {
        return new HashSet<String>();
    }

    public static void logGovernorErrorDetails(Long l, String string, String string2) {
        try {
            String[] stringArray = new String[]{Long.toString(ConfigMgr.getInstance().getDataLimit()), l != null && l > 0L ? Long.toString(l) : "undetermined"};
            CCSGeneralException cCSGeneralException = new CCSGeneralException("DATASIZE_ERROR", stringArray, 400);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, string, string2, "");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract BiBusHeader getBiBusHeader();

    protected String getGatewayURL(Conversation conversation) {
        Object object = conversation.getProperty("useGatewayURI");
        boolean bl = Utilities.parseOptionalObjectBoolean(object, false);
        Object object2 = conversation.getProperty("GENERATE_RELATIVE_URL");
        boolean bl2 = Utilities.parseOptionalObjectBoolean(object2, false);
        String string = null;
        CCSSession cCSSession = this.getSession();
        string = cCSSession == null ? ConfigMgr.getInstance().getCognosGateway() : cCSSession.getGatewayURL(bl2, bl);
        return string;
    }

    protected Constants.RequestVersion getRequestVersion() {
        if (this.session != null) {
            return this.session.getRequestVersion();
        }
        return null;
    }

    private static ContentProvider getTestProvider(String string, Cognos8Connector cognos8Connector, Cookie[] cookieArray) throws CCSGeneralException {
        ContentProvider contentProvider = null;
        try {
            if (string.indexOf("powerPlay8Report") > -1) {
                Class<?> clazz = Class.forName("com.cognos.ccs.content.DummyPP8ContentProvider");
                Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, Cognos8Connector.class, Cookie[].class);
                contentProvider = (ContentProvider)constructor.newInstance(string, cognos8Connector, cookieArray);
            } else {
                Class<?> clazz = Class.forName("com.cognos.ccs.content.DummyC8ContentProvider");
                Constructor<?> constructor = clazz.getDeclaredConstructor(String.class, Cognos8Connector.class);
                contentProvider = (ContentProvider)constructor.newInstance(string, cognos8Connector);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CCSGeneralException("CLASSLOAD_ERROR", classNotFoundException, 404);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CCSGeneralException("CLASSLOAD_ERROR", noSuchMethodException, 404);
        }
        catch (SecurityException securityException) {
            throw new CCSGeneralException("CLASSLOAD_ERROR", securityException, 404);
        }
        catch (InstantiationException instantiationException) {
            throw new CCSGeneralException("CLASSLOAD_ERROR", instantiationException, 404);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CCSGeneralException("CLASSLOAD_ERROR", illegalAccessException, 404);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CCSGeneralException("CLASSLOAD_ERROR", illegalArgumentException, 404);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CCSGeneralException("CLASSLOAD_ERROR", invocationTargetException, 404);
        }
        return contentProvider;
    }

    public class PromptStruct {
        private String m_url;
        private String m_id;

        public PromptStruct(String string, String string2) {
            this.m_url = string;
            this.m_id = string2;
        }

        public String getURL() {
            return this.m_url;
        }

        public String getID() {
            return this.m_id;
        }
    }
}

