/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.ccs.atom.InfoAtomGenerator;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.content.SearchPromptValue;
import com.cognos.ccs.dashboard.Dashboard;
import com.cognos.ccs.dashboard.DashboardSpecBuilder;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.BaseRDSSession;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.ManagedAttachment;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class DashboardContentProvider
extends ContentProvider {
    private String m_SavedXML;
    private Dashboard m_dashboard;

    DashboardContentProvider(String string, Cognos8Connector cognos8Connector, Dashboard dashboard) {
        this.m_ReportPath = string;
        this.m_Connection = cognos8Connector;
        this.m_dashboard = dashboard;
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        boolean bl3 = Utilities.useRelativeUrl(conversation);
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl3);
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        boolean bl4 = Utilities.useGatewayURI(conversation);
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl3, bl4);
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3, boolean bl4) {
        boolean bl5 = false;
        if (null != conversation) {
            bl5 = Utilities.parseOptionalObjectBoolean(conversation.getProperty("saveOutput"), bl5);
        }
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl3, bl4, bl5);
    }

    @Override
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3, boolean bl4, boolean bl5) {
        try {
            boolean bl6 = false;
            if (null != conversation) {
                bl6 = Utilities.parseOptionalObjectBoolean(conversation.getProperty("embedImages"), bl6);
            }
            InputStream inputStream = this.m_dashboard.getOutput(string, bl3, bl4, bl6);
            InputSource inputSource = new InputSource(inputStream);
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(inputSource);
            this.m_SavedXML = document.asXML();
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("CCS_DASHBOARD_ERROR", exception, 500);
            String string6 = null;
            try {
                string6 = this.m_Connection.getRSBus().getCAM().getCAMPassport().getId();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "com.cognos.ccs.content.DashboardContentProvider.retrieveDataContent", this.m_ReportPath, string6, cCSGeneralException.getSourceTrace());
        }
        return conversation;
    }

    @Override
    public void retrieveDataOutput(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        boolean bl = Utilities.useRelativeUrl(conversation);
        boolean bl2 = Utilities.useGatewayURI(conversation);
        boolean bl3 = false;
        if (null != conversation) {
            bl3 = Utilities.parseOptionalObjectBoolean(conversation.getProperty("saveOutput"), bl3);
        }
        this.retrieveDataContent((String)conversation.getProperty("version"), null, null, null, null, null, false, true, conversation, bl, bl2, bl3);
    }

    @Override
    @Deprecated
    public Conversation beginRetrieveData(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        return this.beginRetrieveData(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, false);
    }

    @Override
    public Conversation beginRetrieveData(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        BiBusHeader biBusHeader = this.getBiBusHeader();
        if (null == biBusHeader) {
            biBusHeader = new BiBusHeader();
        }
        Conversation conversation2 = new Conversation(biBusHeader);
        conversation2.setProperty("status", "complete");
        conversation2.setProperty("searchPath", this.m_ReportPath);
        conversation2.setProperty("version", string);
        conversation2.setProperty("saveOutput", new Boolean(bl3));
        return conversation2;
    }

    @Override
    @Deprecated
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveMetaContent(promptValueArray, bl, false, false);
    }

    @Override
    @Deprecated
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl, boolean bl2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveMetaContent(promptValueArray, bl, bl2, false);
    }

    @Override
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl, boolean bl2, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        try {
            Document document = this.m_dashboard.getReportInfo(bl, bl2, bl3);
            this.m_SavedXML = document.getRootElement().asXML();
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("CCS_DASHBOARD_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "com.cognos.ccs.content.DashboardContentProvider.retrieveMetaContent", this.m_ReportPath, null, cCSGeneralException.getSourceTrace());
        }
    }

    @Override
    @Deprecated
    public Conversation beginRetrieveMeta(PromptValue[] promptValueArray, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        return this.beginRetrieveMeta(promptValueArray, bl, false);
    }

    @Override
    public Conversation beginRetrieveMeta(PromptValue[] promptValueArray, boolean bl, boolean bl2) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        Conversation conversation = new Conversation(this.m_Connection.getRSBus());
        conversation.setProperty("status", "complete");
        conversation.setProperty("searchPath", this.m_ReportPath);
        return conversation;
    }

    @Override
    public void retrieveMetaOutput(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        boolean bl = Utilities.useRelativeUrl(conversation);
        boolean bl2 = Utilities.useGatewayURI(conversation);
        boolean bl3 = false;
        if (null != conversation) {
            bl3 = Utilities.parseOptionalObjectBoolean(conversation.getProperty("embedImages"), bl3);
        }
        this.retrieveMetaContent(null, bl, bl2, bl3);
        boolean bl4 = Utilities.parseOptionalObjectBoolean(conversation.getProperty("ReportInfoLegacyCall"), true);
        if (bl4) {
            this.m_SavedXML = this.m_SavedXML.replace("http://www.ibm.com/xmlns/prod/cognos/layoutData/200904", "http://developer.cognos.com/schemas/rds/contentmodel/1");
            this.m_SavedXML = this.m_SavedXML.replace("http://developer.cognos.com/schemas/rds/types/2", "http://developer.cognos.com/schemas/rds/types/1");
        }
    }

    @Override
    public Element collectPrompts(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        boolean bl = Utilities.useRelativeUrl(conversation);
        boolean bl2 = Utilities.useGatewayURI(conversation);
        DashboardSpecBuilder dashboardSpecBuilder = this.m_dashboard.getPromptBuilder(bl, bl2);
        Element element = dashboardSpecBuilder.buildLDX(this.getSession()).getRootElement();
        element.detach();
        return element;
    }

    @Override
    public String generateAtomFeed(String string, String string2, String string3, String string4) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        try {
            String string5 = this.m_dashboard.getReportInfo(false, false, false).getRootElement().asXML();
            InfoAtomGenerator infoAtomGenerator = new InfoAtomGenerator();
            Element element = infoAtomGenerator.convertSpec(string5, string2, string3);
            return this.prepareFeed(string, element, string4);
        }
        catch (CCSPromptException cCSPromptException) {
            cCSPromptException.setProvider(this);
            throw cCSPromptException;
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("CCS_DASHBOARD_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "com.cognos.ccs.content.DashboardContentProvider.generateAtomFeed", this.m_ReportPath, null, cCSGeneralException.getSourceTrace());
            return null;
        }
    }

    @Override
    public String generateAtomFeed_DS(String string, String string2, String string3, String string4, String string5, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        try {
            String string6 = this.m_dashboard.getReportInfo(false, false, false).getRootElement().asXML();
            InfoAtomGenerator infoAtomGenerator = new InfoAtomGenerator();
            Element element = infoAtomGenerator.convertSpec_DS(string6, string2, string3);
            return this.prepareFeed(string, element, string5);
        }
        catch (CCSPromptException cCSPromptException) {
            cCSPromptException.setProvider(this);
            throw cCSPromptException;
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("CCS_DASHBOARD_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), "com.cognos.ccs.content.DashboardContentProvider.generateAtomFeed_DS", this.m_ReportPath, null, cCSGeneralException.getSourceTrace());
            return null;
        }
    }

    @Override
    public BiBusHeader getBiBusHeader() {
        return this.m_Connection.getRSBus();
    }

    @Override
    public String getReportName() throws CCSAuthenticationException, CCSGeneralException {
        return super.getReportName();
    }

    @Override
    public InputStream[] getInputStreams() throws CCSGeneralException {
        InputStream[] inputStreamArray = null;
        if (null != this.m_SavedXML) {
            byte[] byArray = null;
            try {
                byArray = this.m_SavedXML.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = this.m_SavedXML.getBytes();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            inputStreamArray = new InputStream[]{byteArrayInputStream};
        }
        return inputStreamArray;
    }

    @Override
    public void cancelConversation(Conversation conversation) throws CCSGeneralException {
    }

    @Override
    public Conversation checkDataStatus(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        return conversation;
    }

    @Override
    public void drill(String string, String string2, String string3) throws CCSGeneralException {
    }

    @Override
    public ContentProvider.PromptStruct getPromptPage(String string, PromptValue[] promptValueArray) throws CCSGeneralException {
        return null;
    }

    @Override
    public String getViewerURL(String string) throws CCSGeneralException, CCSAuthenticationException {
        return null;
    }

    @Override
    public void releaseConversation(Conversation conversation) throws CCSGeneralException {
    }

    @Override
    public Conversation restoreConversation(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return null;
    }

    @Override
    public Conversation retrievePromptDescription(PromptValue[] promptValueArray, SearchPromptValue searchPromptValue, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        return null;
    }

    @Override
    public Conversation retrieveTreePromptNode(Conversation conversation, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        return null;
    }

    @Override
    public void saveDataContent(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
    }

    @Override
    public void upgradeIDs(String string, String[] stringArray, BaseRDSSession baseRDSSession, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
    }

    @Override
    public void upgradeIDs(String string, String[] stringArray, BaseRDSSession baseRDSSession, boolean bl, boolean bl2) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
    }

    @Override
    public ManagedAttachment getAttachment() {
        return null;
    }
}

