/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSGovernorException;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.utility.Utilities;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;

public class HTTPRequest {
    String m_body;
    BIBusEnvelope m_envelope;
    String m_soapAction = "http://www.ibm.com/xmlns/prod/cognos/internal/annotationService/1";
    String m_url = ConfigMgr.getInstance().getCognosDispatcher();
    String m_method = "";
    String m_contentType = "text/xml; charset=utf-8";
    String m_location = "";
    Cookie[] m_cookies;
    AuthScope m_scope = null;
    UsernamePasswordCredentials m_creds = null;

    public HTTPRequest(Cookie[] cookieArray) {
        this(cookieArray, null);
    }

    public HTTPRequest(Cookie[] cookieArray, BIBusEnvelope bIBusEnvelope) {
        this.m_cookies = cookieArray;
        this.m_envelope = bIBusEnvelope;
    }

    public URL getURL() throws CCSGeneralException {
        try {
            return new URL(this.m_url);
        }
        catch (Exception exception) {
            throw new CCSGeneralException(exception.getMessage(), exception, 500);
        }
    }

    public void setContentType(String string) {
        this.m_contentType = string;
    }

    public String getLocationHeader() {
        return this.m_location;
    }

    public void setUrl(String string) {
        this.m_url = string;
    }

    public void setMethod(String string) {
        this.m_method = string;
    }

    public void setAuthentication(String string, String string2, String string3, String string4) {
        this.m_scope = AuthScope.ANY;
        this.m_creds = new UsernamePasswordCredentials(string3, string4);
    }

    public void setSoapAction(String string) throws CCSGeneralException {
        this.m_soapAction = string;
    }

    public String retrieveContent() throws CCSGeneralException {
        return this.retrieveContent(true);
    }

    public String retrieveContent(boolean bl) throws CCSGeneralException {
        try {
            HttpMethodBase httpMethodBase;
            StringBuffer stringBuffer = new StringBuffer();
            URL uRL = this.getURL();
            HttpClient httpClient = Utilities.createClientConnection(uRL.toURI());
            if (this.m_scope != null && this.m_creds != null) {
                httpClient.getState().setCredentials(this.m_scope, (Credentials)this.m_creds);
            }
            if ((httpMethodBase = this.executeRequest(bl, uRL, httpClient)) == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpMethodBase.getResponseBodyAsStream(), "UTF-8"));
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            return stringBuffer.toString();
        }
        catch (CCSGovernorException cCSGovernorException) {
            throw new CCSGeneralException(cCSGovernorException.getMessage(), cCSGovernorException.getParms(), cCSGovernorException, 500);
        }
        catch (IOException iOException) {
            throw new CCSGeneralException(iOException.getMessage(), iOException, 500);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CCSGeneralException(uRISyntaxException.getMessage(), uRISyntaxException, 500);
        }
    }

    protected HttpMethodBase executeRequest(boolean bl, URL uRL, HttpClient httpClient) throws IOException, HttpException, CCSGeneralException, CCSGovernorException {
        Header header;
        long l;
        Object object;
        String string = uRL.toString();
        if (uRL.getProtocol().equalsIgnoreCase("https")) {
            string = uRL.getFile();
        }
        if (this.m_method.equals("")) {
            if (bl) {
                this.setMethod("POST");
            } else {
                this.setMethod("GET");
            }
        }
        if (this.m_method.equals("POST")) {
            object = new PostMethod(string);
            object.setRequestBody(this.getRequestBody());
            object.setRequestHeader("Content-Length", "" + this.getRequestBody().getBytes("UTF-8").length);
        } else if (this.m_method.equals("PUT")) {
            object = new PutMethod(string);
            ((PutMethod)object).setRequestBody(this.getRequestBody());
            object.setRequestHeader("Content-Length", "" + this.getRequestBody().getBytes("UTF-8").length);
        } else {
            object = this.m_method.equals("DELETE") ? new DeleteMethod(string) : new GetMethod(string);
        }
        object.setRequestHeader("Accept", "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
        object.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322)");
        if (this.m_soapAction != null) {
            object.setRequestHeader("SOAPAction", this.m_soapAction);
        }
        if (this.m_contentType != null) {
            object.setRequestHeader("Content-Type", this.m_contentType);
        }
        if (this.m_cookies != null) {
            Utilities.addCookiesToMethod((HttpMethodBase)object, this.m_cookies);
        }
        httpClient.executeMethod((HttpMethod)object);
        if (object.getResponseHeader("Content-Type").getValue().equalsIgnoreCase("text/html")) {
            // empty if block
        }
        if (object.getResponseHeader("Content-Length") != null && (l = Long.parseLong(object.getResponseHeader("Content-Length").getValue())) > ConfigMgr.getInstance().getDataLimit()) {
            object.releaseConnection();
        }
        if ((header = object.getResponseHeader("location")) != null) {
            this.m_location = header.getValue();
        }
        return object;
    }

    protected String getRequestBody() {
        return this.m_body;
    }

    public void setRequestBody(String string) {
        this.m_body = string;
    }

    public void setSoapRequestBody(String string) {
        String string2 = "<soap:Header/>";
        if (this.m_envelope != null && this.m_envelope.getHeader() != null) {
            string2 = this.m_envelope.getHeader().asXML();
        }
        this.m_body = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\">" + string2 + "<soap:Body>" + string + "</soap:Body>" + "</soap:Envelope>";
    }

    public String retrieveContent(String string) throws CCSGeneralException {
        this.m_url = string;
        this.m_soapAction = null;
        this.m_body = "";
        this.m_contentType = null;
        return this.retrieveContent();
    }
}

