/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.CryptoHttpClient;
import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.ccs.content.MetricsManagerContentProvider;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSGovernorException;
import com.cognos.ccs.service.CCSSession;
import com.cognos.ccs.service.ConfigMgr;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class MetricsManagerRequest {
    String server = ConfigMgr.getInstance().getCognosGateway();
    CCSSession m_session;
    String m_path;
    MetricsManagerContentProvider m_provider;

    public MetricsManagerRequest(CCSSession cCSSession, String string, MetricsManagerContentProvider metricsManagerContentProvider) {
        this.m_session = cCSSession;
        this.m_path = string.substring(9, string.length() - 2);
        this.m_provider = metricsManagerContentProvider;
    }

    public URL getURL() throws CCSGeneralException {
        try {
            String string = this.server + "?" + new String(CCLWeb64.decode((String)this.m_path));
            return new URL(string);
        }
        catch (Exception exception) {
            throw new CCSGeneralException(exception.getMessage(), exception, 500);
        }
    }

    public String retrieveMetricManagerContent() throws CCSGeneralException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            URL uRL = this.getURL();
            HttpClient httpClient = this.createClientConnection(uRL);
            GetMethod getMethod = this.executeRequest(uRL, httpClient);
            if (getMethod == null) {
                return null;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(getMethod.getResponseBodyAsStream(), "UTF-8"));
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            return stringBuffer.toString();
        }
        catch (CCSGovernorException cCSGovernorException) {
            throw new CCSGeneralException(cCSGovernorException.getMessage(), cCSGovernorException.getParms(), cCSGovernorException, 500);
        }
        catch (IOException iOException) {
            throw new CCSGeneralException(iOException.getMessage(), iOException, 500);
        }
    }

    protected GetMethod executeRequest(URL uRL, HttpClient httpClient) throws IOException, HttpException, CCSGeneralException, CCSGovernorException {
        long l;
        GetMethod getMethod = new GetMethod(uRL.toString());
        getMethod.setRequestHeader("Accept", "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
        getMethod.setRequestHeader("Accept-Encoding", "gzip, deflate");
        getMethod.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322)");
        getMethod.setFollowRedirects(true);
        if (this.getSession().isAborted()) {
            getMethod.releaseConnection();
            return null;
        }
        httpClient.executeMethod((HttpMethod)getMethod);
        if (this.getSession().isAborted()) {
            getMethod.releaseConnection();
            return null;
        }
        if (getMethod.getResponseHeader("Content-Type").getValue().equalsIgnoreCase("text/html")) {
            // empty if block
        }
        if (getMethod.getResponseHeader("Content-Length") != null && (l = Long.parseLong(getMethod.getResponseHeader("Content-Length").getValue())) > ConfigMgr.getInstance().getDataLimit()) {
            getMethod.releaseConnection();
        }
        return getMethod;
    }

    protected HttpClient createClientConnection(URL uRL) throws CCSGeneralException {
        HttpClient httpClient;
        if (uRL.getProtocol().equalsIgnoreCase("https")) {
            CAMFactory cAMFactory = new CAMFactory();
            try {
                cAMFactory.initialize("<initializeDocument><serviceID>reportDataService</serviceID></initializeDocument>".getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
            httpClient = new CryptoHttpClient();
        } else {
            httpClient = new HttpClient();
        }
        this.m_provider.setClientCookies(httpClient);
        return httpClient;
    }

    public CCSSession getSession() {
        return this.m_session;
    }
}

