/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.caf.CAFLibrary;
import com.cognos.caf.CAFLibraryException;
import com.cognos.ccs.content.PowerPlayContentProvider;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.ManagedAttachment;
import com.cognos.ccs.utility.OutputFormatEnums;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.GetMethod;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class PowerPlay8ContentProvider
extends PowerPlayContentProvider {
    ManagedAttachment m_attachment = null;
    protected static final String RAWXML_PP8_REQUEST = "&DC=Q&cnct=24&pp_xml=1&GND=1";
    protected static final String FMTXML_PP8_REQUEST = "&cnct=22&pp_xml=1";
    protected static final String FMTCSV_PP8_REQUEST = "&RA=1";
    protected static final String FMTXLS_PP8_REQUEST = "&RA=11&CNCT=24";
    protected static final String DOCTYPE_PDF = "application/pdf";
    protected static final String DOCTYPE_XLS = "application/vnd.ms-exce";
    protected static final String DOCTYPE_CSV = "text/csv";
    private static String INIT_OUTPUT = "output";

    PowerPlay8ContentProvider(String string, Cognos8Connector cognos8Connector, Cookie[] cookieArray) {
        super(null, string, cognos8Connector, cookieArray);
        this.initTransforms(ConfigMgr.getInstance().getCognosGateway());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initStaticStyles() {
        Object object = mutex;
        synchronized (object) {
            if (null == StaticStyles) {
                SAXReader sAXReader = new SAXReader();
                try {
                    Document document = sAXReader.read(ConfigMgr.getInstance().getFileStream("/xslt/ppes/pp8staticstyles.xml"));
                    SimpleNamespaceContext simpleNamespaceContext = this.getNamespaceContext();
                    XPath xPath = document.createXPath("/rdsCM:document/rdsCM:styleGroup");
                    xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
                    StaticStyles = xPath.selectNodes((Object)document);
                }
                catch (DocumentException documentException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    protected String buildChartURL() throws UnsupportedEncodingException {
        String string = this.buildGatewayURL() + FMTXML_PP8_REQUEST;
        if (this.m_Locale != null && !this.m_Locale.equals("")) {
            string = string + "&LO=" + this.m_Locale;
        }
        return string;
    }

    @Override
    protected String buildDataURL() throws UnsupportedEncodingException {
        String string = this.buildGatewayURL() + RAWXML_PP8_REQUEST;
        if (this.m_Locale != null && !this.m_Locale.equals("")) {
            string = string + "&LO=" + this.m_Locale;
        }
        return string;
    }

    @Override
    protected String buildGatewayURL() throws UnsupportedEncodingException {
        return this.buildPPSURL("powerPlayService");
    }

    protected String buildLDXURL() throws UnsupportedEncodingException {
        return this.buildPPSURL("powerplayldx");
    }

    private String buildPPSURL(String string) throws UnsupportedEncodingException {
        String string2 = ConfigMgr.getInstance().getCognosDispatcher();
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append("?b_action=");
        stringBuffer.append(string);
        String string3 = this.getRoutingServerGroup();
        if (!Utilities.isNullOrEmpty(string3)) {
            stringBuffer.append("&ppes_routingsg=");
            stringBuffer.append(Utilities.IRIEncode(string3, false));
        }
        stringBuffer.append("&crnobj=");
        String string4 = Utilities.IRIEncode(this.m_ReportPath, false, false);
        try {
            string4 = CAFLibrary.tpXSSEncode((String)string4);
        }
        catch (CAFLibraryException cAFLibraryException) {
            CCSLogger.getInstance().logRuntimeErrorMessage(cAFLibraryException.getLocalizedMessage(), null, null, null, cAFLibraryException.getStackTrace().toString());
        }
        stringBuffer.append(string4);
        return stringBuffer.toString();
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, false, false, false);
    }

    @Override
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3, boolean bl4, boolean bl5) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        InputStream inputStream = null;
        String string6 = null;
        if (conversation != null) {
            string6 = (String)conversation.getProperty("PROVIDER_OUTPUT_FORMAT");
        }
        if (Utilities.isNullOrEmpty(string6)) {
            inputStream = "LOND".equals(string) || "NO_DATA".equals(string) ? this.getPowerplayLDX(true) : this.getPowerplayLDX(false);
            this.m_attachment = new ManagedAttachment(inputStream);
            return conversation;
        }
        if (OutputFormatEnums.formatPDF.equalsName(string6)) {
            conversation.setProperty("pp_request", true);
            conversation = this.beginRetrieveData(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl5);
            while (!conversation.getProperty("status").equals("complete")) {
                conversation = this.checkDataStatus(conversation);
            }
            this.retrieveDataOutput(conversation);
            return conversation;
        }
        inputStream = this.getPowerplayOutputFormat(string6);
        this.m_attachment = new ManagedAttachment(inputStream);
        return conversation;
    }

    @Override
    @Deprecated
    public Conversation beginRetrieveData(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.beginRetrieveData(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, false);
    }

    @Override
    public Conversation beginRetrieveData(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        boolean bl4 = false;
        if (conversation != null) {
            String string6 = (String)conversation.getProperty("PROVIDER_OUTPUT_FORMAT");
            if (OutputFormatEnums.formatPDF.equalsName(string6)) {
                conversation.setProperty("pp_request", true);
            }
            bl4 = Utilities.parseOptionalObjectBoolean(conversation.getProperty("pp_request"), false);
        }
        if (bl4) {
            boolean bl5 = false;
            if ("VERSION_NAME".equals(string) || !Utilities.isNullOrEmpty(string5) || !Utilities.isNullOrEmpty(string4)) {
                bl5 = true;
            }
            int n = 100;
            if ("LIMITED_DATA".equals(string)) {
                n = 101;
            } else if ("NO_DATA".equals(string)) {
                n = 102;
            } else if ("LATEST".equals(string) && !bl3) {
                bl5 = this.m_Connection.hasVersion(this.m_ReportPath);
            } else if ("LOND".equals(string)) {
                n = 102;
                bl5 = this.m_Connection.hasVersion(this.m_ReportPath);
            }
            ParameterValue[] parameterValueArray = PromptValue.toPValueArray(promptValueArray);
            if (conversation == null) {
                conversation = new Conversation(this.m_Connection.getPPBus());
            }
            if (bl5) {
                conversation.setProperty("burstID", string5);
                conversation.setProperty("burstKey", string4);
                conversation.setProperty("promptValues", parameterValueArray);
                conversation.setProperty("versionName", string3);
                conversation.setProperty("versionPath", string2);
                conversation.setProperty("versionType", string);
                conversation.setProperty("versioned", "true");
                conversation.setProperty("status", "complete");
            } else {
                conversation.setProperty("DATA_MODE_KEY", new Integer(n));
                conversation.setProperty("initialize", "output");
                conversation.setProperty("PAGED_KEY", new Boolean(bl));
                conversation.setProperty("PROMPT_KEY", new Boolean(bl2));
                conversation.setProperty("promptValues", parameterValueArray);
                conversation.setProperty("status", "working");
            }
            conversation.setProperty("searchPath", this.m_ReportPath);
            return conversation;
        }
        return super.beginRetrieveData(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl3);
    }

    @Override
    public void retrieveDataOutput(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        boolean bl = Utilities.parseOptionalObjectBoolean(conversation.getProperty("pp_request"), false);
        if (bl) {
            try {
                String string = (String)conversation.getProperty("versioned");
                if (null != string) {
                    String string2 = (String)conversation.getProperty("versionType");
                    String string3 = (String)conversation.getProperty("versionPath");
                    String string4 = (String)conversation.getProperty("versionName");
                    String string5 = (String)conversation.getProperty("burstKey");
                    String string6 = (String)conversation.getProperty("burstID");
                    ParameterValue[] parameterValueArray = (ParameterValue[])conversation.getProperty("promptValues");
                    this.m_VersionBase = this.m_Connection.generateBaseVersion(this.m_ReportPath, string2, string4, string3, string5, string6);
                    this.m_attachment = this.m_Connection.getReportVersion(this.m_ReportPath, parameterValueArray, 0, string2, string4, string3, string5, string6, this.getSession(), conversation);
                }
                this.m_attachment = conversation.getAttachment();
                if (this.m_attachment != null) {
                    conversation.removeProperty("ATTACHMENTS_KEY");
                }
                String string7 = this.getGatewayURL(conversation);
                this.m_attachment = this.m_Connection.getRunOutput(conversation, string7);
            }
            catch (CCSPromptException cCSPromptException) {
                cCSPromptException.setProvider(this);
                throw cCSPromptException;
            }
        } else {
            super.retrieveDataOutput(conversation);
        }
    }

    @Override
    public Conversation checkDataStatus(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        boolean bl = Utilities.parseOptionalObjectBoolean(conversation.getProperty("pp_request"), false);
        if (bl) {
            String string = (String)conversation.getProperty("initialize");
            if (INIT_OUTPUT.equals(string)) {
                conversation.removeProperty("initialize");
                String string2 = (String)conversation.getProperty("searchPath");
                Boolean bl2 = (Boolean)conversation.getProperty("PAGED_KEY");
                Boolean bl3 = (Boolean)conversation.getProperty("PROMPT_KEY");
                Integer n = (Integer)conversation.getProperty("DATA_MODE_KEY");
                ParameterValue[] parameterValueArray = (ParameterValue[])conversation.getProperty("promptValues");
                return this.m_Connection.beginRunPP8Request(string2, parameterValueArray, bl2, n, conversation, bl3, this.m_Compatability);
            }
            return this.m_Connection.checkPP8RunRequest(conversation);
        }
        return super.checkDataStatus(conversation);
    }

    @Override
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrievePPContent(true);
        this.downgradeMeta();
    }

    protected InputStream getPowerplayLDX(boolean bl) throws CCSGeneralException {
        try {
            URL uRL = new URL(this.buildLDXURL());
            HttpClient httpClient = this.createClientConnection(uRL);
            GetMethod getMethod = this.executeRequest(uRL, httpClient);
            return getMethod.getResponseBodyAsStream();
        }
        catch (Exception exception) {
            throw new CCSGeneralException("PPRESP_ERROR", new String[]{this.m_ReportPath}, exception, 500);
        }
    }

    protected InputStream getPowerplayOutputFormat(String string) throws CCSGeneralException {
        try {
            if (OutputFormatEnums.formatPDF.equalsName(string)) {
                return null;
            }
            String string2 = this.buildGatewayURL();
            if (OutputFormatEnums.formatCSV.equalsName(string)) {
                string2 = string2 + FMTCSV_PP8_REQUEST;
            } else if (OutputFormatEnums.formatXLS.equalsName(string)) {
                string2 = string2 + FMTXLS_PP8_REQUEST;
            }
            URL uRL = new URL(string2);
            HttpClient httpClient = this.createClientConnection(uRL);
            GetMethod getMethod = this.executeRequest(uRL, httpClient);
            return getMethod.getResponseBodyAsStream();
        }
        catch (Exception exception) {
            throw new CCSGeneralException("PPRESP_ERROR", new String[]{this.m_ReportPath}, exception, 500);
        }
    }

    @Override
    public InputStream[] getInputStreams() throws CCSGeneralException {
        if (this.m_attachment != null) {
            return new InputStream[]{this.m_attachment.getStream()};
        }
        return super.getInputStreams();
    }

    @Override
    protected void retrievePPContent(boolean bl) throws CCSGeneralException {
        if (!bl) {
            this.getPowerplayLDX(false);
        } else {
            super.retrievePPContent(bl);
        }
    }

    @Override
    public HashSet<String> getUserCapabilities() throws CCSGeneralException, CCSAuthenticationException {
        return this.m_Connection.getCapabilities();
    }

    @Override
    public String[] getSupportedOutputFormats() throws CCSGeneralException, CCSAuthenticationException {
        return this.getSupportedOutputFormats(this.getUserCapabilities());
    }

    @Override
    public String[] getSupportedOutputFormats(HashSet<String> hashSet) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (hashSet.contains(OutputFormatEnums.capabilityCanGenerateCSVOutput.toString())) {
            arrayList.add(OutputFormatEnums.formatCSV.toString());
        }
        if (hashSet.contains(OutputFormatEnums.capabilityCanGeneratePDFOutput.toString())) {
            arrayList.add(OutputFormatEnums.formatPDF.toString());
        }
        if (hashSet.contains(OutputFormatEnums.capabilityCanGenerateXLSOutput.toString())) {
            arrayList.add(OutputFormatEnums.formatXLS.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String getReportOutputContentType(String string) {
        if (OutputFormatEnums.formatPDF.equalsName(string)) {
            return DOCTYPE_PDF;
        }
        if (OutputFormatEnums.formatCSV.equalsName(string)) {
            return DOCTYPE_CSV;
        }
        if (OutputFormatEnums.formatXLS.equalsName(string)) {
            return DOCTYPE_XLS;
        }
        return "";
    }

    @Override
    public ManagedAttachment getAttachment() {
        return this.m_attachment;
    }
}

