/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.CryptoHttpClient;
import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.PromptValue;
import com.cognos.ccs.content.RDSSchema;
import com.cognos.ccs.content.SearchPromptValue;
import com.cognos.ccs.content.StyleGroup;
import com.cognos.ccs.content.StyleParser;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSGovernorException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.BaseRDSSession;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.service.GovernedInputStream;
import com.cognos.ccs.service.ManagedAttachment;
import com.cognos.ccs.service.PPInputStream;
import com.cognos.ccs.service.Transform;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.RoutingInfo;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class PowerPlayContentProvider
extends ContentProvider {
    protected String m_PPGateway = null;
    protected String m_SavedXML = null;
    protected static HashMap m_ChartTransforms;
    protected static final String RAWXML_PP_REQUEST = "&DC=Q&cnct=24&xml";
    protected static final String FMTXML_PP_REQUEST = "&cnct=22&xml";
    protected static Transform DataTransform;
    protected static Transform MetaTransform;
    protected static Transform ChartMetaTransform;
    protected static Transform AtomTransform;
    protected static Transform AtomChartTransform;
    protected static List StaticStyles;
    protected static Element StaticLayout;
    protected String m_Locale = null;
    protected RDSSchema m_Schema = null;
    protected Cookie[] cookies = null;
    protected static Object mutex;

    PowerPlayContentProvider(String string, String string2, Cognos8Connector cognos8Connector, Cookie[] cookieArray) {
        PowerPlayContentProvider.createMutex();
        this.m_PPGateway = string;
        this.m_ReportPath = string2;
        this.m_Schema = RDSSchema.getInstance(Constants.NamespaceVersion.V2);
        this.m_Connection = cognos8Connector;
        this.initTransforms(string);
        this.initStaticStyles();
        this.initStaticLayout();
        this.cookies = cookieArray;
        try {
            this.m_Locale = cognos8Connector.getLocale();
        }
        catch (CCSGeneralException cCSGeneralException) {
            // empty catch block
        }
    }

    private static synchronized void createMutex() {
        if (mutex == null) {
            mutex = new Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initTransforms(String string) {
        Object object = mutex;
        synchronized (object) {
            String[] stringArray;
            String[] stringArray2;
            if (null == DataTransform) {
                stringArray2 = new String[]{"transformData"};
                stringArray = new String[]{"true"};
                DataTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/ppes/pptrans.xsl"), stringArray2, stringArray);
            }
            if (null == MetaTransform) {
                stringArray2 = new String[]{"transformData"};
                stringArray = new String[]{"false"};
                MetaTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/ppes/pptrans.xsl"), stringArray2, stringArray);
            }
            if (null == AtomTransform) {
                AtomTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/ppes/pp2atom.xsl"));
            }
            if (null == AtomChartTransform) {
                AtomChartTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/ppes/pp2atom_chart.xsl"));
            }
            if (null == ChartMetaTransform) {
                stringArray2 = new String[]{"transformData"};
                stringArray = new String[]{"false"};
                ChartMetaTransform = new Transform(ConfigMgr.getInstance().getFileStream("/xslt/ppes/ppchartrans.xsl"), stringArray2, stringArray);
            }
            if (m_ChartTransforms == null) {
                m_ChartTransforms = new HashMap();
            }
            if (m_ChartTransforms.get(string) == null) {
                stringArray2 = new String[]{"transformData", "gateway", "cogGateway"};
                stringArray = new String[]{"true", string, ConfigMgr.getInstance().getCognosGateway()};
                m_ChartTransforms.put(string, new Transform(ConfigMgr.getInstance().getFileStream("/xslt/ppes/ppchartrans.xsl"), stringArray2, stringArray));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initStaticStyles() {
        Object object = mutex;
        synchronized (object) {
            if (null == StaticStyles) {
                SAXReader sAXReader = new SAXReader();
                try {
                    Document document = sAXReader.read(ConfigMgr.getInstance().getFileStream("/xslt/ppes/ppstaticstyles.xml"));
                    SimpleNamespaceContext simpleNamespaceContext = this.getNamespaceContext();
                    XPath xPath = document.createXPath("/rdsCM:document/rdsCM:styleGroup");
                    xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
                    StaticStyles = xPath.selectNodes((Object)document);
                }
                catch (DocumentException documentException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initStaticLayout() {
        Object object = mutex;
        synchronized (object) {
            if (null == StaticLayout) {
                SAXReader sAXReader = new SAXReader();
                try {
                    Document document = sAXReader.read(ConfigMgr.getInstance().getFileStream("/xslt/ppes/ppstaticlayout.xml"));
                    StaticLayout = document.getRootElement();
                    StaticLayout.detach();
                }
                catch (DocumentException documentException) {
                    // empty catch block
                }
            }
        }
    }

    protected InputStream getResponseStream(GetMethod getMethod) throws CCSGeneralException, CCSGovernorException, IOException {
        long l;
        if (getMethod.getResponseHeader("Content-Type").getValue().equalsIgnoreCase("text/html")) {
            throw new CCSGeneralException("PPRESP_ERROR", new String[]{this.m_ReportPath}, 500);
        }
        if (getMethod.getResponseHeader("Content-Length") != null && (l = Long.parseLong(getMethod.getResponseHeader("Content-Length").getValue())) > ConfigMgr.getInstance().getDataLimit()) {
            getMethod.releaseConnection();
            ContentProvider.logGovernorErrorDetails(l, null, null);
            throw new CCSGovernorException("GOVERNOR_ERROR", new String[]{this.m_ReportPath});
        }
        return new GovernedInputStream(this.m_ReportPath, ConfigMgr.getInstance().getDataLimit(), getMethod.getResponseBodyAsStream());
    }

    protected String buildDataURL() throws UnsupportedEncodingException {
        String string = this.buildGatewayURL() + RAWXML_PP_REQUEST;
        if (this.m_Locale != null && !this.m_Locale.equals("")) {
            string = string + "&LO=" + this.m_Locale;
        }
        return string;
    }

    protected String buildGatewayURL() throws UnsupportedEncodingException {
        String string = ConfigMgr.getInstance().getPPMapping(this.m_PPGateway);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("?");
        String string2 = this.getRoutingServerGroup();
        if (!Utilities.isNullOrEmpty(string2)) {
            stringBuffer.append("ppes_routingsg=");
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append("&");
        }
        stringBuffer.append("crnobj=");
        stringBuffer.append(URLEncoder.encode(this.m_ReportPath, "UTF-8"));
        return stringBuffer.toString();
    }

    protected String buildChartURL() throws UnsupportedEncodingException {
        String string = this.buildGatewayURL() + FMTXML_PP_REQUEST;
        if (this.m_Locale != null && !this.m_Locale.equals("")) {
            string = string + "&LO=" + this.m_Locale;
        }
        return string;
    }

    protected Element generateDataXML(boolean bl, GetMethod getMethod) throws CCSGovernorException, CCSGeneralException, IOException {
        Document document = DocumentHelper.createDocument();
        Document document2 = DocumentHelper.createDocument();
        Element element = document.addElement("tempRoot");
        Element element2 = null;
        SimpleNamespaceContext simpleNamespaceContext = this.getNamespaceContext();
        XPath xPath = null;
        Element element3 = null;
        Element element4 = null;
        Element element5 = null;
        if (bl) {
            MetaTransform.convertToCCS(new PPInputStream(this.m_ReportPath, ConfigMgr.getInstance().getDataLimit(), this.getResponseStream(getMethod)), element);
            getMethod.releaseConnection();
            element3 = document2.addElement(new QName("document", new Namespace("rds", "http://developer.cognos.com/schemas/rds/types/2")));
            element2 = element3.addElement(new QName("id", new Namespace("ldx", "http://www.ibm.com/xmlns/prod/cognos/layoutData/200904")));
            element2.setText("1");
            xPath = document.createXPath("/tempRoot/rds:page");
            xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            element4 = (Element)xPath.selectSingleNode((Object)document);
            if (element4 != null) {
                element4.detach();
                element3.add(element4);
            }
        } else {
            DataTransform.convertToCCS(new PPInputStream(this.m_ReportPath, ConfigMgr.getInstance().getDataLimit(), this.getResponseStream(getMethod)), element);
            getMethod.releaseConnection();
            xPath = document.createXPath("/tempRoot/rdsCM:page");
            xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            element4 = (Element)xPath.selectSingleNode((Object)document);
            element3 = document2.addElement(new QName("document", new Namespace("rdsCM", "http://www.ibm.com/xmlns/prod/cognos/layoutData/200904")));
            element2 = element3.addElement(new QName("id", new Namespace("rdsCM", "http://www.ibm.com/xmlns/prod/cognos/layoutData/200904")));
            element2.setText("1");
            element5 = element3.addElement(new QName("pages", new Namespace("rdsCM", "http://www.ibm.com/xmlns/prod/cognos/layoutData/200904")));
            if (element4 != null) {
                element4.detach();
                element5.add(element4);
            }
        }
        return element3;
    }

    protected SimpleNamespaceContext getNamespaceContext() {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        simpleNamespaceContext.addNamespace("rds", "http://developer.cognos.com/schemas/rds/types/2");
        simpleNamespaceContext.addNamespace("rdsCM", "http://www.ibm.com/xmlns/prod/cognos/layoutData/200904");
        return simpleNamespaceContext;
    }

    protected void generateChartXML(boolean bl, GetMethod getMethod, Element element) throws CCSGovernorException, CCSGeneralException, IOException {
        Document document = DocumentHelper.createDocument();
        Element element2 = document.addElement("temp");
        SimpleNamespaceContext simpleNamespaceContext = this.getNamespaceContext();
        if (bl) {
            ChartMetaTransform.convertToCCS(new PPInputStream(this.m_ReportPath, ConfigMgr.getInstance().getDataLimit(), this.getResponseStream(getMethod)), element2);
            XPath xPath = document.createXPath("/temp/rds:page");
            xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            Element element3 = (Element)xPath.selectSingleNode((Object)document);
            if (element3 != null) {
                element3.detach();
                element.add(element3);
            }
        } else {
            Transform transform = (Transform)m_ChartTransforms.get(this.m_PPGateway);
            if (null == transform) {
                throw new CCSGeneralException("TRANS_ERROR", 500);
            }
            transform.convertToCCS(new PPInputStream(this.m_ReportPath, ConfigMgr.getInstance().getDataLimit(), this.getResponseStream(getMethod)), element2);
            XPath xPath = document.createXPath("/temp/rdsCM:page");
            xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
            Element element4 = (Element)xPath.selectSingleNode((Object)document);
            if (element4 != null) {
                element4.detach();
                element.add(element4);
            }
        }
    }

    protected void retrievePPContent(boolean bl) throws CCSGeneralException {
        try {
            URL uRL = new URL(this.buildDataURL());
            HttpClient httpClient = this.createClientConnection(uRL);
            GetMethod getMethod = this.executeRequest(uRL, httpClient);
            if (getMethod == null) {
                return;
            }
            Element element = this.generateDataXML(bl, getMethod);
            uRL = new URL(this.buildChartURL());
            getMethod = this.executeRequest(uRL, httpClient);
            if (getMethod == null) {
                return;
            }
            this.generateChartXML(bl, getMethod, element);
            this.finalizeXML(bl, element);
        }
        catch (CCSGeneralException cCSGeneralException) {
            throw cCSGeneralException;
        }
        catch (CCSGovernorException cCSGovernorException) {
            throw new CCSGeneralException(cCSGovernorException.getMessage(), cCSGovernorException.getParms(), cCSGovernorException, 500);
        }
        catch (IOException iOException) {
            throw new CCSGeneralException("PPRESP_ERROR", new String[]{this.m_ReportPath}, iOException, 500);
        }
    }

    protected void finalizeXML(boolean bl, Element element) throws CCSGeneralException {
        if (bl) {
            element.add((Element)StaticLayout.clone());
        }
        if (!bl) {
            this.processStyles(element);
        }
        this.m_SavedXML = element.asXML();
    }

    protected HttpClient createClientConnection(URL uRL) throws CCSGeneralException {
        HttpClient httpClient;
        if (uRL.getProtocol().equalsIgnoreCase("https")) {
            CAMFactory cAMFactory = new CAMFactory();
            try {
                cAMFactory.initialize("<initializeDocument><serviceID>reportDataService</serviceID></initializeDocument>".getBytes());
            }
            catch (Exception exception) {
                throw new CCSGeneralException("CAM_FAILURE", new String[]{this.m_Locale}, exception, 500);
            }
            httpClient = new CryptoHttpClient();
        } else {
            httpClient = new HttpClient();
        }
        this.setClientCookies(httpClient, uRL);
        return httpClient;
    }

    protected void setClientCookies(HttpClient httpClient, URL uRL) {
        HttpState httpState = httpClient.getState();
        for (int i = 0; i < this.cookies.length; ++i) {
            Cookie cookie;
            if (this.cookies[i].getName().equals("cam_passport")) {
                cookie = new Cookie(uRL.getHost(), "cam_passport", this.cookies[i].getValue());
                cookie.setPath("/");
                httpState.addCookie(cookie);
                continue;
            }
            if (!this.cookies[i].getName().equals("AS_TICKET")) continue;
            cookie = new Cookie(uRL.getHost(), "AS_TICKET", this.cookies[i].getValue());
            cookie.setPath("/");
            httpState.addCookie(cookie);
        }
        httpState.setCookiePolicy(0);
    }

    protected GetMethod executeRequest(URL uRL, HttpClient httpClient) throws IOException, HttpException, CCSGeneralException, CCSGovernorException {
        long l;
        GetMethod getMethod = new GetMethod(uRL.toString());
        getMethod.setRequestHeader("Accept", "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, application/x-shockwave-flash, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
        getMethod.setRequestHeader("Accept-Encoding", "gzip, deflate");
        getMethod.setRequestHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 1.1.4322)");
        getMethod.setFollowRedirects(true);
        if (this.getSession().isAborted()) {
            getMethod.releaseConnection();
            return null;
        }
        httpClient.executeMethod((HttpMethod)getMethod);
        if (this.getSession().isAborted()) {
            getMethod.releaseConnection();
            return null;
        }
        if (getMethod.getResponseHeader("Content-Type").getValue().equalsIgnoreCase("text/html")) {
            throw new CCSGeneralException("PPRESP_ERROR", new String[]{this.m_ReportPath}, 500);
        }
        if (getMethod.getResponseHeader("Content-Length") != null && (l = Long.parseLong(getMethod.getResponseHeader("Content-Length").getValue())) > ConfigMgr.getInstance().getDataLimit()) {
            getMethod.releaseConnection();
            ContentProvider.logGovernorErrorDetails(l, null, null);
            throw new CCSGovernorException("GOVERNOR_ERROR", new String[]{this.m_ReportPath});
        }
        return getMethod;
    }

    private void processStyles(Element element) throws CCSGeneralException {
        if (StaticStyles != null) {
            Iterator iterator = StaticStyles.iterator();
            Element element2 = null;
            while (iterator.hasNext()) {
                element2 = (Element)iterator.next();
                element2.detach();
                element.add(element2);
            }
        }
        this.processExceptionStyles(element, element);
    }

    @Override
    public InputStream[] getInputStreams() throws CCSGeneralException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            ((Writer)object).write(this.m_SavedXML);
            ((OutputStreamWriter)object).flush();
        }
        catch (Exception exception) {
            return null;
        }
        object = byteArrayOutputStream.toByteArray();
        return new InputStream[]{new ByteArrayInputStream((byte[])object)};
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, false, false, false);
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl3, false, false);
    }

    @Override
    @Deprecated
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3, boolean bl4) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.retrieveDataContent(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, bl3, bl4, false);
    }

    @Override
    public Conversation retrieveDataContent(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3, boolean bl4, boolean bl5) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrievePPContent(false);
        return null;
    }

    @Override
    @Deprecated
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveMetaContent(promptValueArray, bl, false, false);
    }

    @Override
    @Deprecated
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl, boolean bl2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveMetaContent(promptValueArray, bl, bl2, false);
    }

    @Override
    public void retrieveMetaContent(PromptValue[] promptValueArray, boolean bl, boolean bl2, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrievePPContent(true);
        this.downgradeMeta();
    }

    @Override
    public Conversation retrievePromptDescription(PromptValue[] promptValueArray, SearchPromptValue searchPromptValue, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException {
        this.m_SavedXML = "<rds:prompts xmlns:rds=\"http://developer.cognos.com/schemas/rds/types/2\"/>";
        return null;
    }

    protected void processExceptionStyles(Element element, Element element2) throws CCSGeneralException {
        Collection collection;
        XPath xPath = element.getDocument().createXPath("/rdsCM:document/rdsCM:pages/rdsCM:page/rdsCM:body/rdsCM:item/rdsCM:ctab/rdsCM:table/rdsCM:row/rdsCM:cell//rdsCM:unprocessedException");
        SimpleNamespaceContext simpleNamespaceContext = this.getNamespaceContext();
        xPath.setNamespaceContext((NamespaceContext)simpleNamespaceContext);
        List list = xPath.selectNodes((Object)element.getDocument());
        Iterator iterator = list.iterator();
        Element element3 = null;
        String string = null;
        StyleParser styleParser = new StyleParser(Constants.NamespaceVersion.V2);
        while (iterator.hasNext()) {
            QName qName;
            int n;
            element3 = (Element)iterator.next();
            if (element3 == null) {
                return;
            }
            string = styleParser.parsePPStyle(element3);
            collection = element3.getParent().getParent();
            List list2 = collection.elements();
            StyleGroup styleGroup = DocumentHelper.createElement((QName)this.m_Schema.getStyleIDQN());
            for (n = 0; n < list2.size() && (qName = ((Element)list2.get(n)).getQName()).equals((Object)this.m_Schema.getStyleIDQN()); ++n) {
            }
            styleGroup.setText(string);
            list2.add(n, styleGroup);
            element3.detach();
        }
        collection = styleParser.getStyles();
        for (StyleGroup styleGroup : collection) {
            element2.add(styleGroup.toXML());
        }
    }

    @Override
    public void upgradeIDs(String string, String[] stringArray, BaseRDSSession baseRDSSession, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        this.upgradeIDs(string, stringArray, baseRDSSession, bl, false);
    }

    @Override
    public void upgradeIDs(String string, String[] stringArray, BaseRDSSession baseRDSSession, boolean bl, boolean bl2) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        this.m_SavedXML = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = null;
            boolean bl3 = true;
            string2 = stringArray[i];
            Element element = DocumentHelper.createElement((QName)this.m_Schema.getUMappingQN());
            element.addElement(this.m_Schema.getUOldQN()).addText(stringArray[i]);
            Element element2 = element.addElement(this.m_Schema.getUNewQN());
            if (string2 != null) {
                element2.addText(string2);
            }
            element.addElement(this.m_Schema.getUFoundQN()).addText(bl3 ? "true" : "false");
            this.m_SavedXML = this.m_SavedXML + element.asXML();
        }
        Element element = DocumentHelper.createElement((QName)this.m_Schema.getUSPathQN());
        element.setText(string);
        this.m_SavedXML = this.m_SavedXML + element.asXML();
    }

    @Override
    @Deprecated
    public Conversation beginRetrieveData(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.beginRetrieveData(string, string2, string3, string4, string5, promptValueArray, bl, bl2, conversation, false);
    }

    @Override
    public Conversation beginRetrieveData(String string, String string2, String string3, String string4, String string5, PromptValue[] promptValueArray, boolean bl, boolean bl2, Conversation conversation, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        if (conversation == null) {
            conversation = new Conversation(new BiBusHeader());
        }
        conversation.setProperty("searchPath", this.m_ReportPath);
        conversation.setProperty("versionType", string);
        conversation.setProperty("status", "complete");
        return conversation;
    }

    @Override
    public Conversation checkDataStatus(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        conversation.setProperty("status", "complete");
        return conversation;
    }

    @Override
    public void retrieveDataOutput(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        String string = (String)conversation.getProperty("versionType");
        this.retrieveDataContent(string, null, null, null, null, null, false, true, conversation, false, false, false);
    }

    @Override
    public void releaseConversation(Conversation conversation) throws CCSGeneralException {
    }

    @Override
    public void cancelConversation(Conversation conversation) throws CCSGeneralException {
    }

    @Override
    public void drill(String string, String string2, String string3) throws CCSGeneralException {
        throw new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
    }

    @Override
    public String generateAtomFeed(String string, String string2, String string3, String string4) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        try {
            this.m_Connection.getRoutingServerGroupName(this.m_ReportPath);
            URL uRL = new URL(this.buildDataURL());
            HttpClient httpClient = this.createClientConnection(uRL);
            GetMethod getMethod = this.executeRequest(uRL, httpClient);
            if (getMethod == null) {
                throw new CCSGeneralException("PPRESP_ERROR", new String[]{this.m_ReportPath}, 500);
            }
            Document document = AtomTransform.convert(new PPInputStream(this.m_ReportPath, ConfigMgr.getInstance().getDataLimit(), this.getResponseStream(getMethod)));
            Element element = document.getRootElement();
            getMethod.releaseConnection();
            uRL = new URL(this.buildChartURL());
            getMethod = this.executeRequest(uRL, httpClient);
            if (getMethod == null) {
                throw new CCSGeneralException("PPRESP_ERROR", new String[]{this.m_ReportPath}, 500);
            }
            Document document2 = AtomChartTransform.convert(new PPInputStream(this.m_ReportPath, ConfigMgr.getInstance().getDataLimit(), this.getResponseStream(getMethod)));
            List list = document2.getRootElement().elements();
            for (Element element2 : list) {
                element2.detach();
                element.add(element2);
            }
            return this.prepareFeed(string, element, string4);
        }
        catch (CCSGeneralException cCSGeneralException) {
            throw cCSGeneralException;
        }
        catch (CCSGovernorException cCSGovernorException) {
            throw new CCSGeneralException(cCSGovernorException.getMessage(), cCSGovernorException.getParms(), cCSGovernorException, 500);
        }
        catch (IOException iOException) {
            throw new CCSGeneralException("PPRESP_ERROR", new String[]{this.m_ReportPath}, iOException, 500);
        }
    }

    @Override
    public Conversation beginRetrieveMeta(PromptValue[] promptValueArray, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        return this.beginRetrieveMeta(promptValueArray, bl, false);
    }

    @Override
    public Conversation beginRetrieveMeta(PromptValue[] promptValueArray, boolean bl, boolean bl2) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        Conversation conversation = new Conversation(this.m_Connection.getCMBus());
        conversation.setProperty("searchPath", this.m_ReportPath);
        conversation.setProperty("status", "complete");
        return conversation;
    }

    @Override
    public void retrieveMetaOutput(Conversation conversation) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        this.m_Connection.getRoutingServerGroupName(this.m_ReportPath);
        this.retrievePPContent(true);
        boolean bl = Utilities.parseOptionalObjectBoolean(conversation.getProperty("ReportInfoLegacyCall"), true);
        if (bl) {
            this.downgradeMeta();
        }
    }

    protected void downgradeMeta() {
        String string = this.m_SavedXML.replace("rds/types/2", "rds/types/1");
        this.m_SavedXML = string = string.replace("http://www.ibm.com/xmlns/prod/cognos/layoutData/200904", "http://developer.cognos.com/schemas/rds/contentmodel/1");
    }

    @Override
    public Conversation retrieveTreePromptNode(Conversation conversation, PromptValue[] promptValueArray) throws CCSGeneralException, CCSAuthenticationException {
        return null;
    }

    @Override
    public String getViewerURL(String string) throws CCSGeneralException, CCSAuthenticationException {
        return null;
    }

    @Override
    public String generateAtomFeed_DS(String string, String string2, String string3, String string4, String string5, boolean bl) throws CCSGeneralException, CCSPromptException, CCSAuthenticationException {
        return this.generateAtomFeed(string, string2, string3, string5);
    }

    @Override
    public Conversation restoreConversation(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        this.retrieveDataOutput(conversation);
        conversation.setProperty("status", "complete");
        return conversation;
    }

    @Override
    public void saveDataContent(Conversation conversation) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
    }

    @Override
    public BiBusHeader getBiBusHeader() {
        return new BiBusHeader();
    }

    protected String getRoutingServerGroup() {
        RoutingInfo routingInfo = null;
        if (null != this.m_Connection.getCognosPowerPlay()) {
            routingInfo = this.m_Connection.getPPBus().getRouting();
        }
        if (null != routingInfo) {
            String string = routingInfo.getRoutingServerGroup();
            return string;
        }
        if (!Utilities.isNullOrEmpty(this.getSession().getRoutingServerGroup())) {
            return this.getSession().getRoutingServerGroup();
        }
        return null;
    }

    @Override
    public ManagedAttachment getAttachment() {
        return null;
    }

    static {
        DataTransform = null;
        MetaTransform = null;
        ChartMetaTransform = null;
        AtomTransform = null;
        AtomChartTransform = null;
        StaticStyles = null;
        StaticLayout = null;
        mutex = null;
    }
}

