/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.ccs.content.RDSSchema;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.HierarchicalParmValueItem;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class PromptValue {
    public static final String TRUE = "true";
    protected ParameterValue m_Value = null;
    protected RDSSchema m_Schema = null;

    private PromptValue(Constants.NamespaceVersion namespaceVersion) {
        this.m_Schema = RDSSchema.getInstance(namespaceVersion);
    }

    public static ParameterValue[] toPValueArray(PromptValue[] promptValueArray) {
        ParameterValue[] parameterValueArray = null;
        if (promptValueArray != null) {
            parameterValueArray = new ParameterValue[promptValueArray.length];
            for (int i = 0; i < promptValueArray.length; ++i) {
                parameterValueArray[i] = promptValueArray[i].toPValue();
            }
        }
        return parameterValueArray;
    }

    public static PromptValue[] toPrompValueArray(ParameterValue[] parameterValueArray) {
        PromptValue[] promptValueArray = null;
        if (parameterValueArray != null) {
            promptValueArray = new PromptValue[parameterValueArray.length];
            for (int i = 0; i < parameterValueArray.length; ++i) {
                promptValueArray[i] = new PromptValue(parameterValueArray[i]);
            }
        }
        return promptValueArray;
    }

    public static PromptValue parsePromptValue(Element element, Constants.NamespaceVersion namespaceVersion) throws CCSGeneralException {
        PromptValue promptValue = new PromptValue(namespaceVersion);
        promptValue.parseXML(element);
        return promptValue;
    }

    public static PromptValue[] parseSimplifiedPrompts(Element element) {
        PromptValue[] promptValueArray;
        Iterator iterator = element.elements().iterator();
        Vector<Element> vector = new Vector<Element>();
        while (iterator.hasNext()) {
            SimpleParmValueItem simpleParmValueItem;
            Element element22;
            promptValueArray = (PromptValue[])iterator.next();
            String string = promptValueArray.getName();
            if (!string.endsWith("Prompt")) continue;
            Vector<Object> vector2 = new Vector<Object>();
            string = string.substring(0, string.lastIndexOf("Prompt"));
            string = CCSFormatter.decodeName(string);
            for (Element element22 : promptValueArray.elements()) {
                SimpleParmValueItem simpleParmValueItem2;
                BoundRangeParmValueItem boundRangeParmValueItem;
                if (element22.getName().equals("useValue")) {
                    simpleParmValueItem = new SimpleParmValueItem();
                    simpleParmValueItem.setInclusive(new Boolean(true).booleanValue());
                    simpleParmValueItem.setUse(element22.getStringValue());
                    vector2.add(simpleParmValueItem);
                    continue;
                }
                if (!element22.getName().equals("range")) continue;
                simpleParmValueItem = element22.element("minUseValue");
                Element element3 = element22.element("maxUseValue");
                if (simpleParmValueItem != null && element3 != null) {
                    boundRangeParmValueItem = new BoundRangeParmValueItem();
                    boundRangeParmValueItem.setInclusive(new Boolean(true).booleanValue());
                    simpleParmValueItem2 = new SimpleParmValueItem();
                    simpleParmValueItem2.setInclusive(new Boolean(true).booleanValue());
                    simpleParmValueItem2.setUse(simpleParmValueItem.getStringValue());
                    SimpleParmValueItem simpleParmValueItem3 = new SimpleParmValueItem();
                    simpleParmValueItem3.setUse(element3.getStringValue());
                    simpleParmValueItem3.setInclusive(new Boolean(true).booleanValue());
                    boundRangeParmValueItem.setStart(simpleParmValueItem2);
                    boundRangeParmValueItem.setEnd(simpleParmValueItem3);
                    vector2.add(boundRangeParmValueItem);
                    continue;
                }
                if (simpleParmValueItem != null) {
                    boundRangeParmValueItem = new UnboundedEndRangeParmValueItem();
                    boundRangeParmValueItem.setInclusive(new Boolean(true).booleanValue());
                    simpleParmValueItem2 = new SimpleParmValueItem();
                    simpleParmValueItem2.setInclusive(new Boolean(true).booleanValue());
                    simpleParmValueItem2.setUse(simpleParmValueItem.getStringValue());
                    boundRangeParmValueItem.setStart(simpleParmValueItem2);
                    vector2.add(boundRangeParmValueItem);
                    continue;
                }
                if (element3 == null) continue;
                boundRangeParmValueItem = new UnboundedStartRangeParmValueItem();
                boundRangeParmValueItem.setInclusive(new Boolean(true).booleanValue());
                simpleParmValueItem2 = new SimpleParmValueItem();
                simpleParmValueItem2.setInclusive(new Boolean(true).booleanValue());
                simpleParmValueItem2.setUse(element3.getStringValue());
                boundRangeParmValueItem.setEnd(simpleParmValueItem2);
                vector2.add(boundRangeParmValueItem);
            }
            element22 = new ParameterValue();
            element22.setName(string);
            simpleParmValueItem = new ParmValueItem[vector2.size()];
            System.arraycopy(vector2.toArray(), 0, simpleParmValueItem, 0, vector2.size());
            element22.setValue((ParmValueItem[])simpleParmValueItem);
            vector.add(element22);
        }
        promptValueArray = new PromptValue[vector.size()];
        for (int i = 0; i < promptValueArray.length; ++i) {
            promptValueArray[i] = new PromptValue((ParameterValue)vector.get(i));
        }
        return promptValueArray;
    }

    public PromptValue(ParameterValue parameterValue) {
        this.m_Value = parameterValue;
        this.m_Schema = RDSSchema.getInstance(Constants.NamespaceVersion.V1);
    }

    public ParameterValue toPValue() {
        return this.m_Value;
    }

    public Element toXML() {
        return this.toXML(this.m_Schema.getRdsNamespace(), true);
    }

    public Element toXML(Namespace namespace, boolean bl) {
        Element element = DocumentHelper.createElement((QName)new QName("promptValues", namespace));
        Element element2 = element.addElement(new QName("name", namespace));
        element2.setText(this.m_Value.getName());
        ParmValueItem[] parmValueItemArray = this.m_Value.getValue();
        Element element3 = element.addElement(new QName("values", namespace));
        Element element4 = null;
        Element element5 = null;
        Element element6 = null;
        Element element7 = null;
        Element element8 = null;
        for (int i = 0; i < parmValueItemArray.length; ++i) {
            SimpleParmValueItem simpleParmValueItem;
            if (parmValueItemArray[i] instanceof SimpleParmValueItem) {
                simpleParmValueItem = (SimpleParmValueItem)parmValueItemArray[i];
                element4 = element3.addElement(new QName("item", namespace));
                element5 = element4.addElement(new QName("SimplePValue", namespace));
                this.GenerateSimpleValue(simpleParmValueItem, element5, namespace);
                continue;
            }
            if (parmValueItemArray[i] instanceof BoundRangeParmValueItem) {
                simpleParmValueItem = (BoundRangeParmValueItem)parmValueItemArray[i];
                element4 = element3.addElement(new QName("item", namespace));
                element5 = element4.addElement(new QName("RangePValue", namespace));
                element6 = element5.addElement(new QName("inclusive", namespace));
                element6.setText(new Boolean(simpleParmValueItem.isInclusive()).toString());
                element7 = element5.addElement(new QName("start", namespace));
                element8 = element5.addElement(new QName("end", namespace));
                this.GenerateSimpleValue(simpleParmValueItem.getStart(), element7, namespace);
                this.GenerateSimpleValue(simpleParmValueItem.getEnd(), element8, namespace);
                continue;
            }
            if (parmValueItemArray[i] instanceof UnboundedStartRangeParmValueItem) {
                simpleParmValueItem = (UnboundedStartRangeParmValueItem)parmValueItemArray[i];
                element4 = element3.addElement(new QName("item", namespace));
                element5 = element4.addElement(new QName("RangePValue", namespace));
                element6 = element5.addElement(new QName("inclusive", namespace));
                element6.setText(new Boolean(simpleParmValueItem.isInclusive()).toString());
                element8 = element5.addElement(new QName("end", namespace));
                this.GenerateSimpleValue(simpleParmValueItem.getEnd(), element8, namespace);
                continue;
            }
            if (parmValueItemArray[i] instanceof UnboundedEndRangeParmValueItem) {
                simpleParmValueItem = (UnboundedEndRangeParmValueItem)parmValueItemArray[i];
                element4 = element3.addElement(new QName("item", namespace));
                element5 = element4.addElement(new QName("RangePValue", namespace));
                element6 = element5.addElement(new QName("inclusive", namespace));
                element6.setText(new Boolean(simpleParmValueItem.isInclusive()).toString());
                element7 = element5.addElement(new QName("start", namespace));
                this.GenerateSimpleValue(simpleParmValueItem.getStart(), element7, namespace);
                continue;
            }
            if (!(parmValueItemArray[i] instanceof HierarchicalParmValueItem)) continue;
        }
        return element;
    }

    public String toSelValue() {
        String string = new String();
        ParameterValue parameterValue = this.toPValue();
        String string2 = parameterValue.getName();
        ParmValueItem[] parmValueItemArray = parameterValue.getValue();
        String string3 = "<selectChoices>";
        for (ParmValueItem parmValueItem : parmValueItemArray) {
            String string4;
            String string5;
            SimpleParmValueItem simpleParmValueItem;
            if (parmValueItem instanceof SimpleParmValueItem) {
                simpleParmValueItem = (SimpleParmValueItem)parmValueItem;
                string5 = this.parameterValueItemXml(simpleParmValueItem, "selectOption");
                string3 = string3 + string5;
                continue;
            }
            if (parmValueItem instanceof BoundRangeParmValueItem) {
                simpleParmValueItem = (BoundRangeParmValueItem)parmValueItem;
                string3 = string3 + "<selectBoundRange selected=\"true\">";
                string5 = simpleParmValueItem.getStart();
                string4 = this.parameterValueItemXml((SimpleParmValueItem)string5, "start");
                string3 = string3 + string4;
                SimpleParmValueItem simpleParmValueItem2 = simpleParmValueItem.getEnd();
                String string6 = this.parameterValueItemXml(simpleParmValueItem2, "end");
                string3 = string3 + string6;
                string3 = string3 + "</selectBoundRange>";
                continue;
            }
            if (parmValueItem instanceof UnboundedStartRangeParmValueItem) {
                simpleParmValueItem = (UnboundedStartRangeParmValueItem)parmValueItem;
                simpleParmValueItem.isInclusive();
                string3 = string3 + "<selectUnboundedStartRange selected=\"true\">";
                string5 = simpleParmValueItem.getEnd();
                string4 = this.parameterValueItemXml((SimpleParmValueItem)string5, "end");
                string3 = string3 + string4;
                string3 = string3 + "</selectUnboundedStartRange>";
                continue;
            }
            if (parmValueItem instanceof UnboundedEndRangeParmValueItem) {
                simpleParmValueItem = (UnboundedEndRangeParmValueItem)parmValueItem;
                string3 = string3 + "<selectUnboundedEndRange selected=\"true\">";
                string5 = simpleParmValueItem.getStart();
                string4 = this.parameterValueItemXml((SimpleParmValueItem)string5, "start");
                string3 = string3 + string4;
                string3 = string3 + "</selectUnboundedEndRange>";
                continue;
            }
            if (!(parmValueItem instanceof HierarchicalParmValueItem)) continue;
        }
        string3 = string3 + "</selectChoices>";
        String string7 = Utilities.IRIEncode(string3, false);
        string = "p_" + string2 + "=" + string7;
        return string;
    }

    private String parameterValueItemXml(SimpleParmValueItem simpleParmValueItem, String string) {
        String string2 = "<";
        string2 = string2 + string;
        string2 = string2 + " displayValue=\"";
        string2 = string2 + simpleParmValueItem.getDisplay();
        string2 = string2 + "\"";
        string2 = string2 + " useValue=\"";
        string2 = string2 + simpleParmValueItem.getUse();
        string2 = string2 + "\"/>";
        return string2;
    }

    private void parseXML(Element element) throws CCSGeneralException {
        this.m_Value = new ParameterValue();
        Element element2 = element.element(this.m_Schema.getPNameQN().getName());
        if (element2 == null) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        this.m_Value.setName(element2.getStringValue());
        Element element3 = element.element(this.m_Schema.getPItemValuesQN().getName());
        if (element3 == null) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        List list = element3.elements(this.m_Schema.getPItemQN().getName());
        Iterator iterator = list.iterator();
        Element element4 = null;
        Element element5 = null;
        ParmValueItem[] parmValueItemArray = new ParmValueItem[list.size()];
        int n = 0;
        while (iterator.hasNext()) {
            element4 = (Element)iterator.next();
            element5 = (Element)element4.elements().get(0);
            if (element5.getName().equals("sval")) {
                parmValueItemArray[n] = this.parseSVal(element5);
            } else if (element5.getName().equals("rval")) {
                UnboundedStartRangeParmValueItem unboundedStartRangeParmValueItem;
                Element element6 = element5.element("min");
                Element element7 = element5.element("max");
                if (element6 == null && element7 == null) continue;
                if (element6 == null && element7 != null) {
                    unboundedStartRangeParmValueItem = new UnboundedStartRangeParmValueItem();
                    unboundedStartRangeParmValueItem.setInclusive(true);
                    unboundedStartRangeParmValueItem.setEnd(this.parseSVal(element7));
                    parmValueItemArray[n] = unboundedStartRangeParmValueItem;
                } else if (element6 != null && element7 != null) {
                    unboundedStartRangeParmValueItem = new BoundRangeParmValueItem();
                    unboundedStartRangeParmValueItem.setInclusive(true);
                    unboundedStartRangeParmValueItem.setStart(this.parseSVal(element6));
                    unboundedStartRangeParmValueItem.setEnd(this.parseSVal(element7));
                    parmValueItemArray[n] = unboundedStartRangeParmValueItem;
                } else {
                    unboundedStartRangeParmValueItem = new UnboundedEndRangeParmValueItem();
                    unboundedStartRangeParmValueItem.setInclusive(true);
                    unboundedStartRangeParmValueItem.setStart(this.parseSVal(element6));
                    parmValueItemArray[n] = unboundedStartRangeParmValueItem;
                }
            } else {
                this.parseLegacyPrompts(element4, parmValueItemArray, n);
            }
            ++n;
        }
        this.m_Value.setValue(parmValueItemArray);
    }

    private void parseLegacyPrompts(Element element, ParmValueItem[] parmValueItemArray, int n) throws CCSGeneralException {
        if (element.element(this.m_Schema.getSimplePValueQN().getName()) != null) {
            Element element2 = element.element(this.m_Schema.getSimplePValueQN().getName());
            parmValueItemArray[n] = this.parseSimpleValue(element2);
        } else if (element.element(this.m_Schema.getRangePValueQN().getName()) != null) {
            Element element3 = element.element(this.m_Schema.getRangePValueQN().getName());
            Element element4 = element3.element(this.m_Schema.getStartQN().getName());
            Element element5 = element3.element(this.m_Schema.getEndQN().getName());
            String string = element3.element(this.m_Schema.getInclusiveQN().getName()).getStringValue();
            if (element4 != null && element5 != null) {
                BoundRangeParmValueItem boundRangeParmValueItem = new BoundRangeParmValueItem();
                boundRangeParmValueItem.setStart(this.parseSimpleValue(element4));
                boundRangeParmValueItem.setEnd(this.parseSimpleValue(element5));
                boundRangeParmValueItem.setInclusive(TRUE.equals(string) || "1".equals(string));
                parmValueItemArray[n] = boundRangeParmValueItem;
            } else if (element4 != null) {
                UnboundedEndRangeParmValueItem unboundedEndRangeParmValueItem = new UnboundedEndRangeParmValueItem();
                unboundedEndRangeParmValueItem.setStart(this.parseSimpleValue(element4));
                unboundedEndRangeParmValueItem.setInclusive(TRUE.equals(string) || "1".equals(string));
                parmValueItemArray[n] = unboundedEndRangeParmValueItem;
            } else {
                UnboundedStartRangeParmValueItem unboundedStartRangeParmValueItem = new UnboundedStartRangeParmValueItem();
                unboundedStartRangeParmValueItem.setEnd(this.parseSimpleValue(element5));
                unboundedStartRangeParmValueItem.setInclusive(TRUE.equals(string) || "1".equals(string));
                parmValueItemArray[n] = unboundedStartRangeParmValueItem;
            }
        } else if (element.element(this.m_Schema.getTreePValueQN().getName()) == null) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
    }

    private void GenerateSimpleValue(SimpleParmValueItem simpleParmValueItem, Element element, Namespace namespace) {
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        element2 = element.addElement(new QName("inclusive", namespace));
        element2.setText(new Boolean(simpleParmValueItem.isInclusive()).toString());
        element3 = element.addElement(new QName("useValue", namespace));
        if (simpleParmValueItem.getUse() == null) {
            element3.addAttribute(new QName("nil"), TRUE);
        } else {
            element3.setText(simpleParmValueItem.getUse());
        }
        if (simpleParmValueItem.getDisplay() != null) {
            element4 = element.addElement(new QName("displayValue", namespace));
            element4.setText(simpleParmValueItem.getDisplay());
        }
    }

    private SimpleParmValueItem parseSVal(Element element) throws CCSGeneralException {
        if (null == element) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        SimpleParmValueItem simpleParmValueItem = new SimpleParmValueItem();
        simpleParmValueItem.setInclusive(true);
        if (Utilities.parseOptionalXMLBoolean(element.elementText("nullUse"), false)) {
            simpleParmValueItem.setUse(null);
        } else {
            simpleParmValueItem.setUse(element.elementText("use"));
        }
        Element element2 = element.element("display");
        if (element2 != null) {
            if (Utilities.parseOptionalXMLBoolean(element.elementText("nullDisplay"), false)) {
                simpleParmValueItem.setDisplay(null);
            } else {
                simpleParmValueItem.setDisplay(element.elementText("display"));
            }
        }
        return simpleParmValueItem;
    }

    private SimpleParmValueItem parseSimpleValue(Element element) throws CCSGeneralException {
        if (null == element) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        SimpleParmValueItem simpleParmValueItem = new SimpleParmValueItem();
        Element element2 = element.element(this.m_Schema.getInclusiveQN().getName());
        if (null == element2) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        String string = element2.getStringValue();
        simpleParmValueItem.setInclusive(TRUE.equals(string) || "1".equals(string));
        Element element3 = element.element(this.m_Schema.getUseValueQN().getName());
        if (null == element3) {
            throw new CCSGeneralException("REQUEST_ERROR", 400);
        }
        String string2 = element3.getStringValue();
        if (TRUE.equals(element3.attributeValue("nil"))) {
            string2 = null;
        }
        simpleParmValueItem.setUse(string2);
        Element element4 = element.element(this.m_Schema.getDisplayValueQN().getName());
        if (element4 != null) {
            String string3 = element4.getStringValue();
            if (TRUE.equals(element4.attributeValue("nil"))) {
                string3 = null;
            }
            simpleParmValueItem.setDisplay(string3);
        }
        return simpleParmValueItem;
    }
}

