/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.SoapParms;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.Serializable;
import org.dom4j.Element;

public class SearchPromptValue
implements Serializable {
    static final long serialVersionUID = 0L;
    protected String m_promptID;
    protected String m_parameterName;
    protected String m_value;
    protected boolean m_caseInsensitive = true;
    protected boolean m_matchAll = false;
    protected boolean m_matchAnywhere = false;

    public static SearchPromptValue parseFormFields(BIBusEnvelope bIBusEnvelope) throws CCSGeneralException {
        SearchPromptValue searchPromptValue = new SearchPromptValue();
        searchPromptValue.m_value = bIBusEnvelope.getFormValue("srchval");
        searchPromptValue.m_promptID = bIBusEnvelope.getFormValue("swsID");
        searchPromptValue.m_parameterName = bIBusEnvelope.getFormValue("pname");
        searchPromptValue.m_caseInsensitive = Utilities.parseOptionalXMLBoolean(bIBusEnvelope.getFormValue("nocase"), true);
        searchPromptValue.m_matchAll = Utilities.parseOptionalXMLBoolean(bIBusEnvelope.getFormValue("mtchAll"), false);
        searchPromptValue.m_matchAnywhere = Utilities.parseOptionalXMLBoolean(bIBusEnvelope.getFormValue("mtchAny"), false);
        if (searchPromptValue.m_value == null || searchPromptValue.m_promptID == null || searchPromptValue.m_parameterName == null) {
            return null;
        }
        return searchPromptValue;
    }

    public void parseSearchXML(Element element) throws CCSGeneralException {
        this.m_value = SoapParms.getStringParm(element, "srchval", null, false);
        this.m_promptID = SoapParms.getStringParm(element, "swsID", null, false);
        this.m_parameterName = SoapParms.getStringParm(element, "pname", null, false);
        this.m_caseInsensitive = SoapParms.getBooleanParm(element, "nocase", true, true);
        this.m_matchAll = SoapParms.getBooleanParm(element, "mtchAll", false, true);
        this.m_matchAnywhere = SoapParms.getBooleanParm(element, "mtchAny", false, true);
    }

    public void parseXML(Element element) throws CCSGeneralException {
        this.m_value = SoapParms.getStringParm(element, "value", null, false);
        this.m_promptID = SoapParms.getStringParm(element, "id", null, false);
        this.m_parameterName = SoapParms.getStringParm(element, "parameterName", null, false);
        this.m_caseInsensitive = SoapParms.getBooleanParm(element, "caseInsensitive", true, true);
        this.m_matchAll = SoapParms.getBooleanParm(element, "matchAll", false, true);
        this.m_matchAnywhere = SoapParms.getBooleanParm(element, "matchAnywhere", false, true);
    }

    public FormFieldVar[] getFormFields() {
        FormFieldVar[] formFieldVarArray = new FormFieldVar[]{this.createVar("_sws_" + this.m_promptID + "_searchValue", this.m_value), this.createVar("_sws_" + this.m_promptID + "_submit", "true"), this.createVar("p_" + this.m_parameterName, ""), this.createVar("_searchParameter", this.m_parameterName), this.createVar("_promptIdBasedNames", "true"), this.createVar("_promptControl", "search"), this.m_caseInsensitive ? this.createVar("_sws_" + this.m_promptID + "_caseInsensitive", "true") : this.createVar("_sws_" + this.m_promptID + "_caseInsensitive", "false"), this.m_matchAll ? this.createVar("_sws_" + this.m_promptID + "_matchAll", "true") : this.createVar("_sws_" + this.m_promptID + "_matchAll", "false"), this.m_matchAnywhere ? this.createVar("_sws_" + this.m_promptID + "_matchAnywhere", "true") : this.createVar("_sws_" + this.m_promptID + "_matchAnywhere", "false")};
        return formFieldVarArray;
    }

    protected FormFieldVar createVar(String string, String string2) {
        FormFieldVar formFieldVar = new FormFieldVar();
        formFieldVar.setName(string);
        formFieldVar.setFormat(FormatEnum.not_encrypted);
        formFieldVar.setValue(string2);
        return formFieldVar;
    }

    public ParameterValue getParameterValue() {
        ParameterValue parameterValue = new ParameterValue();
        parameterValue.setName(this.m_parameterName);
        parameterValue.setValue(new ParmValueItem[0]);
        return parameterValue;
    }
}

