/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.ccs.content.RDSSchema;
import com.cognos.ccs.content.style.AComplexProperty;
import com.cognos.ccs.content.style.AStyleProperty;
import com.cognos.ccs.content.style.BorderStyleProperty;
import com.cognos.ccs.content.style.ColorStyleProperty;
import com.cognos.ccs.content.style.FontStyleProperty;
import com.cognos.ccs.content.style.SizeStyleProperty;
import com.cognos.ccs.content.style.StringStyleProperty;
import com.cognos.ccs.content.style.TextStyleProperty;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class StyleGroup
extends AComplexProperty {
    private static final String VERTICAL_ALIGN_CSS = "vertical-align";
    private static final String TEXT_ALIGN_CSS = "text-align";
    private static final String BACKGROUND_COLOR_CSS = "background-color";
    private static final String COLOR_CSS = "color";
    private static final String BORDER_BOTTOM_CSS = "border-bottom";
    private static final String BORDER_RIGHT_CSS = "border-right";
    private static final String BORDER_LEFT_CSS = "border-left";
    private static final String BORDER_TOP_CSS = "border-top";
    private static final String PADDING_BOTTOM_CSS = "padding-bottom";
    private static final String PADDING_RIGHT_CSS = "padding-right";
    private static final String PADDING_LEFT_CSS = "padding-left";
    private static final String PADDING_TOP_CSS = "padding-top";
    private static final String MARGIN_BOTTOM_CSS = "margin-bottom";
    private static final String MARGIN_RIGHT_CSS = "margin-right";
    private static final String MARGIN_LEFT_CSS = "margin-left";
    private static final String MARGIN_TOP_CSS = "margin-top";
    private static final String BACKGROUND_IMAGE_CSS = "background-image";
    private static final String WHITESPACE_KEY_CSS = "white-space";
    private static final String CSS_TYPE_CLOSE = "; ";
    private static final String CSS_TYPE_SEP = ":";
    private static final String BOTTOM_BORDER_KEY = "bottomBorder";
    private static final String RIGHT_BORDER_KEY = "rightBorder";
    private static final String LEFT_BORDER_KEY = "leftBorder";
    private static final String TOP_BORDER_KEY = "topBorder";
    private static final String PADDING_BOTTOM_KEY = "paddingBottom";
    private static final String PADDING_RIGHT_KEY = "paddingRight";
    private static final String PADDING_LEFT_KEY = "paddingLeft";
    private static final String PADDING_TOP_KEY = "paddingTop";
    private static final String BOTTOM_MARGIN_KEY = "bottomMargin";
    private static final String RIGHT_MARGIN_KEY = "rightMargin";
    private static final String LEFT_MARGIN_KEY = "leftMargin";
    private static final String TOP_MARGIN_KEY = "topMargin";
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private static final String FONT_KEY = "font";
    private static final String VALIGN_KEY = "valign";
    private static final String HALIGN_KEY = "halign";
    private static final String BGCOLOR_KEY = "bgcolor";
    private static final String FGCOLOR_KEY = "fgcolor";
    private static final String TOP_KEY = "top";
    private static final String LEFT_KEY = "left";
    private static final String POSITION_KEY = "position";
    private static final String BACKGROUND_IMAGE_KEY = "background-image";
    private static final String BACKGROUND_POSITION_CSS = "background-position";
    private static final String BACKGROUND_REPEAT_CSS = "background-repeat";
    private static final String DISPLAY_KEY = "display";
    private static final String TEXTSTYLE_KEY = "textStyle";
    protected String name;
    protected String m_webRoot = "/ibmcognos";

    public StyleGroup(Constants.NamespaceVersion namespaceVersion) {
        super(RDSSchema.getInstance(namespaceVersion).getStyleGroupQN(), namespaceVersion);
    }

    public StyleGroup(Element element, Constants.NamespaceVersion namespaceVersion, String string, String string2) {
        super(RDSSchema.getInstance(namespaceVersion).getStyleGroupQN(), namespaceVersion);
        this.m_webRoot = string;
        Element element2 = this.getChildElement(element, this.schema.getStyleNameQN());
        this.name = string2 == null ? element2.getText() : element2.getText() + string2;
        this.deserializeTopLevelElements(element);
        this.deserializeBoxStyle(element);
    }

    private void deserializeTopLevelElements(Element element) {
        this.addChildColorProp(element, this.schema.getColorQN(), FGCOLOR_KEY);
        this.addChildColorProp(element, this.schema.getBgColorQN(), BGCOLOR_KEY);
        this.addChildStringProp(element, this.schema.getHalignQN(), HALIGN_KEY);
        this.addChildStringProp(element, this.schema.getValignQN(), VALIGN_KEY);
        this.addChildFontProp(element, this.schema.getFontQN(), FONT_KEY);
        this.addChildStringProp(element, this.schema.getDisplayQN(), DISPLAY_KEY);
        this.addChildTextStyleProp(element, this.schema.getTextStyleQN(), TEXTSTYLE_KEY);
        this.addBGImageProp(element);
    }

    private void addBGImageProp(Element element) {
        String string;
        Element element2 = element.element(this.schema.getBGImageQN());
        if (element2 != null) {
            string = element2.getTextTrim();
            if (string.startsWith("..")) {
                string = string.replace("..", this.m_webRoot);
            }
            string = "url('" + string + "')";
            this.properties.put("background-image", new StringStyleProperty(this.schema.getBgColorQN(), string, this.namespaceVersion == Constants.NamespaceVersion.V3 ? Constants.NamespaceVersion.V3 : Constants.NamespaceVersion.V2));
        }
        if (null != (string = element.element(this.schema.getBGImagePropQN()))) {
            Element element3;
            Element element4 = this.getChildElement((Element)string, this.schema.getPositionQN(), true);
            if (element4 != null) {
                element3 = this.getChildElement(element4, this.schema.getSizeValQN(), true);
                if (element3 != null) {
                    this.addChildSizeProp((Element)string, this.schema.getPositionQN(), BACKGROUND_POSITION_CSS);
                } else {
                    this.addChildStringProp((Element)string, this.schema.getPositionQN(), BACKGROUND_POSITION_CSS);
                }
            }
            if ((element3 = string.element(this.schema.getRepeatQN())).getStringValue().equals("NO REPEAT")) {
                element3.setText("NO-REPEAT");
            }
            this.addChildStringProp((Element)string, this.schema.getRepeatQN(), BACKGROUND_REPEAT_CSS);
        }
    }

    private void deserializeBoxStyle(Element element) {
        Element element2 = this.getChildElement(element, this.schema.getBoxStyleQN(), true);
        if (null != element2) {
            this.addChildSizeProp(element2, this.schema.getHeightQN(), HEIGHT_KEY);
            this.addChildSizeProp(element2, this.schema.getWidthQN(), WIDTH_KEY);
            this.addChildSizeProp(element2, this.schema.getXQN(), LEFT_KEY);
            this.addChildSizeProp(element2, this.schema.getYQN(), TOP_KEY);
            this.addChildStringProp(element2, this.schema.getPositionQN(), POSITION_KEY);
            this.deserializeMargin(element2);
            this.deserializePadding(element2);
            this.deserializeBorder(element2);
        }
    }

    private void deserializeMargin(Element element) {
        Element element2 = this.getChildElement(element, this.schema.getMarginQN(), true);
        if (null != element2) {
            this.addChildSizeProp(element2, this.schema.getTopQN(), TOP_MARGIN_KEY);
            this.addChildSizeProp(element2, this.schema.getLeftQN(), LEFT_MARGIN_KEY);
            this.addChildSizeProp(element2, this.schema.getRightQN(), RIGHT_MARGIN_KEY);
            this.addChildSizeProp(element2, this.schema.getBottomQN(), BOTTOM_MARGIN_KEY);
        }
    }

    private void deserializePadding(Element element) {
        Element element2 = this.getChildElement(element, this.schema.getPaddingQN(), true);
        if (null != element2) {
            this.addChildSizeProp(element2, this.schema.getTopQN(), PADDING_TOP_KEY);
            this.addChildSizeProp(element2, this.schema.getLeftQN(), PADDING_LEFT_KEY);
            this.addChildSizeProp(element2, this.schema.getRightQN(), PADDING_RIGHT_KEY);
            this.addChildSizeProp(element2, this.schema.getBottomQN(), PADDING_BOTTOM_KEY);
        }
    }

    private void deserializeBorder(Element element) {
        Element element2 = this.getChildElement(element, this.schema.getBorderQN(), true);
        if (null != element2) {
            this.addChildBorderProp(element2, this.schema.getTopQN(), TOP_BORDER_KEY);
            this.addChildBorderProp(element2, this.schema.getLeftQN(), LEFT_BORDER_KEY);
            this.addChildBorderProp(element2, this.schema.getRightQN(), RIGHT_BORDER_KEY);
            this.addChildBorderProp(element2, this.schema.getBottomQN(), BOTTOM_BORDER_KEY);
        }
    }

    public Element toXML() {
        Element element = DocumentHelper.createElement((QName)this.m_QualifiedName);
        Element element2 = element.addElement(this.schema.getStyleNameQN());
        element2.setText(this.name);
        this.generateFontInfo(element);
        this.generateTextStyleInfo(element);
        this.generateBoxInfo(element);
        this.generateColorInfo(element);
        this.generateAlignInfo(element);
        return element;
    }

    private void generateAlignInfo(Element element) {
        this.addPropertyXML(element, HALIGN_KEY);
        this.addPropertyXML(element, VALIGN_KEY);
    }

    private void addPropertyXML(Element element, String string) {
        AStyleProperty aStyleProperty = (AStyleProperty)this.properties.get(string);
        if (aStyleProperty != null) {
            this.addElementIfExists(element, aStyleProperty);
        }
    }

    private void addElementIfExists(Element element, AStyleProperty aStyleProperty) {
        Element element2 = aStyleProperty.generateXMLElement();
        if (element2 != null) {
            element.add(element2);
        }
    }

    private void generateColorInfo(Element element) {
        this.addPropertyXML(element, FGCOLOR_KEY);
        this.addPropertyXML(element, BGCOLOR_KEY);
    }

    private void generateBoxInfo(Element element) {
        Element element2 = element.addElement(this.schema.getBoxStyleQN());
        this.addPropertyXML(element2, HEIGHT_KEY);
        this.addPropertyXML(element2, WIDTH_KEY);
        this.addPropertyXML(element2, LEFT_KEY);
        this.addPropertyXML(element2, TOP_KEY);
        this.addPropertyXML(element2, POSITION_KEY);
        this.generateMarginInfo(element2);
        this.generatePaddingInfo(element2);
        this.generateBorderInfo(element2);
        if (element2.elements().size() <= 0) {
            element2.detach();
        }
    }

    private void generateBorderInfo(Element element) {
        Element element2 = element.addElement(this.schema.getBorderQN());
        this.addPropertyXML(element2, TOP_BORDER_KEY);
        this.addPropertyXML(element2, LEFT_BORDER_KEY);
        this.addPropertyXML(element2, RIGHT_BORDER_KEY);
        this.addPropertyXML(element2, BOTTOM_BORDER_KEY);
        if (element2.elements().size() <= 0) {
            element2.detach();
        }
    }

    private void generatePaddingInfo(Element element) {
        Element element2 = element.addElement(this.schema.getPaddingQN());
        this.addPropertyXML(element2, PADDING_TOP_KEY);
        this.addPropertyXML(element2, PADDING_LEFT_KEY);
        this.addPropertyXML(element2, PADDING_RIGHT_KEY);
        this.addPropertyXML(element2, PADDING_BOTTOM_KEY);
        if (element2.elements().size() <= 0) {
            element2.detach();
        }
    }

    private void generateMarginInfo(Element element) {
        Element element2 = element.addElement(this.schema.getMarginQN());
        this.addPropertyXML(element2, TOP_MARGIN_KEY);
        this.addPropertyXML(element2, LEFT_MARGIN_KEY);
        this.addPropertyXML(element2, RIGHT_MARGIN_KEY);
        this.addPropertyXML(element2, BOTTOM_MARGIN_KEY);
        if (element2.elements().size() <= 0) {
            element2.detach();
        }
    }

    private void generateFontInfo(Element element) {
        this.addPropertyXML(element, FONT_KEY);
    }

    private void generateTextStyleInfo(Element element) {
        this.addPropertyXML(element, TEXTSTYLE_KEY);
    }

    public void parsePPStyle(String string, Element element) throws CCSGeneralException {
        if (element == null) {
            throw new CCSGeneralException("STYLE_PARSE_ERROR", 500);
        }
        this.name = string;
        List list = element.elements();
        Iterator iterator = list.iterator();
        Element element2 = null;
        String string2 = null;
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            string2 = element2.getTextTrim();
            if (null == string2 || string2.length() <= 0) continue;
            this.processPowerPlayProperty(element2, string2);
        }
    }

    private void processPowerPlayProperty(Element element, String string) {
        if (element.getName().equals("textColor")) {
            this.properties.put(FGCOLOR_KEY, new ColorStyleProperty(this.schema.getColorQN(), string, this.namespaceVersion));
        } else if (element.getName().equals("bgColor")) {
            this.properties.put(BGCOLOR_KEY, new ColorStyleProperty(this.schema.getBgColorQN(), string, this.namespaceVersion));
        } else if (element.getName().equals("fontSize")) {
            this.getFontProperty().setSize(string + "pt");
        } else if (element.getName().equals("bold")) {
            if (this.isXMLTrue(string)) {
                this.getFontProperty().setBold(true);
            }
        } else if (element.getName().equals("italic")) {
            if (this.isXMLTrue(string)) {
                this.getFontProperty().setItalics(true);
            }
        } else if (element.getName().equals("underline")) {
            if (this.isXMLTrue(string)) {
                this.getFontProperty().setUnderline(true);
            }
        } else if (element.getName().equals("textAlign")) {
            this.properties.put(HALIGN_KEY, new StringStyleProperty(this.schema.getHalignQN(), string.toUpperCase(), this.namespaceVersion));
        }
    }

    private boolean isXMLTrue(String string) {
        return string.equals("true") || string.equals("1");
    }

    public void parseCSS(String string, String string2) throws CCSGeneralException {
        this.name = string;
        int n = 0;
        int n2 = 0;
        while (n < string2.length()) {
            n2 = string2.indexOf(58, n);
            if (-1 == n2) {
                throw new CCSGeneralException("STYLE_PARSE_ERROR", 500);
            }
            String string3 = string2.substring(n, n2);
            n = n2 + 1;
            String string4 = -1 == (n2 = string2.indexOf(59, n)) ? string2.substring(n) : string2.substring(n, n2);
            this.processCSSProperty(string3, string4);
            if (-1 == n2) break;
            n = n2 + 1;
        }
    }

    private void processCSSProperty(String string, String string2) {
        if (string.equalsIgnoreCase(COLOR_CSS)) {
            this.properties.put(FGCOLOR_KEY, new ColorStyleProperty(this.schema.getColorQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase(BACKGROUND_COLOR_CSS)) {
            this.properties.put(BGCOLOR_KEY, new ColorStyleProperty(this.schema.getBgColorQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase("font-size")) {
            this.getFontProperty().setSize(string2);
        } else if (string.equalsIgnoreCase("font-family")) {
            this.getFontProperty().setFontName(string2);
        } else if (string.equalsIgnoreCase("font-weight")) {
            if (string2.indexOf("bold") != -1) {
                this.getFontProperty().setBold(true);
            } else if (string2.indexOf("normal") != -1) {
                this.getFontProperty().setBold(false);
            }
        } else if (string.equalsIgnoreCase("font-style")) {
            if (string2.indexOf("italic") != -1) {
                this.getFontProperty().setItalics(true);
            } else if (string2.indexOf("normal") != -1) {
                this.getFontProperty().setItalics(false);
            }
        } else if (string.equalsIgnoreCase("text-decoration")) {
            if (string2.indexOf("underline") != -1) {
                this.getFontProperty().setUnderline(true);
            }
            if (string2.indexOf("overline") != -1) {
                this.getFontProperty().setOverline(true);
            }
            if (string2.indexOf("line-through") != -1) {
                this.getFontProperty().setStrikeThru(true);
            }
        } else if (string.equalsIgnoreCase(TEXT_ALIGN_CSS)) {
            this.properties.put(HALIGN_KEY, new StringStyleProperty(this.schema.getHalignQN(), string2.toUpperCase(), this.namespaceVersion));
        } else if (string.equalsIgnoreCase(VERTICAL_ALIGN_CSS)) {
            string2 = this.normalizeVAlign(string2);
            this.properties.put(VALIGN_KEY, new StringStyleProperty(this.schema.getValignQN(), string2.toUpperCase(), this.namespaceVersion));
        } else if (string.equalsIgnoreCase(WIDTH_KEY)) {
            this.properties.put(WIDTH_KEY, new SizeStyleProperty(this.schema.getWidthQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase(HEIGHT_KEY)) {
            this.properties.put(HEIGHT_KEY, new SizeStyleProperty(this.schema.getHeightQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase("margin")) {
            this.parseMargin(string2);
        } else if (string.equalsIgnoreCase(MARGIN_LEFT_CSS)) {
            this.properties.put(LEFT_MARGIN_KEY, new SizeStyleProperty(this.schema.getLeftQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase(MARGIN_RIGHT_CSS)) {
            this.properties.put(RIGHT_MARGIN_KEY, new SizeStyleProperty(this.schema.getRightQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase(MARGIN_TOP_CSS)) {
            this.properties.put(TOP_MARGIN_KEY, new SizeStyleProperty(this.schema.getTopQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase(MARGIN_BOTTOM_CSS)) {
            this.properties.put(BOTTOM_MARGIN_KEY, new SizeStyleProperty(this.schema.getBottomQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase("padding")) {
            this.parsePadding(string2);
        } else if (string.equalsIgnoreCase(PADDING_LEFT_CSS)) {
            this.properties.put(PADDING_LEFT_KEY, new SizeStyleProperty(this.schema.getLeftQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase(PADDING_RIGHT_CSS)) {
            this.properties.put(PADDING_RIGHT_KEY, new SizeStyleProperty(this.schema.getRightQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase(PADDING_TOP_CSS)) {
            this.properties.put(PADDING_TOP_KEY, new SizeStyleProperty(this.schema.getTopQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase(PADDING_BOTTOM_CSS)) {
            this.properties.put(PADDING_BOTTOM_KEY, new SizeStyleProperty(this.schema.getBottomQN(), string2, this.namespaceVersion));
        } else if (string.equalsIgnoreCase("border-top-width")) {
            BorderStyleProperty borderStyleProperty = this.getTopBorder();
            borderStyleProperty.setLineWidth(string2);
        } else if (string.equalsIgnoreCase("border-left-width")) {
            BorderStyleProperty borderStyleProperty = this.getLeftBorder();
            borderStyleProperty.setLineWidth(string2);
        } else if (string.equalsIgnoreCase("border-right-width")) {
            BorderStyleProperty borderStyleProperty = this.getRightBorder();
            borderStyleProperty.setLineWidth(string2);
        } else if (string.equalsIgnoreCase("border-bottom-width")) {
            BorderStyleProperty borderStyleProperty = this.getBottomBorder();
            borderStyleProperty.setLineWidth(string2);
        } else if (string.equalsIgnoreCase("border-top-color")) {
            BorderStyleProperty borderStyleProperty = this.getTopBorder();
            borderStyleProperty.setLineColor(string2);
        } else if (string.equalsIgnoreCase("border-left-color")) {
            BorderStyleProperty borderStyleProperty = this.getLeftBorder();
            borderStyleProperty.setLineColor(string2);
        } else if (string.equalsIgnoreCase("border-right-color")) {
            BorderStyleProperty borderStyleProperty = this.getRightBorder();
            borderStyleProperty.setLineColor(string2);
        } else if (string.equalsIgnoreCase("border-bottom-color")) {
            BorderStyleProperty borderStyleProperty = this.getBottomBorder();
            borderStyleProperty.setLineColor(string2);
        } else if (string.equalsIgnoreCase("border-top-style")) {
            BorderStyleProperty borderStyleProperty = this.getTopBorder();
            borderStyleProperty.setLineStyle(string2);
        } else if (string.equalsIgnoreCase("border-left-style")) {
            BorderStyleProperty borderStyleProperty = this.getLeftBorder();
            borderStyleProperty.setLineStyle(string2);
        } else if (string.equalsIgnoreCase("border-right-style")) {
            BorderStyleProperty borderStyleProperty = this.getRightBorder();
            borderStyleProperty.setLineStyle(string2);
        } else if (string.equalsIgnoreCase("border-bottom-style")) {
            BorderStyleProperty borderStyleProperty = this.getBottomBorder();
            borderStyleProperty.setLineStyle(string2);
        } else if (string.equalsIgnoreCase(BORDER_TOP_CSS)) {
            this.parseBorder(this.getTopBorder(), string2);
        } else if (string.equalsIgnoreCase(BORDER_RIGHT_CSS)) {
            this.parseBorder(this.getRightBorder(), string2);
        } else if (string.equalsIgnoreCase(BORDER_LEFT_CSS)) {
            this.parseBorder(this.getLeftBorder(), string2);
        } else if (string.equalsIgnoreCase(BORDER_BOTTOM_CSS)) {
            this.parseBorder(this.getBottomBorder(), string2);
        } else if (string.equalsIgnoreCase("border")) {
            this.parseBorder(this.getTopBorder(), string2);
            this.parseBorder(this.getLeftBorder(), string2);
            this.parseBorder(this.getRightBorder(), string2);
            this.parseBorder(this.getBottomBorder(), string2);
        } else if (string.equalsIgnoreCase(WHITESPACE_KEY_CSS) && string2.indexOf("nowrap") != -1) {
            this.getTextStyleProperty().setWrapping(false);
        }
    }

    private FontStyleProperty getFontProperty() {
        FontStyleProperty fontStyleProperty = (FontStyleProperty)this.properties.get(FONT_KEY);
        if (null == fontStyleProperty) {
            fontStyleProperty = new FontStyleProperty(this.schema.getFontQN(), this.namespaceVersion);
            this.properties.put(FONT_KEY, fontStyleProperty);
        }
        return fontStyleProperty;
    }

    private TextStyleProperty getTextStyleProperty() {
        TextStyleProperty textStyleProperty = (TextStyleProperty)this.properties.get(TEXTSTYLE_KEY);
        if (null == textStyleProperty) {
            textStyleProperty = new TextStyleProperty(this.schema.getTextStyleQN(), this.namespaceVersion);
            this.properties.put(TEXTSTYLE_KEY, textStyleProperty);
        }
        return textStyleProperty;
    }

    private BorderStyleProperty getTopBorder() {
        return this.getBorderProperty(TOP_BORDER_KEY, this.schema.getTopQN());
    }

    private BorderStyleProperty getLeftBorder() {
        return this.getBorderProperty(LEFT_BORDER_KEY, this.schema.getLeftQN());
    }

    private BorderStyleProperty getRightBorder() {
        return this.getBorderProperty(RIGHT_BORDER_KEY, this.schema.getRightQN());
    }

    private BorderStyleProperty getBottomBorder() {
        return this.getBorderProperty(BOTTOM_BORDER_KEY, this.schema.getBottomQN());
    }

    private BorderStyleProperty getBorderProperty(String string, QName qName) {
        BorderStyleProperty borderStyleProperty = (BorderStyleProperty)this.properties.get(string);
        if (null == borderStyleProperty) {
            borderStyleProperty = new BorderStyleProperty(qName, this.namespaceVersion);
            this.properties.put(string, borderStyleProperty);
        }
        return borderStyleProperty;
    }

    protected void parseBorder(BorderStyleProperty borderStyleProperty, String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            borderStyleProperty.setLineWidth(stringTokenizer.nextToken());
            borderStyleProperty.setLineStyle(stringTokenizer.nextToken().toUpperCase());
            borderStyleProperty.setLineColor(stringTokenizer.nextToken());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void parsePadding(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.properties.put(PADDING_TOP_KEY, new SizeStyleProperty(this.schema.getTopQN(), stringTokenizer.nextToken(), this.namespaceVersion));
            this.properties.put(PADDING_RIGHT_KEY, new SizeStyleProperty(this.schema.getRightQN(), stringTokenizer.nextToken(), this.namespaceVersion));
            this.properties.put(PADDING_BOTTOM_KEY, new SizeStyleProperty(this.schema.getBottomQN(), stringTokenizer.nextToken(), this.namespaceVersion));
            this.properties.put(PADDING_LEFT_KEY, new SizeStyleProperty(this.schema.getLeftQN(), stringTokenizer.nextToken(), this.namespaceVersion));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void parseMargin(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.properties.put(TOP_MARGIN_KEY, new SizeStyleProperty(this.schema.getTopQN(), stringTokenizer.nextToken(), this.namespaceVersion));
            this.properties.put(LEFT_MARGIN_KEY, new SizeStyleProperty(this.schema.getLeftQN(), stringTokenizer.nextToken(), this.namespaceVersion));
            this.properties.put(RIGHT_MARGIN_KEY, new SizeStyleProperty(this.schema.getRightQN(), stringTokenizer.nextToken(), this.namespaceVersion));
            this.properties.put(BOTTOM_MARGIN_KEY, new SizeStyleProperty(this.schema.getBottomQN(), stringTokenizer.nextToken(), this.namespaceVersion));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Element generateXMLElement() {
        return this.toXML();
    }

    public String generateCSS(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeCSSClassOpen(bl, stringBuffer);
        FontStyleProperty fontStyleProperty = this.getFontProp(FONT_KEY);
        if (null != fontStyleProperty) {
            stringBuffer.append(fontStyleProperty.generateCSS());
        }
        this.writeTextStyleProp(stringBuffer, TEXTSTYLE_KEY, WHITESPACE_KEY_CSS);
        StringStyleProperty stringStyleProperty = this.getStringProp(HALIGN_KEY);
        if (stringStyleProperty == null) {
            this.properties.put(HALIGN_KEY, new StringStyleProperty(this.schema.getHalignQN(), "LEFT", this.namespaceVersion));
        }
        this.writeSizeProp(stringBuffer, HEIGHT_KEY, HEIGHT_KEY);
        this.writeSizeProp(stringBuffer, WIDTH_KEY, WIDTH_KEY);
        this.writeSizeProp(stringBuffer, LEFT_KEY, LEFT_KEY);
        this.writeSizeProp(stringBuffer, TOP_KEY, TOP_KEY);
        this.writeStringProp(stringBuffer, POSITION_KEY, POSITION_KEY);
        this.writeSizeProp(stringBuffer, TOP_MARGIN_KEY, MARGIN_TOP_CSS);
        SizeStyleProperty sizeStyleProperty = this.getSizeProp(LEFT_MARGIN_KEY);
        SizeStyleProperty sizeStyleProperty2 = this.getSizeProp(RIGHT_MARGIN_KEY);
        StringStyleProperty stringStyleProperty2 = this.getStringProp(DISPLAY_KEY);
        if (stringStyleProperty2 != null && stringStyleProperty2.getValue().equalsIgnoreCase("none")) {
            this.writeStringProp(stringBuffer, DISPLAY_KEY, DISPLAY_KEY);
        } else if (null == sizeStyleProperty && null == sizeStyleProperty2 && null != stringStyleProperty) {
            if (stringStyleProperty.getValue().equalsIgnoreCase("CENTER") && stringStyleProperty2 != null && stringStyleProperty2.getValue().equalsIgnoreCase("TABLE")) {
                stringBuffer.append(MARGIN_LEFT_CSS);
                stringBuffer.append(CSS_TYPE_SEP);
                stringBuffer.append("auto");
                stringBuffer.append(CSS_TYPE_CLOSE);
                stringBuffer.append(MARGIN_RIGHT_CSS);
                stringBuffer.append(CSS_TYPE_SEP);
                stringBuffer.append("auto");
                stringBuffer.append(CSS_TYPE_CLOSE);
            }
        } else {
            this.writeSizeProp(stringBuffer, LEFT_MARGIN_KEY, MARGIN_LEFT_CSS);
            this.writeSizeProp(stringBuffer, RIGHT_MARGIN_KEY, MARGIN_RIGHT_CSS);
        }
        this.writeSizeProp(stringBuffer, BOTTOM_MARGIN_KEY, MARGIN_BOTTOM_CSS);
        this.writeSizeProp(stringBuffer, PADDING_TOP_KEY, PADDING_TOP_CSS);
        this.writeSizeProp(stringBuffer, PADDING_LEFT_KEY, PADDING_LEFT_CSS);
        this.writeSizeProp(stringBuffer, PADDING_RIGHT_KEY, PADDING_RIGHT_CSS);
        this.writeSizeProp(stringBuffer, PADDING_BOTTOM_KEY, PADDING_BOTTOM_CSS);
        this.writeBorderProp(stringBuffer, TOP_BORDER_KEY, BORDER_TOP_CSS);
        this.writeBorderProp(stringBuffer, LEFT_BORDER_KEY, BORDER_LEFT_CSS);
        this.writeBorderProp(stringBuffer, RIGHT_BORDER_KEY, BORDER_RIGHT_CSS);
        this.writeBorderProp(stringBuffer, BOTTOM_BORDER_KEY, BORDER_BOTTOM_CSS);
        this.writeColorProp(stringBuffer, FGCOLOR_KEY, COLOR_CSS);
        this.writeColorProp(stringBuffer, BGCOLOR_KEY, BACKGROUND_COLOR_CSS);
        this.writeStringProp(stringBuffer, HALIGN_KEY, TEXT_ALIGN_CSS);
        this.writeStringProp(stringBuffer, VALIGN_KEY, VERTICAL_ALIGN_CSS);
        this.writeStringProp(stringBuffer, "background-image", "background-image");
        this.writeBackgroundPositionProp(stringBuffer);
        this.writeStringProp(stringBuffer, BACKGROUND_REPEAT_CSS, BACKGROUND_REPEAT_CSS);
        this.writeCSSClassClose(bl, stringBuffer);
        return stringBuffer.toString();
    }

    private void writeCSSClassClose(boolean bl, StringBuffer stringBuffer) {
        if (!bl) {
            stringBuffer.append("}\n");
        }
    }

    private void writeCSSClassOpen(boolean bl, StringBuffer stringBuffer) {
        if (!bl) {
            stringBuffer.append(".");
            stringBuffer.append(this.name);
            stringBuffer.append(" {");
        }
    }

    private void writeSizeProp(StringBuffer stringBuffer, String string, String string2) {
        SizeStyleProperty sizeStyleProperty = this.getSizeProp(string);
        if (null != sizeStyleProperty) {
            stringBuffer.append(string2);
            stringBuffer.append(CSS_TYPE_SEP);
            stringBuffer.append(sizeStyleProperty.generateCSSValue());
            stringBuffer.append(CSS_TYPE_CLOSE);
        }
    }

    private void writeBorderProp(StringBuffer stringBuffer, String string, String string2) {
        BorderStyleProperty borderStyleProperty = this.getBorderProp(string);
        if (null != borderStyleProperty) {
            stringBuffer.append(borderStyleProperty.generateCSS(string2));
        }
    }

    private void writeColorProp(StringBuffer stringBuffer, String string, String string2) {
        ColorStyleProperty colorStyleProperty = this.getColorProp(string);
        if (null != colorStyleProperty) {
            stringBuffer.append(string2);
            stringBuffer.append(CSS_TYPE_SEP);
            stringBuffer.append(colorStyleProperty.generateCSSValue());
            stringBuffer.append(CSS_TYPE_CLOSE);
        }
    }

    private void writeStringProp(StringBuffer stringBuffer, String string, String string2) {
        StringStyleProperty stringStyleProperty = this.getStringProp(string);
        if (null != stringStyleProperty) {
            stringBuffer.append(string2);
            stringBuffer.append(CSS_TYPE_SEP);
            stringBuffer.append(stringStyleProperty.getValue().toLowerCase());
            stringBuffer.append(CSS_TYPE_CLOSE);
        }
    }

    private void writeTextStyleProp(StringBuffer stringBuffer, String string, String string2) {
        TextStyleProperty textStyleProperty = this.getTextStyleProp(string);
        if (null != textStyleProperty) {
            stringBuffer.append(textStyleProperty.generateCSS(string2));
        }
    }

    private String normalizeVAlign(String string) {
        if (string.equals("text-top") || string.equals("super")) {
            string = TOP_KEY;
        } else if (string.equals("text-bottom") || string.equals("sub")) {
            string = "bottom";
        }
        return string;
    }

    private void writeBackgroundPositionProp(StringBuffer stringBuffer) {
        if (this.isStringStyleProp(BACKGROUND_POSITION_CSS)) {
            this.writeStringProp(stringBuffer, BACKGROUND_POSITION_CSS, BACKGROUND_POSITION_CSS);
        } else {
            this.writeSizeProp(stringBuffer, BACKGROUND_POSITION_CSS, BACKGROUND_POSITION_CSS);
        }
    }
}

