/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content;

import com.cognos.ccs.content.StyleGroup;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.Collection;
import java.util.HashMap;
import org.dom4j.Element;

public class StyleParser {
    protected HashMap styles = new HashMap();
    protected int styleCount = 0;
    protected final Constants.NamespaceVersion namespaceVersion;

    public StyleParser(Constants.NamespaceVersion namespaceVersion) {
        this.namespaceVersion = namespaceVersion;
    }

    protected void storeStyle(String string, StyleGroup styleGroup) {
        this.styles.put(string, styleGroup);
    }

    protected StyleGroup getStyle(String string) {
        return (StyleGroup)this.styles.get(string);
    }

    protected String getNextName() {
        ++this.styleCount;
        return "stl" + this.styleCount;
    }

    public void parseNamedCSSStyle(String string, String string2) throws CCSGeneralException {
        StyleGroup styleGroup = this.getStyle(string);
        if (styleGroup != null) {
            return;
        }
        styleGroup = new StyleGroup(this.namespaceVersion);
        styleGroup.parseCSS(string2, string);
        this.storeStyle(string, styleGroup);
    }

    public String parseSingleCSSStyle(String string) throws CCSGeneralException {
        StyleGroup styleGroup = this.getStyle(string);
        if (styleGroup != null) {
            return styleGroup.getName();
        }
        styleGroup = new StyleGroup(this.namespaceVersion);
        String string2 = this.getNextName();
        styleGroup.parseCSS(string2, string);
        this.storeStyle(string, styleGroup);
        return string2;
    }

    public String parsePPStyle(Element element) throws CCSGeneralException {
        StyleGroup styleGroup = this.getStyle(element.asXML());
        if (styleGroup != null) {
            return styleGroup.getName();
        }
        styleGroup = new StyleGroup(this.namespaceVersion);
        String string = this.getNextName();
        styleGroup.parsePPStyle(string, element);
        this.storeStyle(element.asXML(), styleGroup);
        return string;
    }

    public Collection getStyles() {
        return this.styles.values();
    }
}

