/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content.style;

import com.cognos.ccs.content.style.AComplexProperty;
import com.cognos.ccs.content.style.AStyleProperty;
import com.cognos.ccs.content.style.ColorStyleProperty;
import com.cognos.ccs.content.style.SizeStyleProperty;
import com.cognos.ccs.content.style.StringStyleProperty;
import com.ibm.cognos.ccs.internal.utility.Constants;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class BorderStyleProperty
extends AComplexProperty {
    private static final String LINEWIDTH_KEY = "linewidth";
    private static final String LINESTYLE_KEY = "linestyle";
    private static final String LINECOLOR_KEY = "linecolor";

    public BorderStyleProperty(QName qName, Constants.NamespaceVersion namespaceVersion) {
        super(qName, namespaceVersion);
    }

    public BorderStyleProperty(Element element, Constants.NamespaceVersion namespaceVersion) {
        super(element.getQName(), namespaceVersion);
        this.addChildColorProp(element, this.schema.getLineColorQN(), LINECOLOR_KEY);
        this.addChildStringProp(element, this.schema.getLineStyleQN(), LINESTYLE_KEY);
        this.addChildSizeProp(element, this.schema.getWidthQN(), LINEWIDTH_KEY);
    }

    @Override
    public Element generateXMLElement() {
        Element element = DocumentHelper.createElement((QName)this.m_QualifiedName);
        this.addPropertyXML(LINECOLOR_KEY, element);
        this.addPropertyXML(LINESTYLE_KEY, element);
        this.addPropertyXML(LINEWIDTH_KEY, element);
        return element;
    }

    public String generateCSS(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ColorStyleProperty colorStyleProperty = (ColorStyleProperty)this.properties.get(LINECOLOR_KEY);
        SizeStyleProperty sizeStyleProperty = (SizeStyleProperty)this.properties.get(LINEWIDTH_KEY);
        StringStyleProperty stringStyleProperty = (StringStyleProperty)this.properties.get(LINESTYLE_KEY);
        if (colorStyleProperty != null && sizeStyleProperty != null && stringStyleProperty != null) {
            this.generateCompleteBorder(string, stringBuffer, colorStyleProperty, sizeStyleProperty, stringStyleProperty);
        } else {
            this.generateLineWidth(string, stringBuffer, sizeStyleProperty);
            this.generateLineColor(string, stringBuffer, colorStyleProperty);
            this.generateLineStyle(string, stringBuffer, stringStyleProperty);
        }
        return stringBuffer.toString();
    }

    private void generateLineStyle(String string, StringBuffer stringBuffer, StringStyleProperty stringStyleProperty) {
        if (stringStyleProperty != null) {
            stringBuffer.append(string);
            stringBuffer.append("-style:");
            stringBuffer.append(stringStyleProperty.getValue().toLowerCase());
            stringBuffer.append("; ");
        } else {
            stringBuffer.append(string);
            stringBuffer.append("-style:none; ");
        }
    }

    private void generateLineColor(String string, StringBuffer stringBuffer, ColorStyleProperty colorStyleProperty) {
        if (colorStyleProperty != null) {
            stringBuffer.append(string);
            stringBuffer.append("-color:");
            stringBuffer.append(colorStyleProperty.generateCSSValue());
            stringBuffer.append("; ");
        }
    }

    private void generateLineWidth(String string, StringBuffer stringBuffer, SizeStyleProperty sizeStyleProperty) {
        if (sizeStyleProperty != null) {
            stringBuffer.append(string);
            stringBuffer.append("-width:");
            stringBuffer.append(sizeStyleProperty.generateCSSValue());
            stringBuffer.append("; ");
        }
    }

    private void generateCompleteBorder(String string, StringBuffer stringBuffer, ColorStyleProperty colorStyleProperty, SizeStyleProperty sizeStyleProperty, StringStyleProperty stringStyleProperty) {
        stringBuffer.append(string);
        stringBuffer.append(":");
        stringBuffer.append(sizeStyleProperty.generateCSSValue());
        stringBuffer.append(" ");
        stringBuffer.append(stringStyleProperty.getValue().toLowerCase());
        stringBuffer.append(" ");
        stringBuffer.append(colorStyleProperty.generateCSSValue());
        stringBuffer.append("; ");
    }

    private void addPropertyXML(String string, Element element) {
        Element element2;
        AStyleProperty aStyleProperty = (AStyleProperty)this.properties.get(string);
        if (aStyleProperty != null && (element2 = aStyleProperty.generateXMLElement()) != null) {
            element.add(element2);
        }
    }

    public void setLineStyle(String string) {
        this.properties.put(LINESTYLE_KEY, new StringStyleProperty(this.schema.getLineStyleQN(), string.toUpperCase(), this.namespaceVersion));
    }

    public void setLineWidth(String string) {
        this.properties.put(LINEWIDTH_KEY, new SizeStyleProperty(this.schema.getWidthQN(), string, this.namespaceVersion));
    }

    public void setLineColor(String string) {
        this.properties.put(LINECOLOR_KEY, new ColorStyleProperty(this.schema.getLineColorQN(), string, this.namespaceVersion));
    }
}

