/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content.style;

import com.cognos.ccs.content.style.AStyleProperty;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.awt.Color;
import java.util.HashMap;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class ColorStyleProperty
extends AStyleProperty {
    private static final HashMap<String, Color> colorNameMap = new HashMap();
    Color m_Color;

    public ColorStyleProperty(QName qName, String string, Constants.NamespaceVersion namespaceVersion) {
        super(qName, namespaceVersion);
        this.m_Color = this.parseColor(string);
    }

    public ColorStyleProperty(Element element, Constants.NamespaceVersion namespaceVersion) {
        super(element.getQName(), namespaceVersion);
        int n = this.getColorElement(element, this.schema.getRedQN());
        int n2 = this.getColorElement(element, this.schema.getBlueQN());
        int n3 = this.getColorElement(element, this.schema.getGreenQN());
        this.m_Color = new Color(n, n3, n2);
    }

    private int getColorElement(Element element, QName qName) {
        Element element2 = this.getChildElement(element, qName);
        return Integer.parseInt(element2.getText());
    }

    public String generateCSSValue() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#");
        this.convertColor(stringBuffer, this.m_Color.getRed());
        this.convertColor(stringBuffer, this.m_Color.getGreen());
        this.convertColor(stringBuffer, this.m_Color.getBlue());
        return stringBuffer.toString();
    }

    private void convertColor(StringBuffer stringBuffer, int n) {
        if (n < 16) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toHexString(n).toUpperCase());
    }

    public Element generateXMLElementNoNS() {
        if (this.m_Color == null) {
            return null;
        }
        Element element = DocumentHelper.createElement((QName)this.m_QualifiedName);
        element.add(this.generateValueElement(new QName("Red"), this.m_Color.getRed()));
        element.add(this.generateValueElement(new QName("Green"), this.m_Color.getGreen()));
        element.add(this.generateValueElement(new QName("Blue"), this.m_Color.getBlue()));
        return element;
    }

    @Override
    public Element generateXMLElement() {
        if (this.m_Color == null) {
            return null;
        }
        Element element = DocumentHelper.createElement((QName)this.m_QualifiedName);
        element.add(this.generateValueElement(this.schema.getRedQN(), this.m_Color.getRed()));
        element.add(this.generateValueElement(this.schema.getGreenQN(), this.m_Color.getGreen()));
        element.add(this.generateValueElement(this.schema.getBlueQN(), this.m_Color.getBlue()));
        return element;
    }

    protected Color parseColor(String string) {
        if (string.startsWith("rgb")) {
            int n = string.indexOf(40);
            int n2 = string.indexOf(41);
            string = string.substring(n + 1, n2);
            String[] stringArray = string.split(",");
            try {
                int n3 = Integer.parseInt(stringArray[0]);
                int n4 = Integer.parseInt(stringArray[1]);
                int n5 = Integer.parseInt(stringArray[2]);
                return new Color(n3, n4, n5);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("transparent")) {
            return new Color(0, 0, 0, 0);
        }
        String string2 = string.toLowerCase();
        Color color = colorNameMap.get(string2);
        if (null != color) {
            return color;
        }
        try {
            int n6 = Integer.parseInt(string, 16);
            return new Color(n6);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Color getColor() {
        return this.m_Color;
    }

    static {
        colorNameMap.put("aliceblue", new Color(240, 248, 255));
        colorNameMap.put("antiquewhite", new Color(250, 235, 215));
        colorNameMap.put("aqua", new Color(0, 255, 255));
        colorNameMap.put("aquamarine", new Color(127, 255, 212));
        colorNameMap.put("azure", new Color(240, 255, 255));
        colorNameMap.put("beige", new Color(245, 245, 220));
        colorNameMap.put("bisque", new Color(255, 228, 196));
        colorNameMap.put("black", new Color(0, 0, 0));
        colorNameMap.put("blanchedalmond", new Color(255, 235, 205));
        colorNameMap.put("blue", new Color(0, 0, 255));
        colorNameMap.put("blueviolet", new Color(138, 43, 226));
        colorNameMap.put("brown", new Color(165, 42, 42));
        colorNameMap.put("burlywood", new Color(222, 184, 135));
        colorNameMap.put("cadetblue", new Color(95, 158, 160));
        colorNameMap.put("chartreuse", new Color(127, 255, 0));
        colorNameMap.put("chocolate", new Color(210, 105, 30));
        colorNameMap.put("coral", new Color(255, 127, 80));
        colorNameMap.put("cornflowerblue", new Color(100, 149, 237));
        colorNameMap.put("cornsilk", new Color(255, 248, 220));
        colorNameMap.put("crimson", new Color(220, 20, 60));
        colorNameMap.put("cyan", new Color(0, 255, 255));
        colorNameMap.put("darkblue", new Color(0, 0, 139));
        colorNameMap.put("darkcyan", new Color(0, 139, 139));
        colorNameMap.put("darkgoldenrod", new Color(184, 134, 11));
        colorNameMap.put("darkgray", new Color(169, 169, 169));
        colorNameMap.put("darkgrey", new Color(169, 169, 169));
        colorNameMap.put("darkgreen", new Color(0, 100, 0));
        colorNameMap.put("darkkhaki", new Color(189, 183, 107));
        colorNameMap.put("darkmagenta", new Color(139, 0, 139));
        colorNameMap.put("darkolivegreen", new Color(85, 107, 47));
        colorNameMap.put("darkorange", new Color(255, 140, 0));
        colorNameMap.put("darkorchid", new Color(153, 50, 204));
        colorNameMap.put("darkred", new Color(139, 0, 0));
        colorNameMap.put("darksalmon", new Color(233, 150, 122));
        colorNameMap.put("darkseagreen", new Color(143, 188, 143));
        colorNameMap.put("darkslateblue", new Color(72, 61, 139));
        colorNameMap.put("darkslategray", new Color(47, 79, 79));
        colorNameMap.put("darkslategrey", new Color(47, 79, 79));
        colorNameMap.put("darkturquoise", new Color(0, 206, 209));
        colorNameMap.put("darkviolet", new Color(148, 0, 211));
        colorNameMap.put("deeppink", new Color(255, 20, 147));
        colorNameMap.put("deepskyblue", new Color(0, 191, 255));
        colorNameMap.put("dimgray", new Color(105, 105, 105));
        colorNameMap.put("dimgrey", new Color(105, 105, 105));
        colorNameMap.put("dodgerblue", new Color(30, 144, 255));
        colorNameMap.put("firebrick", new Color(178, 34, 34));
        colorNameMap.put("floralwhite", new Color(255, 250, 240));
        colorNameMap.put("forestgreen", new Color(34, 139, 34));
        colorNameMap.put("fuchsia", new Color(255, 0, 255));
        colorNameMap.put("gainsboro", new Color(220, 220, 220));
        colorNameMap.put("ghostwhite", new Color(248, 248, 255));
        colorNameMap.put("gold", new Color(255, 215, 0));
        colorNameMap.put("goldenrod", new Color(218, 165, 32));
        colorNameMap.put("gray", new Color(128, 128, 128));
        colorNameMap.put("grey", new Color(128, 128, 128));
        colorNameMap.put("green", new Color(0, 128, 0));
        colorNameMap.put("greenyellow", new Color(173, 255, 47));
        colorNameMap.put("honeydew", new Color(240, 255, 240));
        colorNameMap.put("hotpink", new Color(255, 105, 180));
        colorNameMap.put("indianred", new Color(205, 92, 92));
        colorNameMap.put("indigo", new Color(75, 0, 130));
        colorNameMap.put("ivory", new Color(255, 255, 240));
        colorNameMap.put("khaki", new Color(240, 230, 140));
        colorNameMap.put("lavender", new Color(230, 230, 250));
        colorNameMap.put("lavenderblush", new Color(255, 240, 245));
        colorNameMap.put("lawngreen", new Color(124, 252, 0));
        colorNameMap.put("lemonchiffon", new Color(255, 250, 205));
        colorNameMap.put("lightblue", new Color(173, 216, 230));
        colorNameMap.put("lightcoral", new Color(240, 128, 128));
        colorNameMap.put("lightcyan", new Color(224, 255, 255));
        colorNameMap.put("lightgoldenrodyellow", new Color(250, 250, 210));
        colorNameMap.put("lightgray", new Color(211, 211, 211));
        colorNameMap.put("lightgrey", new Color(211, 211, 211));
        colorNameMap.put("lightgreen", new Color(144, 238, 144));
        colorNameMap.put("lightpink", new Color(255, 182, 193));
        colorNameMap.put("lightsalmon", new Color(255, 160, 122));
        colorNameMap.put("lightseagreen", new Color(32, 178, 170));
        colorNameMap.put("lightskyblue", new Color(135, 206, 250));
        colorNameMap.put("lightslategray", new Color(119, 136, 153));
        colorNameMap.put("lightslategrey", new Color(119, 136, 153));
        colorNameMap.put("lightsteelblue", new Color(176, 196, 222));
        colorNameMap.put("lightyellow", new Color(255, 255, 224));
        colorNameMap.put("lime", new Color(0, 255, 0));
        colorNameMap.put("limegreen", new Color(50, 205, 50));
        colorNameMap.put("linen", new Color(250, 240, 230));
        colorNameMap.put("magenta", new Color(255, 0, 255));
        colorNameMap.put("maroon", new Color(128, 0, 0));
        colorNameMap.put("mediumaquamarine", new Color(102, 205, 170));
        colorNameMap.put("mediumblue", new Color(0, 0, 205));
        colorNameMap.put("mediumorchid", new Color(186, 85, 211));
        colorNameMap.put("mediumpurple", new Color(147, 112, 219));
        colorNameMap.put("mediumseagreen", new Color(60, 179, 113));
        colorNameMap.put("mediumslateblue", new Color(123, 104, 238));
        colorNameMap.put("mediumspringgreen", new Color(0, 250, 154));
        colorNameMap.put("mediumturquoise", new Color(72, 209, 204));
        colorNameMap.put("mediumvioletred", new Color(199, 21, 133));
        colorNameMap.put("midnightblue", new Color(25, 25, 112));
        colorNameMap.put("mintcream", new Color(245, 255, 250));
        colorNameMap.put("mistyrose", new Color(255, 228, 225));
        colorNameMap.put("moccasin", new Color(255, 228, 181));
        colorNameMap.put("navajowhite", new Color(255, 222, 173));
        colorNameMap.put("navy", new Color(0, 0, 128));
        colorNameMap.put("oldlace", new Color(253, 245, 230));
        colorNameMap.put("olive", new Color(128, 128, 0));
        colorNameMap.put("olivedrab", new Color(107, 142, 35));
        colorNameMap.put("orange", new Color(255, 165, 0));
        colorNameMap.put("orangered", new Color(255, 69, 0));
        colorNameMap.put("orchid", new Color(218, 112, 214));
        colorNameMap.put("palegoldenrod", new Color(238, 232, 170));
        colorNameMap.put("palegreen", new Color(152, 251, 152));
        colorNameMap.put("paleturquoise", new Color(175, 238, 238));
        colorNameMap.put("palevioletred", new Color(219, 112, 147));
        colorNameMap.put("papayawhip", new Color(255, 239, 213));
        colorNameMap.put("peachpuff", new Color(255, 218, 185));
        colorNameMap.put("peru", new Color(205, 133, 63));
        colorNameMap.put("pink", new Color(255, 192, 203));
        colorNameMap.put("plum", new Color(221, 160, 221));
        colorNameMap.put("powderblue", new Color(176, 224, 230));
        colorNameMap.put("purple", new Color(128, 0, 128));
        colorNameMap.put("red", new Color(255, 0, 0));
        colorNameMap.put("rosybrown", new Color(188, 143, 143));
        colorNameMap.put("royalblue", new Color(65, 105, 225));
        colorNameMap.put("saddlebrown", new Color(139, 69, 19));
        colorNameMap.put("salmon", new Color(250, 128, 114));
        colorNameMap.put("sandybrown", new Color(244, 164, 96));
        colorNameMap.put("seagreen", new Color(46, 139, 87));
        colorNameMap.put("seashell", new Color(255, 245, 238));
        colorNameMap.put("sienna", new Color(160, 82, 45));
        colorNameMap.put("silver", new Color(192, 192, 192));
        colorNameMap.put("skyblue", new Color(135, 206, 235));
        colorNameMap.put("slateblue", new Color(106, 90, 205));
        colorNameMap.put("slategray", new Color(112, 128, 144));
        colorNameMap.put("slategrey", new Color(112, 128, 144));
        colorNameMap.put("snow", new Color(255, 250, 250));
        colorNameMap.put("springgreen", new Color(0, 255, 127));
        colorNameMap.put("steelblue", new Color(70, 130, 180));
        colorNameMap.put("tan", new Color(210, 180, 140));
        colorNameMap.put("teal", new Color(0, 128, 128));
        colorNameMap.put("thistle", new Color(216, 191, 216));
        colorNameMap.put("tomato", new Color(255, 99, 71));
        colorNameMap.put("turquoise", new Color(64, 224, 208));
        colorNameMap.put("violet", new Color(238, 130, 238));
        colorNameMap.put("wheat", new Color(245, 222, 179));
        colorNameMap.put("white", new Color(255, 255, 255));
        colorNameMap.put("whitesmoke", new Color(245, 245, 245));
        colorNameMap.put("yellow", new Color(255, 255, 0));
        colorNameMap.put("yellowgreen", new Color(154, 205, 50));
    }
}

