/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content.style;

import com.cognos.ccs.content.style.AComplexProperty;
import com.cognos.ccs.content.style.AStyleProperty;
import com.cognos.ccs.content.style.BooleanStyleProperty;
import com.cognos.ccs.content.style.SizeStyleProperty;
import com.cognos.ccs.content.style.StringStyleProperty;
import com.ibm.cognos.ccs.internal.utility.Constants;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class FontStyleProperty
extends AComplexProperty {
    private static final String STRIKETHRU_KEY = "strikethru";
    private static final String UNDERLINE_KEY = "underline";
    private static final String OVERLINE_KEY = "overline";
    private static final String ITALICS_KEY = "italics";
    private static final String BOLD_KEY = "bold";
    private static final String SIZE_KEY = "size";
    private static final String NAME_KEY = "name";

    public FontStyleProperty(QName qName, Constants.NamespaceVersion namespaceVersion) {
        super(qName, namespaceVersion);
    }

    public FontStyleProperty(Element element, Constants.NamespaceVersion namespaceVersion) {
        super(element.getQName(), namespaceVersion);
        this.addChildStringProp(element, this.schema.getFontfamilyQN(), NAME_KEY);
        this.addChildSizeProp(element, this.schema.getFontSizeQN(), SIZE_KEY);
        Element element2 = element.element(this.schema.getFontStyleQN());
        if (element2 != null) {
            this.addChildBooleanProp(element2, this.schema.getFontBoldQN(), BOLD_KEY);
            this.addChildBooleanProp(element2, this.schema.getFontItalicsQN(), ITALICS_KEY);
            this.addChildBooleanProp(element2, this.schema.getFontOverlineQN(), OVERLINE_KEY);
            this.addChildBooleanProp(element2, this.schema.getFontUnderlineQN(), UNDERLINE_KEY);
            this.addChildBooleanProp(element2, this.schema.getFontStrikeQN(), STRIKETHRU_KEY);
        }
    }

    @Override
    public Element generateXMLElement() {
        Element element = DocumentHelper.createElement((QName)this.schema.getFontQN());
        this.addPropertyXML(element, NAME_KEY);
        this.addPropertyXML(element, SIZE_KEY);
        this.generateFontStyle(element);
        return element;
    }

    public String generateCSS() {
        StringBuffer stringBuffer = new StringBuffer();
        this.generateFontFamily(stringBuffer);
        this.generateFontSize(stringBuffer);
        this.generateFontWeight(stringBuffer);
        this.generateFontStyle(stringBuffer);
        this.generateTextDecoration(stringBuffer);
        return stringBuffer.toString();
    }

    private void generateTextDecoration(StringBuffer stringBuffer) {
        BooleanStyleProperty booleanStyleProperty = (BooleanStyleProperty)this.properties.get(UNDERLINE_KEY);
        BooleanStyleProperty booleanStyleProperty2 = (BooleanStyleProperty)this.properties.get(OVERLINE_KEY);
        BooleanStyleProperty booleanStyleProperty3 = (BooleanStyleProperty)this.properties.get(STRIKETHRU_KEY);
        if (null != booleanStyleProperty || null != booleanStyleProperty2 || null != booleanStyleProperty3) {
            stringBuffer.append("text-decoration:");
            if (!BooleanStyleProperty.isFalseOrNull(booleanStyleProperty)) {
                stringBuffer.append("underline ");
            }
            if (!BooleanStyleProperty.isFalseOrNull(booleanStyleProperty2)) {
                stringBuffer.append("overline ");
            }
            if (!BooleanStyleProperty.isFalseOrNull(booleanStyleProperty3)) {
                stringBuffer.append("line-through ");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append("; ");
        }
    }

    private void generateFontStyle(StringBuffer stringBuffer) {
        BooleanStyleProperty booleanStyleProperty = (BooleanStyleProperty)this.properties.get(ITALICS_KEY);
        if (!BooleanStyleProperty.isFalseOrNull(booleanStyleProperty)) {
            stringBuffer.append("font-style:italic; ");
        }
    }

    private void generateFontWeight(StringBuffer stringBuffer) {
        BooleanStyleProperty booleanStyleProperty = (BooleanStyleProperty)this.properties.get(BOLD_KEY);
        if (!BooleanStyleProperty.isFalseOrNull(booleanStyleProperty)) {
            stringBuffer.append("font-weight:bold; ");
        }
    }

    private void generateFontSize(StringBuffer stringBuffer) {
        SizeStyleProperty sizeStyleProperty = (SizeStyleProperty)this.properties.get(SIZE_KEY);
        if (null != sizeStyleProperty) {
            stringBuffer.append("font-size:");
            stringBuffer.append(sizeStyleProperty.generateCSSValue());
            stringBuffer.append("; ");
        }
    }

    private void generateFontFamily(StringBuffer stringBuffer) {
        StringStyleProperty stringStyleProperty = (StringStyleProperty)this.properties.get(NAME_KEY);
        if (null != stringStyleProperty) {
            stringBuffer.append("font-family:");
            stringBuffer.append(stringStyleProperty.getValue());
            stringBuffer.append("; ");
        }
    }

    private void generateFontStyle(Element element) {
        Element element2 = element.addElement(this.schema.getFontStyleQN());
        this.addPropertyXML(element2, BOLD_KEY);
        this.addPropertyXML(element2, ITALICS_KEY);
        this.addPropertyXML(element2, UNDERLINE_KEY);
        this.addPropertyXML(element2, OVERLINE_KEY);
        this.addPropertyXML(element2, STRIKETHRU_KEY);
        if (element2.elements().size() <= 0) {
            element2.detach();
        }
    }

    private void addPropertyXML(Element element, String string) {
        Element element2;
        AStyleProperty aStyleProperty = (AStyleProperty)this.properties.get(string);
        if (null != aStyleProperty && (element2 = aStyleProperty.generateXMLElement()) != null) {
            element.add(element2);
        }
    }

    public void setFontName(String string) {
        this.properties.put(NAME_KEY, new StringStyleProperty(this.schema.getFontfamilyQN(), string, this.namespaceVersion));
    }

    public void setBold(boolean bl) {
        this.properties.put(BOLD_KEY, new BooleanStyleProperty(this.schema.getFontBoldQN(), bl, this.namespaceVersion));
    }

    public void setItalics(boolean bl) {
        this.properties.put(ITALICS_KEY, new BooleanStyleProperty(this.schema.getFontItalicsQN(), bl, this.namespaceVersion));
    }

    public void setUnderline(boolean bl) {
        this.properties.put(UNDERLINE_KEY, new BooleanStyleProperty(this.schema.getFontUnderlineQN(), bl, this.namespaceVersion));
    }

    public void setStrikeThru(boolean bl) {
        this.properties.put(STRIKETHRU_KEY, new BooleanStyleProperty(this.schema.getFontStrikeQN(), bl, this.namespaceVersion));
    }

    public void setSize(String string) {
        this.properties.put(SIZE_KEY, new SizeStyleProperty(this.schema.getFontSizeQN(), string, this.namespaceVersion));
    }

    public void setOverline(boolean bl) {
        this.properties.put(OVERLINE_KEY, new BooleanStyleProperty(this.schema.getFontOverlineQN(), bl, this.namespaceVersion));
    }
}

