/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content.style;

import com.cognos.ccs.content.style.AStyleProperty;
import com.cognos.ccs.content.style.StringStyleProperty;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class SizeStyleProperty
extends AStyleProperty {
    private static final String LDX_PERCENT = "PERCENT";
    private static final String CSS_PERCENT = "%";
    private ArrayList<StringStyleProperty> m_val = new ArrayList();
    private ArrayList<StringStyleProperty> m_unit = new ArrayList();
    private final String[] SUPPORTED_UNITS = new String[]{"pt", "%", "px", "in", "cm", "mm", "pc", "em", "ex"};

    public SizeStyleProperty(QName qName, String string, Constants.NamespaceVersion namespaceVersion) {
        super(qName, namespaceVersion);
        this.parseValue(string);
    }

    public SizeStyleProperty(Element element, Constants.NamespaceVersion namespaceVersion) {
        super(element.getQName(), namespaceVersion);
        this.parseElement(element);
    }

    @Override
    public Element generateXMLElement() {
        Element element = DocumentHelper.createElement((QName)this.m_QualifiedName);
        for (int i = 0; i < this.m_val.size(); ++i) {
            element.add(this.m_val.get(i).generateXMLElement());
            element.add(this.m_unit.get(i).generateXMLElement());
        }
        return element;
    }

    public String generateCSSValue() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_val.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.m_val.get(i).getValue());
            StringStyleProperty stringStyleProperty = this.m_unit.get(i);
            if (stringStyleProperty.getValue().equals(LDX_PERCENT)) {
                stringBuffer.append(CSS_PERCENT);
                continue;
            }
            stringBuffer.append(stringStyleProperty.getValue().toLowerCase());
        }
        return stringBuffer.toString();
    }

    private void parseElement(Element element) {
        List<Element> list = this.getChildrenElements(element, this.schema.getSizeValQN());
        List<Element> list2 = this.getChildrenElements(element, this.schema.getSizeUnitQN());
        this.m_val.add(new StringStyleProperty(list.get(0), this.namespaceVersion));
        this.m_unit.add(new StringStyleProperty(list2.get(0), this.namespaceVersion));
        if (list.size() >= 2 && list2.size() >= 2) {
            this.m_val.add(new StringStyleProperty(list.get(1), this.namespaceVersion));
            this.m_unit.add(new StringStyleProperty(list2.get(1), this.namespaceVersion));
        }
    }

    private void parseValue(String string) {
        for (int i = 0; i < this.SUPPORTED_UNITS.length; ++i) {
            int n = string.indexOf(this.SUPPORTED_UNITS[i]);
            if (-1 == n) continue;
            this.m_val.add(new StringStyleProperty(this.schema.getSizeValQN(), string.substring(0, n), this.namespaceVersion));
            String string2 = string.substring(n).toUpperCase();
            if (string2.equals(CSS_PERCENT)) {
                string2 = LDX_PERCENT;
            }
            this.m_unit.add(new StringStyleProperty(this.schema.getSizeUnitQN(), string2, this.namespaceVersion));
        }
    }
}

