/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.content.style;

import com.cognos.ccs.content.style.AComplexProperty;
import com.cognos.ccs.content.style.AStyleProperty;
import com.cognos.ccs.content.style.BooleanStyleProperty;
import com.ibm.cognos.ccs.internal.utility.Constants;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

public class TextStyleProperty
extends AComplexProperty {
    private static final String WRAPPING_KEY = "wrapping";

    public TextStyleProperty(QName qName, Constants.NamespaceVersion namespaceVersion) {
        super(qName, namespaceVersion);
    }

    public TextStyleProperty(Element element, Constants.NamespaceVersion namespaceVersion) {
        super(element.getQName(), namespaceVersion);
        this.addChildBooleanProp(element, this.schema.getWrappingQN(), WRAPPING_KEY);
    }

    public String generateCSS(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        BooleanStyleProperty booleanStyleProperty = (BooleanStyleProperty)this.properties.get(WRAPPING_KEY);
        if (null != booleanStyleProperty && !booleanStyleProperty.isTrue()) {
            stringBuffer.append(string);
            stringBuffer.append(":");
            stringBuffer.append("nowrap");
            stringBuffer.append("; ");
        }
        return stringBuffer.toString();
    }

    @Override
    public Element generateXMLElement() {
        Element element = DocumentHelper.createElement((QName)this.schema.getTextStyleQN());
        this.addPropertyXML(element, WRAPPING_KEY);
        return element;
    }

    public void setWrapping(boolean bl) {
        this.properties.put(WRAPPING_KEY, new BooleanStyleProperty(this.schema.getWrappingQN(), bl, this.namespaceVersion));
    }

    private void addPropertyXML(Element element, String string) {
        Element element2;
        AStyleProperty aStyleProperty = (AStyleProperty)this.properties.get(string);
        if (null != aStyleProperty && (element2 = aStyleProperty.generateXMLElement()) != null) {
            element.add(element2);
        }
    }
}

