/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.context;

import com.cognos.ccs.context.ContextRetriever;
import com.cognos.ccs.drill.ContextItem;
import com.cognos.ccs.drill.ContextList;
import com.cognos.ccs.drill.MetadataItem;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.filter.ContextFilter;
import com.cognos.ccs.filter.CtxFilterHandler;
import com.cognos.ccs.filter.Filter;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.utility.Utilities;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.Element;
import org.xml.sax.ContentHandler;

public class Selection {
    private static final long serialVersionUID = 1L;
    protected Document m_Selection = null;
    protected String m_reportObject = null;
    protected List m_Rows = null;
    protected List m_Columns = null;
    protected List m_Measures = null;
    protected List m_Sections = null;
    protected String m_BurstId = null;
    protected HashMap m_MatchMap = null;
    protected ContextList m_ContextList = null;
    protected boolean inSummary = false;
    protected ContextRetriever m_retriever;
    public static final int eROW = 1;
    public static final int eCOLUMN = 2;
    public static final int eMEASURE = 3;
    public static final int eSECTION = 4;

    public Selection(Element element, ContextRetriever contextRetriever) throws CCSGeneralException {
        this.m_retriever = contextRetriever;
        this.m_MatchMap = new HashMap();
        this.parseSelection(element);
    }

    public ContentHandler buildFilterHandler(Filter[] filterArray, OutputStream outputStream, boolean bl, long l, String string) {
        CtxFilterHandler ctxFilterHandler = new CtxFilterHandler((ContextFilter)filterArray[0], "http://www.ibm.com/xmlns/prod/cognos/layoutData/200904");
        ctxFilterHandler.setOutStream(outputStream);
        return ctxFilterHandler;
    }

    public void parseSelection(Element element) throws CCSGeneralException {
        try {
            Element element2;
            Element element3 = element.element("query").element("selection");
            this.m_reportObject = element3.element("layoutElementId").getText();
            Element element4 = element3.element("rows");
            if (element4 != null) {
                this.m_Rows = element4.elements("row");
            }
            if ((element4 = element3.element("columns")) != null) {
                this.m_Columns = element4.elements("column");
            }
            if ((element4 = element3.element("measures")) != null) {
                this.m_Measures = element4.elements("measure");
            }
            if ((element4 = element3.element("sections")) != null) {
                this.m_Sections = element4.elements("section");
            }
            if ((element2 = element.element("burst-context")) != null) {
                this.m_BurstId = element2.getText();
            }
        }
        catch (Exception exception) {
            throw new CCSGeneralException("CSEL_ERROR", exception, 400);
        }
    }

    public String getBurstId() {
        return this.m_BurstId;
    }

    public String getObjectId() {
        return this.m_reportObject;
    }

    public Dimension[] getColumnDispNames(int n) {
        int n2 = n - this.m_Columns.size();
        Dimension[] dimensionArray = null;
        if (n2 > 0) {
            dimensionArray = this.getMeasureDispNames();
            if (dimensionArray == null || dimensionArray.length < 1) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        Dimension[] dimensionArray2 = new Dimension[this.m_Columns.size() + n2];
        int n3 = this.m_Columns.size() - 1;
        for (int i = 0; i <= n3; ++i) {
            Element element = (Element)this.m_Columns.get(n3 - i);
            Element element2 = element.element("selectAll");
            dimensionArray2[i] = new Dimension();
            if (element2 != null && element2.getText().equals("true")) {
                dimensionArray2[i].bWildCarded = true;
            }
            dimensionArray2[i].name = this.unencodeSelection(element.element("item").element("value").element("item").elementText("display"));
        }
        if (n2 > 0) {
            dimensionArray2[dimensionArray2.length - 1] = dimensionArray[0];
        }
        return dimensionArray2;
    }

    public Dimension[] getRowDispNames(int n) {
        int n2 = n - this.m_Rows.size();
        Dimension[] dimensionArray = null;
        if (n2 > 0) {
            dimensionArray = this.getMeasureDispNames();
            if (dimensionArray == null || dimensionArray.length < 1) {
                n2 = 0;
            }
        } else {
            n2 = 0;
        }
        Dimension[] dimensionArray2 = new Dimension[this.m_Rows.size() + n2];
        int n3 = this.m_Rows.size() - 1;
        for (int i = 0; i <= n3; ++i) {
            Element element = (Element)this.m_Rows.get(n3 - i);
            Element element2 = element.element("selectAll");
            dimensionArray2[i] = new Dimension();
            if (element2 != null && element2.getText().equals("true")) {
                dimensionArray2[i].bWildCarded = true;
            }
            dimensionArray2[i].name = this.unencodeSelection(element.element("item").element("value").element("item").elementText("display"));
        }
        if (n2 > 0) {
            dimensionArray2[dimensionArray2.length - 1] = dimensionArray[0];
        }
        return dimensionArray2;
    }

    public Dimension[] getMeasureDispNames() {
        Dimension[] dimensionArray = new Dimension[this.m_Measures.size()];
        for (int i = 0; i < this.m_Measures.size(); ++i) {
            Element element = (Element)this.m_Measures.get(i);
            dimensionArray[i] = new Dimension();
            dimensionArray[i].name = element.element("item").elementText("name");
        }
        return dimensionArray;
    }

    public String[] getColumnTitles() {
        String[] stringArray = new String[this.m_Columns.size()];
        int n = this.m_Columns.size() - 1;
        for (int i = 0; i < this.m_Columns.size(); ++i) {
            Element element = (Element)this.m_Columns.get(n - i);
            stringArray[i] = element.element("item").elementText("name");
        }
        return stringArray;
    }

    public String[] getMeasureTitles() {
        String[] stringArray = new String[this.m_Measures.size()];
        for (int i = 0; i < this.m_Measures.size(); ++i) {
            Element element = (Element)this.m_Measures.get(i);
            stringArray[i] = element.element("item").elementText("name");
        }
        return stringArray;
    }

    public String unencodeSelection(String string) {
        String string2 = string.replaceAll("&nbsp;", " ");
        return string2;
    }

    public boolean isSummarySelection() {
        try {
            Element element = (Element)this.m_Measures.get(0);
            return element.attributeValue("dataType").equals("summary") || element.attributeValue("dataType").equals("section");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public SelectionDim[] getDimSelections(int n) {
        List list = null;
        if (n == 2) {
            list = this.m_Columns;
        }
        if (n == 1) {
            list = this.m_Rows;
        }
        if (n == 3) {
            list = this.m_Measures;
        }
        if (n == 4) {
            list = this.m_Sections;
        }
        if (list == null) {
            return null;
        }
        SelectionDim[] selectionDimArray = new SelectionDim[list.size()];
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            Element element = (Element)list.get(n2 - i - 1);
            Element element2 = element.element("selectAll");
            selectionDimArray[i] = new SelectionDim();
            if (element2 != null && element2.getText().equals("true")) {
                selectionDimArray[i].bWildCarded = true;
            }
            selectionDimArray[i].dimType = n;
            selectionDimArray[i].value = element.element("item").element("value").element("item").elementText("use");
            selectionDimArray[i].value = Utilities.unescapeXML(selectionDimArray[i].value);
            selectionDimArray[i].value = Utilities.unescapeXML(selectionDimArray[i].value);
            selectionDimArray[i].fmtValue = this.unencodeSelection(element.element("item").element("value").element("item").elementText("display"));
            selectionDimArray[i].dataItem = element.element("item").elementText("name");
        }
        return selectionDimArray;
    }

    public int getNumberOfColumns() {
        return this.m_Columns.size();
    }

    public int getNumberOfRows() {
        return this.m_Rows.size();
    }

    public boolean isContextMatch(String string) {
        try {
            SelectionDim[][] selectionDimArray = new SelectionDim[][]{this.getDimSelections(1), this.getDimSelections(2), this.getDimSelections(3), this.getDimSelections(4)};
            boolean bl = false;
            if (string.indexOf("::") != -1) {
                bl = true;
            }
            String[] stringArray = string.split(":");
            for (int i = 0; i < stringArray.length; ++i) {
                MatchItem[] matchItemArray;
                if (stringArray[i].equals("")) continue;
                if (this.m_MatchMap.containsKey(stringArray[i])) {
                    matchItemArray = (MatchItem[])this.m_MatchMap.get(stringArray[i]);
                    for (int j = 0; j < matchItemArray.length; ++j) {
                        if (matchItemArray[j].dimType == -1) continue;
                        SelectionDim selectionDim = selectionDimArray[matchItemArray[j].dimType - 1][matchItemArray[j].dimIndex];
                        selectionDim.bSatisfied = true;
                        if (i != 0 || bl || matchItemArray[j].dimType != 3) continue;
                        bl = true;
                    }
                    continue;
                }
                matchItemArray = this.getContext(stringArray[i]);
                MatchItem[] matchItemArray2 = this.performMatch((ContextItem)matchItemArray, selectionDimArray);
                this.m_MatchMap.put(stringArray[i], matchItemArray2);
                for (int j = 0; j < matchItemArray2.length; ++j) {
                    if (i != 0 || bl || matchItemArray2[j].dimType != 3) continue;
                    bl = true;
                }
            }
            if (bl) {
                return this.allDimsSatisfied(selectionDimArray);
            }
            return false;
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("FILTER_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            return false;
        }
    }

    public ContextItem getContext(String string) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException {
        return this.m_retriever.getContextItem(string);
    }

    public MatchItem[] performMatch(ContextItem contextItem, SelectionDim[][] selectionDimArray) {
        Vector<MatchItem> vector = new Vector<MatchItem>();
        MatchItem matchItem = null;
        for (int i = 0; i < selectionDimArray.length; ++i) {
            matchItem = this.isDimMatch(contextItem, selectionDimArray[i]);
            if (matchItem.dimType == -1) continue;
            vector.add(matchItem);
        }
        if (vector.size() == 0) {
            return new MatchItem[]{new MatchItem(-1, -1)};
        }
        MatchItem[] matchItemArray = new MatchItem[vector.size()];
        matchItemArray = vector.toArray(matchItemArray);
        return matchItemArray;
    }

    public MatchItem isDimMatch(ContextItem contextItem, SelectionDim[] selectionDimArray) {
        if (selectionDimArray == null) {
            return new MatchItem(-1, -1);
        }
        for (int i = 0; i < selectionDimArray.length; ++i) {
            String string;
            String string2;
            MetadataItem metadataItem = this.m_retriever.getMetadataItem(contextItem.getRdi());
            String string3 = metadataItem.getValue("r");
            String string4 = metadataItem.getValue("usage");
            if (!string3.equals(selectionDimArray[i].dataItem)) continue;
            if (selectionDimArray[i].bWildCarded) {
                selectionDimArray[i].bSatisfied = true;
                return new MatchItem(selectionDimArray[i].dimType, i);
            }
            if (selectionDimArray[i].dimType == 3) {
                if (this.isSummarySelection() && !this.getInSummary() || !this.isSummarySelection() && this.getInSummary()) {
                    return new MatchItem(-1, -1);
                }
                selectionDimArray[i].bSatisfied = true;
                return new MatchItem(selectionDimArray[i].dimType, i);
            }
            if (selectionDimArray[i].value.equals(contextItem.getUse())) {
                selectionDimArray[i].bSatisfied = true;
                return new MatchItem(selectionDimArray[i].dimType, i);
            }
            if (contextItem.getMun().equals("") || !(string2 = selectionDimArray[i].value).equals(string = (metadataItem = this.m_retriever.getMetadataItem(contextItem.getMun())).getValue("m"))) continue;
            selectionDimArray[i].bSatisfied = true;
            return new MatchItem(selectionDimArray[i].dimType, i);
        }
        return new MatchItem(-1, -1);
    }

    private boolean allDimsSatisfied(SelectionDim[][] selectionDimArray) {
        for (int i = 0; i < selectionDimArray.length; ++i) {
            if (this.allSatisfied(selectionDimArray[i])) continue;
            return false;
        }
        return true;
    }

    private boolean allSatisfied(SelectionDim[] selectionDimArray) {
        if (selectionDimArray == null) {
            return true;
        }
        for (int i = 0; i < selectionDimArray.length; ++i) {
            if (selectionDimArray[i].bSatisfied) continue;
            return false;
        }
        return true;
    }

    public void setInSummary(boolean bl) {
        this.inSummary = bl;
    }

    public boolean getInSummary() {
        return this.inSummary;
    }

    public class SelectionDim {
        public boolean bWildCarded = false;
        public String dataItem = null;
        public String value = null;
        public String fmtValue = null;
        public int dimType = 0;
        public boolean bSatisfied = false;
        public int grpDepth = 0;
    }

    public class Dimension {
        public boolean bWildCarded = false;
        public String name = new String();
    }

    protected class MatchItem {
        public static final int NO_MATCH = -1;
        public int dimType;
        public int dimIndex;

        public MatchItem(int n, int n2) {
            this.dimType = n;
            this.dimIndex = n2;
        }
    }
}

