/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.conversion.ldxv1;

import com.cognos.ccs.conversion.ldxv1.AElementConverter;
import com.cognos.ccs.conversion.ldxv1.DrillDefsConverter;
import com.cognos.ccs.conversion.ldxv1.LDXV2ToV1Converter;
import com.cognos.ccs.conversion.ldxv1.LocationRefConverter;
import com.cognos.ccs.conversion.ldxv1.PageConverter;
import com.cognos.ccs.conversion.ldxv1.PageGroupConverter;
import com.cognos.ccs.conversion.ldxv1.StyleGroupConverter;
import com.ibm.cognos.ccs.internal.utility.Constants;

public class DocumentConverter
extends AElementConverter {
    public DocumentConverter(LDXV2ToV1Converter lDXV2ToV1Converter) {
        super(lDXV2ToV1Converter);
    }

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 3300: {
                if (this.m_Converter.getCompatibilityMode() == Constants.Compatibility.C8_4_OEM) {
                    this.m_Converter.write("<document xmlns=\"http://developer.cognos.com/schemas/rds/contentmodel/1\">");
                    this.m_Converter.writeElement("schemaSubversion", "1");
                    break;
                }
                this.m_Converter.write("<document xmlns=\"http://www.ibm.com/xmlns/prod/cognos/layoutData/200904\">");
                break;
            }
            case 1010: {
                this.m_Converter.setEchoMode(true);
                break;
            }
            case 1011: {
                this.m_Converter.setEchoMode(false);
                break;
            }
            case 3500: {
                this.m_Converter.pushFsm(new LocationRefConverter(this.m_Converter));
                this.m_Converter.injectEvent(n);
                break;
            }
            case 9000: {
                this.m_Converter.writeOpen("pageGroup");
                this.m_Converter.pushFsm(new PageGroupConverter(this.m_Converter));
                break;
            }
            case 2802: {
                if (this.m_Converter.getCompatibilityMode() != Constants.Compatibility.C8_4_1) break;
                this.m_Converter.writeOpen("pages");
                break;
            }
            case 2803: {
                if (this.m_Converter.getCompatibilityMode() != Constants.Compatibility.C8_4_1) break;
                this.m_Converter.writeClose("pages");
                break;
            }
            case 2800: {
                this.m_Converter.pushFsm(new PageConverter(this.m_Converter));
                this.m_Converter.injectEvent(n);
                break;
            }
            case 3301: {
                this.m_Converter.writeClose("document");
                this.m_Converter.popFsm();
                break;
            }
            case 14000: {
                this.m_Converter.pushFsm(new DrillDefsConverter(this.m_Converter));
                this.m_Converter.injectEvent(n);
                break;
            }
            case 3000: {
                this.m_Converter.pushFsm(new StyleGroupConverter(this.m_Converter));
                this.m_Converter.injectEvent(n);
            }
        }
    }
}

