/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.dashboard;

import com.cognos.ccs.content.HTTPRequest;
import com.cognos.ccs.dashboard.DashboardSpecBuilder;
import com.cognos.ccs.dashboard.ReportPath;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.exceptions.CCSPromptException;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.CCSSession;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.AuthoredPowerPlay8Report;
import com.cognos.developer.schemas.bibus._3.AuthoredReport;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.ReportVersion;
import com.cognos.developer.schemas.bibus._3.Sort;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Dashboard {
    private Cognos8Connector connector;
    protected String searchPath;
    private CCSSession session;
    private Cookie[] cookies;
    private Hashtable<String, ReportPath> savedReports;

    public Dashboard(String string, Cognos8Connector cognos8Connector, Cookie[] cookieArray, CCSSession cCSSession) {
        this.connector = cognos8Connector;
        this.searchPath = string;
        this.session = cCSSession;
        this.cookies = cookieArray;
    }

    public InputStream getOutput(String string, boolean bl, boolean bl2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException, IOException, DocumentException {
        return this.getOutput(string, bl, false, bl2);
    }

    public InputStream getOutput(String string, boolean bl, boolean bl2, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException, IOException, DocumentException {
        Document document = this.getDashboardSpec(this.searchPath);
        DashboardSpecBuilder dashboardSpecBuilder = this.buildDashboardSpec(document, "NEW", bl, bl2, bl3);
        Document document2 = dashboardSpecBuilder.buildLDX(this.session);
        Element element = document2.getRootElement();
        String string2 = element.asXML();
        byte[] byArray = string2.getBytes("UTF-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    public Document getReportInfo(boolean bl) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException, IOException, DocumentException {
        return this.getReportInfo(bl, false, false);
    }

    public Document getReportInfo(boolean bl, boolean bl2) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException, IOException, DocumentException {
        return this.getReportInfo(bl, bl2, false);
    }

    public Document getReportInfo(boolean bl, boolean bl2, boolean bl3) throws CCSGeneralException, CCSAuthenticationException, CCSPromptException, IOException, DocumentException {
        Document document = this.getDashboardSpec(this.searchPath);
        DashboardSpecBuilder dashboardSpecBuilder = this.buildDashboardSpec(document, "NEW", bl, bl2, bl3);
        Document document2 = dashboardSpecBuilder.buildInfo(this.session);
        return document2;
    }

    public DashboardSpecBuilder getPromptBuilder(boolean bl) throws CCSGeneralException, CCSAuthenticationException {
        return this.getPromptBuilder(bl, false);
    }

    public DashboardSpecBuilder getPromptBuilder(boolean bl, boolean bl2) throws CCSGeneralException, CCSAuthenticationException {
        Document document = this.getDashboardSpec(this.searchPath);
        DashboardSpecBuilder dashboardSpecBuilder = this.buildDashboardSpec(document, null, bl, bl2, false);
        dashboardSpecBuilder.setPromptMode();
        return dashboardSpecBuilder;
    }

    public List<Element> getPages(Document document) {
        Element element = document.getRootElement();
        Element element2 = element.element("dashboard");
        List list = element2.elements("page");
        if (list.size() > 1) {
            list.remove(0);
        }
        return list;
    }

    public Hashtable<String, Element> getPortletMap(List<Element> list) throws CCSGeneralException, CCSAuthenticationException {
        Hashtable<String, Element> hashtable = new Hashtable<String, Element>();
        this.savedReports = new Hashtable();
        Document document = this.getPortlets(list);
        Element element = document.getRootElement();
        List list2 = element.elements("widgetInstance");
        for (Element element2 : list2) {
            String string = element2.attributeValue("id");
            hashtable.put(string, element2);
            List list3 = element2.selectNodes("/result/widgetInstance/contentItemSet/item[@id='mostRecentSavedOutput']");
            Iterator iterator = list3.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                List list4;
                Element element3 = (Element)iterator.next();
                if (!Utilities.parseOptionalXMLBoolean(element3.attributeValue("value"), false) || (list4 = element2.selectNodes("/result/widgetInstance/contentItemSet/item[@id='originalReport']")).isEmpty() || !(list4.get(0) instanceof Element)) continue;
                arrayList.add(((Element)list4.get(0)).attributeValue("value"));
            }
            if (arrayList.isEmpty()) continue;
            this.setSavedReportPaths(arrayList);
        }
        return hashtable;
    }

    public Document getPagelets(List<Element> list) throws CCSGeneralException {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("result");
        for (Element element2 : list) {
            Object object;
            Element element3 = element2.element("layout");
            String string = element3.attributeValue("version");
            if (null != string && string.startsWith("2.0")) {
                object = new CCSGeneralException("OP_NOT_SUPPORTED_ERROR", 400);
                CCSLogger.getInstance().logRuntimeErrorMessage("CCS_INVALID_DASHBOARD", "com.cognos.ccs.dashboard.Dashboard.getPagelets", this.searchPath, string, ((CCSGeneralException)object).getSourceTrace());
                throw object;
            }
            object = element3.createCopy();
            element.add((Element)object);
        }
        return document;
    }

    public Hashtable<String, ReportPath> getReportPaths() throws CCSGeneralException, CCSAuthenticationException {
        Hashtable<String, ReportPath> hashtable = new Hashtable<String, ReportPath>();
        BaseClass[] baseClassArray = this.cmQueryReportObject(this.searchPath + "/*");
        for (int i = 0; i < baseClassArray.length; ++i) {
            BaseClass baseClass = baseClassArray[i];
            if (!(baseClass instanceof AuthoredReport) && !(baseClass instanceof AuthoredPowerPlay8Report)) continue;
            Dashboard.updateReportsMap(hashtable, baseClass);
        }
        return hashtable;
    }

    private DashboardSpecBuilder buildDashboardSpec(Document document, String string, boolean bl, boolean bl2, boolean bl3) throws CCSGeneralException, CCSAuthenticationException {
        Object object;
        Object object2;
        List<Element> list = this.getPages(document);
        Hashtable<String, Element> hashtable = this.getPortletMap(list);
        Document document2 = this.getPagelets(list);
        Hashtable<String, ReportPath> hashtable2 = this.getReportPaths();
        if (!this.savedReports.isEmpty()) {
            object2 = this.savedReports.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                String string2 = object.next();
                hashtable2.put(string2, this.savedReports.get(string2));
            }
        }
        object2 = this.session.getGatewayURL(bl, bl2);
        object = new DashboardSpecBuilder(list, hashtable, document2, hashtable2, string, (String)object2, this.connector, bl, bl2, bl3);
        return object;
    }

    private void setSavedReportPaths(ArrayList<String> arrayList) throws CCSGeneralException, CCSAuthenticationException {
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            string = string + arrayList.get(i) + "/*" + (i < arrayList.size() - 1 ? " | " : "");
        }
        if (string.length() > 0) {
            BaseClass[] baseClassArray = this.cmQueryReportObject(string);
            for (int i = 0; i < baseClassArray.length; ++i) {
                BaseClass baseClass = baseClassArray[i];
                if (!(baseClass instanceof ReportVersion)) continue;
                Dashboard.updateReportsMap(this.savedReports, baseClass);
            }
        }
    }

    private Document getPortlets(List<Element> list) throws CCSGeneralException {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("result");
        for (Element element2 : list) {
            Iterator iterator = element2.elementIterator("widgetInstance");
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Element)) continue;
                Element element3 = ((Element)e).createCopy();
                element.add(element3);
            }
        }
        return document;
    }

    private Document getDashboardSpec(String string) throws CCSGeneralException, CCSAuthenticationException {
        String string2 = this.getStoreIdFromSearchPath(string);
        String string3 = ConfigMgr.getInstance().getCognosDispatcher() + "/icd/feeds/cm/id/" + string2 + "?entry=";
        Document document = this.httpGetDashboardSpec(string3);
        return document;
    }

    protected Document httpGetDashboardSpec(String string) throws CCSGeneralException {
        Document document = null;
        HTTPRequest hTTPRequest = new HTTPRequest(this.cookies);
        String string2 = null;
        try {
            hTTPRequest.setMethod("GET");
            string2 = hTTPRequest.retrieveContent(string);
            document = Utilities.parseText(string2);
        }
        catch (DocumentException documentException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("CCS_DASHBOARD_ERROR", new String[]{string}, (Exception)((Object)documentException), 404);
            CCSLogger.getInstance().logRuntimeErrorMessage(documentException.getMessage(), "com.cognos.ccs.dashboard.Dashboard.queryCM(String)", this.searchPath, string, cCSGeneralException.getSourceTrace());
            throw cCSGeneralException;
        }
        return document;
    }

    private String getStoreIdFromSearchPath(String string) throws CCSGeneralException, CCSAuthenticationException {
        String string2 = null;
        BaseClass[] baseClassArray = this.cmQueryReportObject(string);
        for (int i = 0; null == string2 && i < baseClassArray.length; ++i) {
            BaseClass baseClass = baseClassArray[i];
            GuidProp guidProp = baseClass.getStoreID();
            Guid guid = guidProp.getValue();
            string2 = guid.get_value();
        }
        return string2;
    }

    private static void updateReportsMap(Hashtable<String, ReportPath> hashtable, BaseClass baseClass) {
        String string = baseClass.getDefaultName().getValue();
        final String string2 = baseClass.getStoreID().getValue().get_value();
        final String string3 = baseClass.getSearchPath().getValue();
        ReportPath reportPath = new ReportPath(){

            @Override
            public String storeID() {
                return string2;
            }

            @Override
            public String searchPath() {
                return string3;
            }
        };
        hashtable.put(string, reportPath);
    }

    private BaseClass[] cmQueryReportObject(String string) throws CCSGeneralException, CCSAuthenticationException {
        PropEnum[] propEnumArray = new PropEnum[]{PropEnum.defaultName, PropEnum.context, PropEnum.layout, PropEnum.storeID, PropEnum.searchPath};
        Sort[] sortArray = new Sort[]{new Sort()};
        sortArray[0].setOrder(OrderEnum.descending);
        sortArray[0].setPropName(PropEnum.defaultName);
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setDataEncoding(EncodingEnum.MIME);
        return this.connector.queryCM(string, sortArray, propEnumArray, queryOptions);
    }
}

