/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.dashboard;

import com.cognos.ccs.dashboard.ReferenceMap;
import com.cognos.ccs.fsm.LdxHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Hashtable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Document;

public class DashboardComposer {
    Document dashboardSpec;
    OutputStream out;
    Hashtable portlets;
    XMLStreamWriter writer;
    HashSet excludedElements;
    boolean excludeText;
    int currentTag;
    ReferenceMap refMap;
    ReferenceMap styleMap;
    XMLInputFactory inputFactory;
    int numStreams;

    public DashboardComposer(OutputStream outputStream) {
        this(outputStream, null);
    }

    public DashboardComposer(OutputStream outputStream, Document document) {
        this.dashboardSpec = document;
        this.out = outputStream;
        this.portlets = new Hashtable();
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        this.excludeText = false;
        this.populateExcludedElements();
        this.inputFactory = XMLInputFactory.newInstance();
        this.numStreams = 0;
        try {
            this.writer = xMLOutputFactory.createXMLStreamWriter(this.out);
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    private void populateExcludedElements() {
        this.excludedElements = new HashSet();
        this.excludedElements.add("filterResultSet");
        this.excludedElements.add("filterResult");
        this.excludedElements.add("filterType");
        this.excludedElements.add("filterValue");
        this.excludedElements.add("reportElement");
    }

    public void addInputStream(String string, InputStream inputStream) {
        try {
            XMLStreamReader xMLStreamReader = this.inputFactory.createXMLStreamReader(inputStream, "UTF-8");
            Portlet portlet = new Portlet(this.numStreams++, xMLStreamReader);
            this.portlets.put(string, portlet);
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    public void parseDashboard() {
        try {
            this.refMap = new ReferenceMap('R', this.portlets.size());
            this.styleMap = new ReferenceMap('S', this.portlets.size());
            XMLStreamReader xMLStreamReader = this.inputFactory.createXMLStreamReader(new StringReader(this.dashboardSpec.asXML()));
            String string = "";
            while (xMLStreamReader.hasNext()) {
                int n = xMLStreamReader.next();
                switch (n) {
                    case 1: {
                        string = xMLStreamReader.getLocalName();
                        if (string.equals("references")) {
                            this.writeReferences();
                            break;
                        }
                        if (string.equals("styles")) {
                            this.writeStyles();
                            break;
                        }
                        if (string.equals("fragment")) break;
                        this.writer.writeStartElement(string);
                        break;
                    }
                    case 4: {
                        if (string.equals("fragment")) {
                            Portlet portlet = (Portlet)this.portlets.get(xMLStreamReader.getText());
                            this.writeContent(portlet);
                            break;
                        }
                        this.writer.writeCharacters(xMLStreamReader.getText());
                        break;
                    }
                    case 2: {
                        if (!(string.equals("references") || string.equals("styles") || string.equals("fragment"))) {
                            this.writer.writeEndElement();
                        }
                        string = "";
                    }
                }
            }
            this.writer.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    private void writeStyles() throws XMLStreamException {
        for (Portlet portlet : this.portlets.values()) {
            XMLStreamReader xMLStreamReader = portlet.reader;
            int n = portlet.index;
            this.writeStart("styleGroup");
            while (xMLStreamReader.hasNext()) {
                int n2 = xMLStreamReader.next();
                block0 : switch (n2) {
                    case 1: {
                        String string = xMLStreamReader.getLocalName();
                        this.writeStart(string);
                        break;
                    }
                    case 4: {
                        switch (this.currentTag) {
                            case 1100: {
                                this.writeText(this.styleMap.getMapping(n, xMLStreamReader.getText()));
                                break block0;
                            }
                        }
                        this.writeText(xMLStreamReader.getText());
                        break;
                    }
                    case 2: {
                        this.writeEnd(xMLStreamReader.getLocalName());
                    }
                }
            }
            this.writer.flush();
        }
    }

    private void writeContent(Portlet portlet) throws XMLStreamException {
        XMLStreamReader xMLStreamReader = portlet.reader;
        this.writer.writeStartElement("item");
        boolean bl = false;
        while (xMLStreamReader.hasNext() && !bl) {
            int n = xMLStreamReader.next();
            block0 : switch (n) {
                case 1: {
                    String string = xMLStreamReader.getLocalName();
                    if (string.equals("styleGroup")) {
                        bl = true;
                        break;
                    }
                    this.writeStart(string);
                    break;
                }
                case 4: {
                    switch (this.currentTag) {
                        case 2200: {
                            this.writeText(this.refMap.getMapping(portlet.index, xMLStreamReader.getText()));
                            break block0;
                        }
                        case 2400: {
                            this.writeText(this.styleMap.getMapping(portlet.index, xMLStreamReader.getText()));
                            break block0;
                        }
                    }
                    this.writeText(xMLStreamReader.getText());
                    break;
                }
                case 2: {
                    this.writeEnd(xMLStreamReader.getLocalName());
                }
            }
        }
        this.writer.writeEndElement();
        this.writer.flush();
    }

    private void writeReferences() throws XMLStreamException {
        for (Portlet portlet : this.portlets.values()) {
            XMLStreamReader xMLStreamReader = portlet.reader;
            int n = portlet.index;
            boolean bl = false;
            while (xMLStreamReader.hasNext() && !bl) {
                int n2 = xMLStreamReader.next();
                block0 : switch (n2) {
                    case 1: {
                        String string = xMLStreamReader.getLocalName();
                        if (string.equals("filterResult")) {
                            bl = true;
                            break;
                        }
                        this.writeStart(string);
                        break;
                    }
                    case 4: {
                        switch (this.currentTag) {
                            case 2200: {
                                this.writeText(this.refMap.getMapping(n, xMLStreamReader.getText()));
                                break block0;
                            }
                        }
                        this.writeText(xMLStreamReader.getText());
                        break;
                    }
                    case 2: {
                        this.writeEnd(xMLStreamReader.getLocalName());
                    }
                }
            }
            this.writer.flush();
        }
    }

    private void writeEnd(String string) throws XMLStreamException {
        this.currentTag = -1;
        if (!this.excludedElements.contains(string)) {
            this.writer.writeEndElement();
        }
    }

    private void writeStart(String string) throws XMLStreamException {
        this.currentTag = LdxHandler.lookupToken(string, true);
        if (!this.excludedElements.contains(string)) {
            this.writer.writeStartElement(string);
            this.excludeText = false;
        } else {
            this.excludeText = true;
        }
    }

    private void writeText(String string) throws XMLStreamException {
        if (!this.excludeText) {
            this.writer.writeCharacters(string);
        }
    }

    private class Portlet {
        public int index;
        public XMLStreamReader reader;

        public Portlet(int n, XMLStreamReader xMLStreamReader) {
            this.index = n;
            this.reader = xMLStreamReader;
        }
    }
}

