/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.dashboard;

import com.cognos.ccs.dashboard.DashboardSpecBuilderBackgroundStyleGroups;
import com.cognos.ccs.dashboard.DashboardSpecBuilderWidgetURI;
import com.cognos.ccs.dashboard.ReportPath;
import com.cognos.ccs.exceptions.CCSException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.reportinfo.ReportInfoHandler;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.CCSSession;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.utility.SAXParserFactoryWrapper;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DashboardSpecBuilder {
    private Element styleGroups;
    private int currentStyle;
    private Hashtable<String, Element> m_portletMap;
    private Hashtable<String, ReportPath> reportPaths;
    private Document pageletSpec;
    private String versionType;
    private String gatewayURI;
    private Cognos8Connector connection;
    private boolean m_promptMode = false;
    private final List<Element> m_pageElems;
    private boolean m_generateRelativeURL;
    private boolean m_useGatewayURI;
    private boolean m_embedImages;

    public DashboardSpecBuilder(List<Element> list, Hashtable<String, Element> hashtable, Document document, Hashtable<String, ReportPath> hashtable2, String string, String string2, Cognos8Connector cognos8Connector, boolean bl, boolean bl2) {
        this(list, hashtable, document, hashtable2, string, string2, cognos8Connector, bl, false, bl2);
    }

    public DashboardSpecBuilder(List<Element> list, Hashtable<String, Element> hashtable, Document document, Hashtable<String, ReportPath> hashtable2, String string, String string2, Cognos8Connector cognos8Connector, boolean bl, boolean bl2, boolean bl3) {
        this.m_pageElems = list;
        this.m_portletMap = hashtable;
        this.currentStyle = 1;
        this.styleGroups = DocumentHelper.createElement((String)"styleGroups");
        this.pageletSpec = document;
        this.versionType = string;
        this.reportPaths = hashtable2;
        this.gatewayURI = string2;
        this.connection = cognos8Connector;
        this.m_generateRelativeURL = bl;
        this.m_useGatewayURI = bl2;
        this.m_embedImages = bl3;
    }

    public void setPromptMode() {
        this.m_promptMode = true;
    }

    public Document buildInfo(CCSSession cCSSession) {
        Document document = null;
        ReportInfoHandler reportInfoHandler = new ReportInfoHandler(cCSSession != null ? cCSSession.getRequestVersion() : null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        reportInfoHandler.setOutStream(byteArrayOutputStream);
        Document document2 = this.buildLDX(cCSSession);
        SAXReader sAXReader = new SAXReader();
        try {
            Element element = document2.getRootElement();
            String string = element.asXML();
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            InputSource inputSource = new InputSource(byteArrayInputStream);
            SAXParser sAXParser = SAXParserFactoryWrapper.getParser();
            sAXParser.parse(inputSource, (DefaultHandler)reportInfoHandler);
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            document = sAXReader.read(new InputSource(byteArrayInputStream2));
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("DASHBOARD_REPORTINFO_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeWarning(exception.getMessage(), "com.cognos.ccs.dashboard.Dashboard.getReportPaths()", "", "", cCSGeneralException.getSourceTrace());
        }
        return document;
    }

    public Document buildLDX(CCSSession cCSSession) {
        List list;
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("document");
        Iterator<Element> iterator = this.m_pageElems.iterator();
        Element element2 = this.pageletSpec.getRootElement();
        List list2 = element2.elements("layout");
        Iterator iterator2 = list2.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            iterator.next();
            list = element.addElement("pages");
            Element element3 = list.addElement("page");
            Element element4 = (Element)iterator2.next();
            this.processLayout(++n, element3, element4, cCSSession);
        }
        list = this.styleGroups.elements();
        for (Element element4 : list) {
            this.styleGroups.remove(element4);
            element.add(element4);
        }
        return document;
    }

    public void processLayout(int n, Element element, Element element2, CCSSession cCSSession) {
        Element element3;
        Object object;
        List list;
        Object object2;
        Element element4 = element.addElement("id");
        element4.addText("Page" + n);
        String string = null;
        Element element5 = element2.element("layoutProperties");
        if (null != element5) {
            object2 = new DashboardSpecBuilderBackgroundStyleGroups(element5, n, cCSSession);
            list = ((DashboardSpecBuilderBackgroundStyleGroups)object2).pageBgStyleGroupElem();
            if (null != list) {
                this.styleGroups.add((Element)list);
                object = list.elementText("name");
                element3 = element.addElement("style");
                element3.setText((String)object);
            }
            object = ((DashboardSpecBuilderBackgroundStyleGroups)object2).widgetContentBgStyleGroupElem();
            element5.element("widgetBackgroundColor");
            if (null != object) {
                this.styleGroups.add((Element)object);
                string = object.elementText("name");
            }
        }
        object2 = element.addElement("body");
        list = element2.elements("widgetInstance");
        if (list.size() == 0) {
            object = element2.getParent();
            list = object.elements("widgetInstance");
        }
        object = list.iterator();
        while (object.hasNext()) {
            element3 = object2.addElement("item");
            Element element6 = (Element)object.next();
            Element element7 = element3.addElement("widget");
            this.processWidget(element7, element6, string, cCSSession);
        }
    }

    public Element processWidget(Element element, Element element2, String string, CCSSession cCSSession) {
        Element element3;
        String string2;
        ReportPath reportPath;
        Object object;
        Object object2;
        Element element42;
        List list;
        String string3 = element2.attributeValue("refid");
        Element element5 = this.m_portletMap.get(string3);
        Element element6 = element5.element("title");
        Element element7 = element5.element("contentItemSet");
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        Boolean bl = false;
        String string9 = null;
        if (element7 != null) {
            list = element7.elements("item");
            for (Element element42 : list) {
                if (element42.attributeValue("id").equals("savedReportName")) {
                    string4 = element42.attributeValue("value");
                }
                if (element42.attributeValue("id").equals("savedReportId")) {
                    string5 = element42.attributeValue("value");
                }
                if (element42.attributeValue("id").equals("savedReportPath")) {
                    string6 = element42.attributeValue("value");
                }
                if (element42.attributeValue("id").equals("savedReportPath.resource")) {
                    string7 = element42.attributeValue("value");
                }
                if (element42.attributeValue("id").equals("originalReport") && (string8 = element42.attributeValue("value")).startsWith("/")) {
                    string8 = string8.substring(1);
                }
                if (element42.attributeValue("id").equals("mostRecentSavedOutput")) {
                    bl = true;
                }
                if (!element42.attributeValue("id").equals("objectClass")) continue;
                string9 = element42.attributeValue("value");
            }
        }
        if (bl.booleanValue()) {
            string4 = string8;
            if (Utilities.isNullOrBlank(this.versionType) || this.versionType.equalsIgnoreCase("NEW")) {
                this.versionType = "LATEST";
            }
        }
        list = element.addElement("id");
        String string10 = element6.getText();
        list.setText(string10);
        if (cCSSession != null && cCSSession.getRequestVersion() == Constants.RequestVersion.V3) {
            element42 = element.addElement("title");
            element42.setText(string10);
        }
        if ((element42 = this.processLayoutProperties(element2)) != null) {
            element.add(element42);
        }
        if (null != string) {
            object2 = element.addElement("style");
            object2.setText(string);
        }
        object2 = null;
        if (!Utilities.isNullOrBlank(string6)) {
            if (this.reportPaths != null) {
                object = string3;
                if (!Utilities.isNullOrBlank(string7) && string7.startsWith("searchPath,")) {
                    object = string7.substring("searchPath,".length()) + ":" + (String)object;
                }
                if (null != (reportPath = this.reportPaths.get(object))) {
                    object2 = reportPath.storeID();
                }
            }
            if (Utilities.isNullOrBlank((String)object2)) {
                object2 = this.verifyStoreID(string6, string8);
            }
            if (!Utilities.isNullOrBlank((String)object2)) {
                object2 = Utilities.searchPathStripStoreID((String)object2);
            }
        }
        if (Utilities.isNullOrBlank((String)object2) && !Utilities.isNullOrBlank(string4) && null != this.reportPaths && null != (object = this.reportPaths.get(string4))) {
            object2 = object.storeID();
        }
        if (Utilities.isNullOrBlank((String)object2) && !Utilities.isNullOrBlank(string5) && null != this.reportPaths) {
            object2 = this.verifyStoreID("storedID('" + string5 + "')", null);
        }
        if (Utilities.isNullOrBlank((String)object2) && !Utilities.isNullOrBlank(string8)) {
            object2 = this.verifyStoreID(string8, null);
        }
        if (null != (reportPath = ((DashboardSpecBuilderWidgetURI)(object = new DashboardSpecBuilderWidgetURI((String)object2, this.gatewayURI, this.m_promptMode, bl, this.versionType, this.m_generateRelativeURL, this.m_useGatewayURI, this.m_embedImages, string9, cCSSession))).widgetURIElem())) {
            element.add((Element)reportPath);
        }
        Element element8 = element.addElement("extension");
        Element element9 = ((DashboardSpecBuilderWidgetURI)object).typeElem();
        element8.add(element9);
        Element element10 = ((DashboardSpecBuilderWidgetURI)object).storeIDElem();
        if (null != element10) {
            element8.add(element10);
        }
        if (!Utilities.isNullOrEmpty(string2 = element5.elementText("thumbnail"))) {
            element3 = element8.addElement("thumbnail");
            element3.setText(string2);
        }
        if (null != (element3 = ((DashboardSpecBuilderWidgetURI)object).objectClassElem())) {
            element8.add(element3);
        }
        return element;
    }

    private String verifyStoreID(String string, String string2) {
        try {
            PropEnum[] propEnumArray = new PropEnum[]{PropEnum.storeID};
            BaseClass[] baseClassArray = this.connection.queryCM(string, propEnumArray);
            if (baseClassArray != null & baseClassArray.length > 0) {
                string2 = baseClassArray[0].getStoreID().getValue().get_value();
            }
        }
        catch (CCSException cCSException) {
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSException.getServerLocaleMessage(), null, null, null, null);
        }
        return string2;
    }

    private Element processLayoutProperties(Element element) {
        Element element2 = null;
        Element element3 = element.element("layoutProperties");
        if (null != element3) {
            element2 = DocumentHelper.createElement((String)"style");
            String string = "DS" + this.currentStyle++;
            element2.setText(string);
            Element element4 = this.styleGroups.addElement("styleGroup");
            Element element5 = element4.addElement("name");
            element5.setText(string);
            Element element6 = element3.element("contentLayout");
            Element element7 = this.createBoxStyleGroup(element6);
            element4.add(element7);
        }
        return element2;
    }

    private Element createBoxStyleGroup(Element element) {
        String string = element.element("position").getText();
        Element element2 = this.createSize("x", element.element("left").getText());
        Element element3 = this.createSize("y", element.element("top").getText());
        Element element4 = this.createSize("width", element.element("width").getText());
        Element element5 = this.createSize("height", element.element("height").getText());
        Element element6 = DocumentHelper.createElement((String)"drawOrder");
        element6.setText(element.element("zIndex").getText());
        Element element7 = DocumentHelper.createElement((String)"boxStyle");
        element7.add(element5);
        element7.add(element4);
        Element element8 = element7.addElement("extension");
        element8.add(element2);
        element8.add(element3);
        element8.add(element6);
        Element element9 = element8.addElement("position");
        element9.setText(string);
        return element7;
    }

    private Element createSize(String string, String string2) {
        Element element = DocumentHelper.createElement((String)string);
        Element element2 = element.addElement("val");
        element2.setText(string2);
        Element element3 = element.addElement("units");
        element3.setText("PX");
        return element;
    }
}

