/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.filter;

import com.cognos.ccs.filter.XPath.Util;
import com.cognos.ccs.filter.XPath.XPathObserver;
import com.cognos.ccs.filter.XPathFilter;
import com.cognos.ccs.fsm.LdxHandler;
import java.io.OutputStream;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XPathFilterHandler
extends LdxHandler {
    protected static String START_RESULT_SET_FMT = "<filterResultSet xmlns=\"%1$s\">";
    protected static String END_RESULT_SET = "</filterResultSet>";
    protected XPathFilter m_Filter = null;
    private String filterValue;
    private String regFilterValue;
    private String func;
    private boolean containPredicate = false;
    XPathObserver osr;
    public static final int BEGIN = 0;
    public static final int END = 1;
    protected Vector PositionStack = new Vector();
    protected String lastPopTag;
    protected int lastTagType;
    protected static final int STARTTAG = 0;
    protected static final int ENDTAG = 1;
    protected String m_OutputNS;

    public XPathFilterHandler(XPathFilter xPathFilter, String string) {
        this.init(xPathFilter);
        this.m_OutputNS = string;
    }

    private void init(XPathFilter xPathFilter) {
        this.m_Filter = xPathFilter;
        this.filterValue = xPathFilter.getFilterValue();
        String string = this.filterValue;
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.indexOf("[") > -1) {
            this.containPredicate = true;
            this.osr = new XPathObserver(this);
            this.osr.setup(string);
        } else {
            if (string.endsWith("()")) {
                int n = string.lastIndexOf("/");
                this.func = string.substring(n + 1);
                string = string.substring(0, n);
            }
            this.regFilterValue = Util.regXPath(string);
        }
    }

    public XPathFilterHandler(XPathFilter xPathFilter, OutputStream outputStream, String string) {
        this.setOutStream(outputStream);
        this.init(xPathFilter);
        this.m_OutputNS = string;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.PositionStack.size() == 0) {
            this.PositionStack.add(new Integer(1));
        } else if (string2.equals(this.lastPopTag) && this.lastTagType == 1) {
            int n = (Integer)this.PositionStack.get(this.m_XpathCursor);
            this.PositionStack.set(this.m_XpathCursor, new Integer(n + 1));
        } else if (this.PositionStack.size() < this.m_XpathCursor + 1) {
            this.PositionStack.add(new Integer(1));
        } else {
            this.PositionStack.set(this.m_XpathCursor, new Integer(1));
        }
        super.startElement(string, string2, string3, attributes);
        this.lastTagType = 0;
        if (this.containPredicate) {
            String string4 = this.getXPathLocWithPosition(0);
            this.osr.processEvent(string4, 0);
        } else if (Util.compare(this.getXPathLocWithPosition(0), this.regFilterValue)) {
            if (this.func == null || !this.func.equals("text()")) {
                this.writeOpen(string2);
            }
            this.setEchoMode(true);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.containPredicate) {
            this.lastPopTag = (String)this.m_XpathLoc.get(this.m_XpathCursor - 1);
            this.osr.processEvent(this.getXPathLocWithPosition(0), 1);
            this.lastTagType = 1;
        } else if (Util.compare(this.getXPathLocWithPosition(0), this.regFilterValue)) {
            this.setEchoMode(false);
            if (this.func == null || !this.func.equals("text()")) {
                this.writeClose(string2);
            }
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void startDocument() throws SAXException {
        this.write(String.format(START_RESULT_SET_FMT, this.m_OutputNS));
        this.write("<filterResult>");
        this.write("<filterType>XPATH</filterType>");
        this.writeElement("filterValue", this.filterValue);
        this.write("<reportElement>");
        this.flushOutput();
    }

    @Override
    public void endDocument() throws SAXException {
        this.write("</reportElement></filterResult>");
        this.write(END_RESULT_SET);
        super.endDocument();
    }

    public int getPosition() {
        return (Integer)this.PositionStack.get(this.m_XpathCursor - 1);
    }

    public String getXPathLocWithPosition(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < this.m_XpathCursor; ++i) {
            stringBuffer.append("/");
            stringBuffer.append(this.m_XpathLoc.get(i));
            stringBuffer.append("[" + this.PositionStack.get(i) + "]");
        }
        return stringBuffer.toString();
    }
}

