/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.filter.ldx;

import com.cognos.ccs.filter.ldx.LDXChart;
import com.cognos.ccs.filter.ldx.LDXFilterHandler;
import com.cognos.ccs.fsm.LdxHandler;
import com.cognos.ccs.utility.Utilities;
import java.util.regex.Pattern;

public abstract class ALDXReportElement
implements LdxHandler.FilterFSM {
    public static final String ID = "id";
    private static final String OBJECT_ID = "OBJECT_ID";
    public static final String REPORT_ELEMENT = "reportElement";
    public static final String FILTER_VALUE = "filterValue";
    public static final String FILTER_TYPE = "filterType";
    public static final String FILTER_RESULT = "filterResult";
    public static final Pattern test = Pattern.compile("x[a-z0-9]{24}");
    protected LDXFilterHandler m_Handler;
    boolean m_inFilteredElement = false;
    int m_RowCount = 0;
    String m_ctx;
    public boolean m_OrginalEchoMode = false;
    boolean canDrillUp = false;
    boolean canDrillDown = false;

    @Override
    public void processEvent(int n) {
        switch (n) {
            case 1010: {
                this.m_Handler.RecordTextNodeOn();
                break;
            }
            case 1011: {
                String string = this.m_Handler.getTextNode();
                this.m_Handler.RecordTextNodeOff();
                if (test.matcher(string).matches()) {
                    string = this instanceof LDXChart ? "e553a0ec-4504-405c-8bcf-3730823b1480" : "fbaec708-a22c-4cd5-95a9-c7d73193535e";
                }
                if (this.m_inFilteredElement || !this.m_Handler.hasFilters() || !this.m_Handler.isFiltered(string) || this.m_Handler.isFilterResultTagAdded()) break;
                this.m_Handler.writeOpen(FILTER_RESULT);
                this.m_Handler.writeElement(FILTER_TYPE, OBJECT_ID);
                this.m_Handler.writeElement(FILTER_VALUE, string);
                this.m_Handler.writeOpen(REPORT_ELEMENT);
                this.m_Handler.writeOpen(this.getElementTag());
                this.m_Handler.writeOpen(ID);
                this.m_Handler.write(Utilities.escapeXML(string));
                this.m_Handler.setEchoMode(true);
                this.m_Handler.filterResultTagAdded(true);
                this.m_inFilteredElement = true;
                break;
            }
            case 8000: {
                this.m_Handler.RecordTextNodeOn();
                break;
            }
            case 8001: {
                this.m_ctx = this.m_Handler.getTextNode();
                this.m_Handler.RecordTextNodeOff();
                break;
            }
            case 17600: {
                this.m_Handler.RecordTextNodeOn();
                break;
            }
            case 17601: {
                this.m_Handler.skipNextElement();
                this.m_Handler.skipLastElement();
                if (!this.m_Handler.getEchoMode()) break;
                this.m_Handler.writeClose("direction");
                String string = this.m_Handler.getTextNode();
                if (this.m_Handler.getAppenders().getDrillAppender() == null) break;
                this.m_Handler.getAppenders().getDrillAppender().append(this.m_ctx, string, this.m_Handler);
            }
        }
    }

    public abstract String getElementTag();

    public void endFSMElement() {
        if ((this.m_inFilteredElement || !this.m_Handler.hasFilters()) && this.m_Handler.getAppenders().getAnnotationAppender() != null) {
            this.m_Handler.getAppenders().getAnnotationAppender().append(this.m_ctx, this.m_Handler);
        }
        if (this.m_inFilteredElement) {
            if (!this.m_OrginalEchoMode) {
                this.m_Handler.writeClose(this.getElementTag());
                this.m_Handler.writeClose(REPORT_ELEMENT);
                this.m_Handler.writeClose(FILTER_RESULT);
                this.m_Handler.filterResultTagAdded(false);
            }
            this.m_Handler.skipLastElement();
            this.m_inFilteredElement = false;
        }
        this.m_Handler.setEchoMode(this.m_OrginalEchoMode);
        this.m_Handler.popFsm();
    }

    @Override
    public void reset() {
    }
}

