/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.filter.ldx;

import com.cognos.ccs.filter.ldx.ALDXReportElement;
import com.cognos.ccs.filter.ldx.LDXCell;
import com.cognos.ccs.filter.ldx.LDXDrills;
import com.cognos.ccs.filter.ldx.LDXFilterHandler;

public class LDXCrosstab
extends ALDXReportElement {
    private static final String CTAB = "ctab";
    boolean m_InTable = false;
    boolean m_InRowDim = false;
    boolean m_MaxDepthReached = false;
    int m_LevelCount = 0;
    int m_MaxDepth = 0;
    int m_DimCount = 0;

    public LDXCrosstab(LDXFilterHandler lDXFilterHandler) {
        this.m_Handler = lDXFilterHandler;
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 1030: {
                this.m_OrginalEchoMode = this.m_Handler.getEchoMode();
                break;
            }
            case 1070: {
                if ((long)this.m_DimCount >= this.m_Handler.getRowLimit() && this.m_inFilteredElement) {
                    if (this.m_MaxDepth > 0) {
                        for (int i = 1; i < this.m_MaxDepth; ++i) {
                            this.m_Handler.writeClose("nestedDimension");
                        }
                        this.m_Handler.writeClose("row");
                    }
                    this.m_Handler.setEchoMode(true);
                }
                this.m_InTable = true;
                break;
            }
            case 1071: {
                if (this.m_inFilteredElement) {
                    this.m_Handler.setEchoMode(true);
                }
                this.m_InTable = false;
                break;
            }
            case 1040: {
                if (!this.m_InTable && (this.m_inFilteredElement || this.m_OrginalEchoMode)) {
                    this.m_LevelCount = 0;
                    if (!this.m_InRowDim) {
                        this.m_InRowDim = true;
                        break;
                    }
                    if (this.m_MaxDepth == 0) {
                        ++this.m_DimCount;
                    }
                    if ((long)this.m_DimCount < this.m_Handler.getRowLimit()) break;
                    this.m_Handler.setEchoMode(false);
                    this.m_inFilteredElement = true;
                    break;
                }
                if ((long)this.m_RowCount >= this.m_Handler.getRowLimit()) {
                    this.m_Handler.setEchoMode(false);
                    break;
                }
                ++this.m_RowCount;
                break;
            }
            case 1090: {
                if (!this.m_InRowDim) break;
                ++this.m_LevelCount;
                if (this.m_LevelCount != this.m_MaxDepth) break;
                ++this.m_DimCount;
                if ((long)this.m_DimCount < this.m_Handler.getRowLimit()) break;
                this.m_inFilteredElement = true;
                this.m_Handler.setEchoMode(false);
                break;
            }
            case 1091: {
                if (!this.m_InRowDim) break;
                if (!this.m_MaxDepthReached) {
                    this.m_MaxDepthReached = true;
                    this.m_MaxDepth = this.m_LevelCount;
                }
                --this.m_LevelCount;
                break;
            }
            case 1041: {
                break;
            }
            case 1300: {
                this.m_Handler.pushFsm(new LDXCell(this.m_Handler));
                break;
            }
            case 1031: {
                this.endFSMElement();
                break;
            }
            case 10000: {
                this.m_Handler.pushFsm(new LDXDrills(this.m_Handler));
            }
        }
    }

    @Override
    public String getElementTag() {
        return CTAB;
    }
}

