/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.filter.ldx;

import com.cognos.ccs.filter.ldx.ALDXReportElement;
import com.cognos.ccs.filter.ldx.LDXDrills;
import com.cognos.ccs.filter.ldx.LDXFilterHandler;
import com.cognos.ccs.filter.ldx.LDXNestedCrosstab;
import com.cognos.ccs.filter.ldx.LDXNestedList;
import com.cognos.ccs.filter.ldx.LDXNestedRepeaterTbl;

public class LDXRepeaterTable
extends ALDXReportElement {
    private static final String REPTBL = "reptbl";
    int m_RowCount = 0;
    boolean bFirstTag = false;

    public LDXRepeaterTable(LDXFilterHandler lDXFilterHandler) {
        this.m_Handler = lDXFilterHandler;
    }

    @Override
    public void processEvent(int n) {
        super.processEvent(n);
        switch (n) {
            case 5006: {
                if (!this.bFirstTag) {
                    this.m_OrginalEchoMode = this.m_Handler.getEchoMode();
                    this.bFirstTag = true;
                    break;
                }
                this.m_Handler.pushFsm(new LDXNestedRepeaterTbl(this.m_Handler));
                break;
            }
            case 1020: {
                this.m_Handler.pushFsm(new LDXNestedList(this.m_Handler));
                break;
            }
            case 1030: {
                this.m_Handler.pushFsm(new LDXNestedCrosstab(this.m_Handler));
                break;
            }
            case 1040: {
                if ((long)this.m_RowCount >= this.m_Handler.getRowLimit()) {
                    this.m_Handler.setEchoMode(false);
                    break;
                }
                ++this.m_RowCount;
                break;
            }
            case 10000: {
                this.m_Handler.pushFsm(new LDXDrills(this.m_Handler));
                break;
            }
            case 5007: {
                this.endFSMElement();
            }
        }
    }

    @Override
    public String getElementTag() {
        return REPTBL;
    }
}

