/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats;

import com.cognos.ccs.formats.APostProcessor;
import com.cognos.ccs.fsm.LdxHandler;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.utility.Utilities;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class CCSFormatter
extends LdxHandler {
    protected CCSFormatter preprocessor = null;
    protected APostProcessor postprocessor = null;
    protected StringBuffer recordingBuffer;
    private String m_reportName = null;
    protected int imageWidth;
    protected int imageHeight;
    protected boolean soapencode = false;
    protected String webcontentRoot = "/ibmcognos";
    protected String gatewayURI = null;
    protected Constants.RequestVersion requestVersion = null;
    protected Locale m_productLocale = null;
    protected boolean m_isAccessibilityFeaturesEnabled = false;

    public static String encodeName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append("__");
                continue;
            }
            Utilities.encodeChar(stringBuffer, c);
        }
        return stringBuffer.toString();
    }

    public static String decodeName(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '_') {
                stringBuffer.append(c);
                continue;
            }
            if (string.charAt(i + 1) == '_') {
                stringBuffer.append(' ');
                ++i;
                continue;
            }
            if (string.charAt(i + 1) == 'x') {
                String string2 = string.substring(i + 2, i + 6);
                try {
                    char c2 = (char)Integer.parseInt(string2, 16);
                    stringBuffer.append(c2);
                }
                catch (NumberFormatException numberFormatException) {
                    stringBuffer.append("_x");
                    stringBuffer.append(string2);
                }
                i += 5;
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public APostProcessor getPostProcessor() {
        return this.postprocessor;
    }

    public void setPostProcessor(APostProcessor aPostProcessor) {
        this.postprocessor = aPostProcessor;
    }

    public boolean getSOAPEncode() {
        return this.soapencode;
    }

    public void setSOAPEncode(boolean bl) {
        this.soapencode = bl;
    }

    public void setWidth(int n) {
        this.imageWidth = n;
    }

    public void setHeight(int n) {
        this.imageHeight = n;
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public int getHeight() {
        return this.imageHeight;
    }

    public CCSFormatter getPreProcessor() {
        return this.preprocessor;
    }

    public void startRecording() {
        this.recordingBuffer = new StringBuffer();
    }

    public void stopRecording() {
        this.recordingBuffer = null;
    }

    public String getRecordedText() {
        if (null != this.recordingBuffer) {
            return this.recordingBuffer.toString();
        }
        return null;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.recordingBuffer != null) {
            this.recordingBuffer.append("</");
            this.recordingBuffer.append(string2);
            this.recordingBuffer.append(">");
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        super.startElement(string, string2, string3, attributes);
        if (this.recordingBuffer != null) {
            this.recordingBuffer.append("<");
            this.recordingBuffer.append(string2);
            if (string2.equals("styleGroup")) {
                this.recordingBuffer.append(" xmlns=\"http://developer.cognos.com/schemas/rds/contentmodel/1\"");
            }
            this.recordingBuffer.append(">");
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        if (this.recordingBuffer != null) {
            this.recordingBuffer.append(this.escapeIfNeeded(cArray, n, n2));
        }
    }

    public void setReportName(String string) {
        this.m_reportName = string;
    }

    public String getReportName() {
        return this.m_reportName;
    }

    public void setGatewayURI(String string) {
        this.gatewayURI = string;
    }

    public String getGatewayURI() {
        if (null == this.gatewayURI) {
            this.gatewayURI = ConfigMgr.getInstance().getCognosGateway();
        }
        return this.gatewayURI;
    }

    public void setWebcontentRoot(String string) {
        if (this.preprocessor != null) {
            this.preprocessor.webcontentRoot = string;
        }
        this.webcontentRoot = string;
    }

    public String getWebcontentRoot() {
        return this.webcontentRoot;
    }

    public static String encodeNameForTag(String string) {
        String string2 = CCSFormatter.encodeName(string);
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        if (Character.isLetter(string2.charAt(0))) {
            return string2;
        }
        return 'e' + string2;
    }

    public void setRequestVersion(Constants.RequestVersion requestVersion) {
        this.requestVersion = requestVersion;
    }

    public Constants.RequestVersion getRequestVersion() {
        return this.requestVersion;
    }

    public void setProductLocale(Locale locale) {
        this.m_productLocale = locale;
    }

    public Locale getProductLocale() {
        return this.m_productLocale;
    }

    public void setIsAccessibilityFeaturesEnabled(boolean bl) {
        this.m_isAccessibilityFeaturesEnabled = bl;
    }

    public boolean getIsAccessibilityFeaturesEnabled() {
        return this.m_isAccessibilityFeaturesEnabled;
    }

    public void setCssSuffix(String string) {
    }
}

