/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.content.DashboardContentProvider;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.service.CCLMessage;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.ConfigMgr;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class FormatLoader {
    private HashMap<String, FormatHolder> formatHolders = new HashMap();

    public FormatLoader() {
        this.loadFormats(ConfigMgr.getInstance().getFileStream("/xslt/raas/formats.xml"));
    }

    public FormatLoader(InputStream inputStream) {
        this.loadFormats(inputStream);
    }

    private void loadFormats(InputStream inputStream) {
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(inputStream);
            Iterator iterator = document.getRootElement().elementIterator();
            while (iterator.hasNext()) {
                FormatHolder formatHolder = new FormatHolder((Element)iterator.next());
                if (null == formatHolder.getName()) continue;
                this.formatHolders.put(formatHolder.getName().toLowerCase(), formatHolder);
            }
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    public CCSFormatter getFormatter(String string, ContentProvider contentProvider) throws CCSAuthenticationException, CCSGeneralException {
        FormatHolder formatHolder;
        if (null == string) {
            return null;
        }
        if (string.equalsIgnoreCase("image") && contentProvider instanceof DashboardContentProvider) {
            string = "DImage";
        }
        if ((formatHolder = this.formatHolders.get(string.toLowerCase())) != null) {
            CCSFormatter cCSFormatter = formatHolder.getNewInstance();
            cCSFormatter.setReportName(contentProvider.getReportName());
            return cCSFormatter;
        }
        return null;
    }

    public String getContentType(String string) {
        if (null == string) {
            return null;
        }
        FormatHolder formatHolder = this.formatHolders.get(string.toLowerCase());
        if (formatHolder != null) {
            return formatHolder.contentType;
        }
        return null;
    }

    protected class FormatHolder {
        private String contentType;
        private Class classreference;
        private String name;

        public FormatHolder(Element element) {
            try {
                Element element2 = this.getElement(element, "class");
                Element element3 = this.getElement(element, "name");
                Element element4 = this.getElement(element, "contentType");
                this.classreference = Class.forName(element2.getText());
                this.name = element3.getText();
                this.contentType = element4.getText();
            }
            catch (ClassNotFoundException classNotFoundException) {
                CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("FORMAT_LOADER_ERR", ConfigMgr.getInstance().getServerLocale()), null, null, null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                CCSLogger.getInstance().logRuntimeErrorMessage(CCLMessage.getResMessage("FORMAT_LOADER_ERR", ConfigMgr.getInstance().getServerLocale()), null, null, null, null);
            }
        }

        private Element getElement(Element element, String string) {
            Element element2 = element.element(string);
            if (null == element2) {
                throw new IllegalArgumentException();
            }
            return element2;
        }

        public boolean isAllowedForServiceType(String string) {
            return string.equals("REST") || string.equals("SOAP");
        }

        public CCSFormatter getNewInstance() {
            try {
                return (CCSFormatter)this.classreference.newInstance();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }
}

