/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats;

import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.ccs.formats.APostProcessor;
import com.cognos.ccs.formats.image.CCSEditorKit;
import com.cognos.ccs.service.Conversation;
import com.cognos.ccs.utility.Utilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JTextPane;
import org.apache.commons.httpclient.Cookie;

public class ImagePostProcessor
extends APostProcessor {
    @Override
    public void process(int n, int n2, boolean bl, Conversation conversation) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        byte[] byArray = new byte[4096];
        int n3 = -1;
        try {
            while ((n3 = this.input.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n3);
            }
            String string = byteArrayOutputStream.toString();
            Cookie[] cookieArray = null == conversation ? new Cookie[]{} : (Cookie[])conversation.getProperty("cookies");
            BufferedImage bufferedImage = this.capture(string, cookieArray);
            if (n > 0 && n2 > 0) {
                bufferedImage = this.resizeImage(bufferedImage, n, n2);
            }
            byte[] byArray2 = this.genImageByte(bufferedImage, "png");
            if (bl) {
                byArray2 = CCLWeb64.encode((byte[])byArray2).getBytes();
            }
            this.output.write(byArray2);
            this.output.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private BufferedImage capture(String string, Cookie[] cookieArray) {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setSize(10, 10);
        jTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jTextPane.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        MediaTracker mediaTracker = new MediaTracker(jTextPane);
        CCSEditorKit cCSEditorKit = new CCSEditorKit(mediaTracker, cookieArray);
        jTextPane.setEditorKit(cCSEditorKit);
        string = Utilities.htmlRemoveJavascriptTags(string);
        jTextPane.setText(string);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Dimension dimension = jTextPane.getPreferredSize();
        jTextPane.setSize(dimension);
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        boolean bl = jTextPane.isOpaque();
        jTextPane.setOpaque(true);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setClip(rectangle);
        jTextPane.paint(graphics2D);
        graphics2D.dispose();
        jTextPane.setOpaque(bl);
        return bufferedImage;
    }

    public BufferedImage resizeImage(BufferedImage bufferedImage, int n, int n2) {
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (n3 == n && n4 == n2) {
            return bufferedImage;
        }
        float f = Math.max((float)n3 / (float)n, (float)n4 / (float)n2);
        int n5 = Math.round((float)n3 / f);
        int n6 = Math.round((float)n4 / f);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.drawImage(bufferedImage, (n - n5) / 2, (n2 - n6) / 2, n5, n6, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public byte[] genImageByte(BufferedImage bufferedImage, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
            ImageWriter imageWriter = iterator.next();
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(bufferedImage);
            imageOutputStream.flush();
            imageOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

