/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats;

import com.cognos.ccs.content.ContentProvider;
import com.cognos.ccs.exceptions.CCSAuthenticationException;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.service.Cognos8Connector;
import com.cognos.ccs.service.CommandSession;
import com.cognos.ccs.service.ConfigMgr;
import com.cognos.ccs.utility.Utilities;
import com.cognos.developer.schemas.bibus._3.Analysis;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Content;
import com.cognos.developer.schemas.bibus._3.Dashboard;
import com.cognos.developer.schemas.bibus._3.Folder;
import com.cognos.developer.schemas.bibus._3.PowerPlayReport;
import com.cognos.developer.schemas.bibus._3.Query;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3._package;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class WsilGen {
    private static final Namespace NS_WSIL = Namespace.get((String)"", (String)"http://schemas.xmlsoap.org/ws/2001/10/inspection/");
    private static final QName INSPECTION_QN = DocumentHelper.createQName((String)"inspection", (Namespace)NS_WSIL);

    private static void buildPortalNode(Element element, BaseClass baseClass, Cognos8Connector cognos8Connector, String string) throws CCSGeneralException, CCSAuthenticationException {
        try {
            String string2 = baseClass.getDefaultName().getValue();
            String string3 = ContentProvider.convertSearchPathToResourcePath(baseClass.getSearchPath().getValue(), cognos8Connector);
            if (WsilGen.isVisible(baseClass)) {
                if (baseClass instanceof Report || baseClass instanceof Analysis || baseClass instanceof PowerPlayReport || baseClass instanceof Query || baseClass instanceof Dashboard || baseClass instanceof ReportView) {
                    WsilGen.createWSDLLink(element, string2, string3, string, baseClass);
                } else if (baseClass instanceof Folder || baseClass instanceof _package || baseClass instanceof Content) {
                    WsilGen.createWSILLink(element, string2, string3, string, baseClass);
                }
            }
        }
        catch (Exception exception) {
            throw new CCSGeneralException("WSIL_ERROR", exception, 404);
        }
    }

    private static void createWSILLink(Element element, String string, String string2, String string3, BaseClass baseClass) {
        boolean bl = WsilGen.isTraverseSet(baseClass);
        String string4 = WsilGen.getGateway(string3) + "/rds/wsil/path/" + Utilities.IRIEncode(string2, false);
        Element element2 = element.addElement("link");
        element2.addAttribute("referencedNamespace", "http://schemas.xmlsoap.org/ws/2001/10/inspection/");
        if (bl) {
            element2.addAttribute("location", string4);
        }
        Element element3 = element2.addElement("abstract");
        element3.addText(string);
    }

    private static void createWSDLLink(Element element, String string, String string2, String string3, BaseClass baseClass) {
        boolean bl = WsilGen.isExecuteSet(baseClass);
        String string4 = WsilGen.getGateway(string3) + "/rds/wsdl/path/" + Utilities.IRIEncode(string2, true);
        Element element2 = element.addElement("service");
        element2.addElement("name").addText(string);
        element2.addElement("abstract").addText("IBM Cognos8 Content service");
        Element element3 = element2.addElement("description");
        element3.addAttribute("referencedNamespace", "http://schemas.xmlsoap.org/wsdl/");
        if (bl) {
            element3.addAttribute("location", string4);
        }
    }

    public static String generateWSIL(CommandSession commandSession, String string) throws CCSGeneralException, CCSAuthenticationException {
        return WsilGen.generateWSIL(commandSession, string, true);
    }

    public static String generateWSIL(CommandSession commandSession, String string, boolean bl) throws CCSGeneralException, CCSAuthenticationException {
        Cognos8Connector cognos8Connector = commandSession.getConnect();
        String string2 = commandSession.getAbsoluteGatewayURL();
        Document document = DocumentHelper.createDocument();
        document.addComment("Licensed Materials - Property of IBM\n\nBI and PM: CCS\n\n(C) Copyright IBM Corp. 2005, 2009\n\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.");
        Element element = document.addElement(INSPECTION_QN);
        element.addAttribute("xmlns:wsilwsdl", "http://schemas.xmlsoap.org/ws/2001/10/inspection/wsdl/");
        BaseClass[] baseClassArray = cognos8Connector.getFolder(string, bl);
        if (baseClassArray != null) {
            for (BaseClass baseClass : baseClassArray) {
                if (baseClass == null) continue;
                WsilGen.buildPortalNode(element, baseClass, cognos8Connector, string2);
            }
        }
        return document.asXML();
    }

    static String getGateway(String string) {
        if (null == string) {
            return ConfigMgr.getInstance().getCognosGateway();
        }
        return string;
    }

    private static boolean hasPermissions(BaseClass baseClass, Permission ... permissionArray) {
        String[] stringArray;
        for (String string : stringArray = baseClass.getPermissions().getValue()) {
            for (Permission permission : permissionArray) {
                if (!string.equals(permission.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVisible(BaseClass baseClass) {
        return WsilGen.hasPermissions(baseClass, Permission.read, Permission.write, Permission.execute, Permission.traverse, Permission.setPolicy);
    }

    private static boolean isTraverseSet(BaseClass baseClass) {
        return WsilGen.hasPermissions(baseClass, Permission.traverse);
    }

    private static boolean isExecuteSet(BaseClass baseClass) {
        return WsilGen.hasPermissions(baseClass, Permission.execute);
    }

    private static enum Permission {
        read,
        write,
        traverse,
        execute,
        setPolicy;

    }
}

