/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.css;

import com.cognos.ccs.content.StyleGroup;
import com.cognos.ccs.formats.CCSFormatter;
import com.cognos.ccs.formats.css.CSSObserver;
import com.ibm.cognos.ccs.internal.utility.Constants;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class CSSPreprocessor
extends CCSFormatter {
    protected Map<String, StyleGroup> styles = new LinkedHashMap<String, StyleGroup>();
    protected Map<String, String> drillRefs = new LinkedHashMap<String, String>();
    protected String lang = null;
    protected String m_cssSuffix;

    public CSSPreprocessor() {
        this.SetFsm(new CSSObserver(this));
        this.recordingBuffer = null;
    }

    public void addStyle(String string) {
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read((Reader)new StringReader(string));
            StyleGroup styleGroup = new StyleGroup(document.getRootElement(), Constants.NamespaceVersion.V1, this.getWebcontentRoot(), this.m_cssSuffix);
            this.styles.put(styleGroup.getName(), styleGroup);
        }
        catch (DocumentException documentException) {
            documentException.printStackTrace();
        }
    }

    public StyleGroup getStyle(String string) {
        return this.styles.get(string);
    }

    public int getStyleCount() {
        return this.styles.size();
    }

    public Iterator<StyleGroup> getStyleIterator() {
        return this.styles.values().iterator();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.m_fsmStack.size() > 0) {
            throw new SAXException("STACK NOT EMPTY");
        }
    }

    public void addDrillDefinition(String string, String string2) {
        this.drillRefs.put(string, string2);
    }

    public String getDrillURL(String string) {
        return this.drillRefs.get(string);
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    public void setCssSuffix(String string) {
        if (string == null) {
            string = "";
        }
        this.m_cssSuffix = string;
    }
}

