/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dashboardimage;

import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.APostProcessor;
import com.cognos.ccs.formats.dashboardimage.impl.DashboardImage;
import com.cognos.ccs.formats.dashboardimage.impl.DashboardPanelBuilder;
import com.cognos.ccs.formats.dashboardimage.ldx.Dashboard;
import com.cognos.ccs.formats.dashboardimage.panel.WidgetContentLoader;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.service.Conversation;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JPanel;
import org.apache.commons.httpclient.Cookie;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class DashboardImagePostProcessor
extends APostProcessor {
    @Override
    public void process(int n, int n2, boolean bl, Conversation conversation) {
        Cookie[] cookieArray = (Cookie[])conversation.getProperty("cookies");
        Document document = this.parseInput(this.input);
        String string = (String)conversation.getProperty("version");
        DashboardPanelBuilder dashboardPanelBuilder = new DashboardPanelBuilder();
        WidgetContentLoader widgetContentLoader = dashboardPanelBuilder.contentLoader();
        Dashboard dashboard = dashboardPanelBuilder.dashboard(document, widgetContentLoader);
        Dimension dimension = new Dimension(n, n2);
        JPanel jPanel = dashboardPanelBuilder.jPanel(dashboard, string, cookieArray, dimension, widgetContentLoader);
        jPanel.addNotify();
        try {
            DashboardImage dashboardImage = new DashboardImage(jPanel, dimension);
            BufferedImage bufferedImage = dashboardImage.image();
            byte[] byArray = this.genImageByte(bufferedImage, "png");
            if (bl) {
                byArray = CCLWeb64.encode((byte[])byArray).getBytes();
            }
            this.output.write(byArray);
            this.output.flush();
        }
        catch (IOException iOException) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", iOException, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            iOException.printStackTrace();
        }
    }

    public byte[] genImageByte(BufferedImage bufferedImage, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
            ImageWriter imageWriter = iterator.next();
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(bufferedImage);
            imageOutputStream.flush();
            imageOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Document parseInput(InputStream inputStream) {
        SAXReader sAXReader = new SAXReader();
        try {
            return sAXReader.read(new InputSource(inputStream));
        }
        catch (Exception exception) {
            CCSGeneralException cCSGeneralException = new CCSGeneralException("PARSE_STREAM_ERROR", exception, 500);
            CCSLogger.getInstance().logRuntimeErrorMessage(cCSGeneralException.getServerLocaleMessage(), null, null, null, cCSGeneralException.getSourceTrace());
            return null;
        }
    }
}

