/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dashboardimage.impl;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class DashboardImage {
    private BufferedImage m_image;

    public DashboardImage(JPanel jPanel, Dimension dimension) {
        JPanel jPanel2 = jPanel;
        Dimension dimension2 = jPanel2.getPreferredSize();
        jPanel2.setSize(dimension2.width, dimension2.height);
        int n = dimension2.width > 2048 ? 2048 : dimension2.width;
        int n2 = dimension2.height > 2048 ? 2048 : dimension2.height;
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        boolean bl = jPanel2.isOpaque();
        jPanel2.setOpaque(true);
        this.m_image = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = this.m_image.createGraphics();
        graphics2D.setClip(rectangle);
        jPanel2.paint(graphics2D);
        graphics2D.dispose();
        jPanel2.setOpaque(bl);
        if (dimension.width > 0 && dimension.height > 0) {
            this.m_image = this.resizeImage(this.m_image, dimension);
        }
    }

    public BufferedImage image() {
        return this.m_image;
    }

    private BufferedImage resizeImage(BufferedImage bufferedImage, Dimension dimension) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        if (n == dimension.width && n2 == dimension.height) {
            return bufferedImage;
        }
        float f = Math.max((float)n / (float)dimension.width, (float)n2 / (float)dimension.height);
        int n3 = Math.round((float)n / f);
        int n4 = Math.round((float)n2 / f);
        BufferedImage bufferedImage2 = new BufferedImage(dimension.width, dimension.height, 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.drawImage(bufferedImage, (dimension.width - n3) / 2, (dimension.height - n4) / 2, n3, n4, null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

