/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.ccs.formats.dashboardimage.impl;

import com.cognos.ccs.exceptions.CCSGeneralException;
import com.cognos.ccs.formats.dashboardimage.ldx.BackgroundImageProperties;
import com.cognos.ccs.formats.dashboardimage.ldx.BackgroundStyleGroup;
import com.cognos.ccs.formats.dashboardimage.ldx.Dashboard;
import com.cognos.ccs.formats.dashboardimage.ldx.WidgetInstance;
import com.cognos.ccs.formats.dashboardimage.ldx.WidgetInstanceStyleGroup;
import com.cognos.ccs.formats.dashboardimage.panel.DashboardFactory;
import com.cognos.ccs.formats.dashboardimage.panel.WidgetContentLoader;
import com.cognos.ccs.service.CCSLogger;
import com.cognos.ccs.utility.Utilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.PriorityQueue;
import org.dom4j.Document;
import org.dom4j.Element;

public class DashboardLdx
implements Dashboard {
    private Document m_ldx;
    private PriorityQueue<WidgetInstance> widgetInstances;
    private String m_firstPageId;
    private final WidgetContentLoader m_widgetContentLoader;
    private BackgroundStyleGroup m_dashboardBackgroundStyleGroup;
    private Dimension m_dashboardPanelSize;
    private final DashboardFactory m_dashboardFactory;
    private int m_widgetDrawOrder = 0;

    public DashboardLdx(Document document, WidgetContentLoader widgetContentLoader, DashboardFactory dashboardFactory) {
        Object object2;
        this.m_ldx = document;
        this.m_widgetContentLoader = widgetContentLoader;
        this.m_dashboardFactory = dashboardFactory;
        Element element = (Element)this.m_ldx.selectSingleNode("//page");
        this.m_firstPageId = element.elementText("id");
        this.widgetInstances = new PriorityQueue();
        List list = element.selectNodes("./body/item/widget");
        this.m_dashboardPanelSize = new Dimension(800, 600);
        for (Object object2 : list) {
            WidgetInstance widgetInstance = this.widgetInstance((Element)object2);
            this.widgetInstances.add(widgetInstance);
            Rectangle rectangle = widgetInstance.boxStyle();
            this.m_dashboardPanelSize.width = Math.max(this.m_dashboardPanelSize.width, rectangle.x + rectangle.width);
            this.m_dashboardPanelSize.height = Math.max(this.m_dashboardPanelSize.height, rectangle.y + rectangle.height);
        }
        this.m_dashboardPanelSize.width += 200;
        this.m_dashboardPanelSize.height += 200;
        object2 = "/document/pages/page[./id='" + this.m_firstPageId + "']/style";
        this.m_dashboardBackgroundStyleGroup = this.dashboardBackgroundStyleGroup(document, (String)object2, widgetContentLoader);
    }

    private WidgetInstance widgetInstance(Element element) {
        Image image;
        String string;
        String string2;
        Object object2;
        Document document = element.getDocument();
        List list = element.elements("style");
        WidgetInstanceStyleGroup widgetInstanceStyleGroup = null;
        for (Object object2 : list) {
            string2 = object2.getText();
            string = "/document/styleGroup[./name='" + string2 + "']";
            image = (Element)document.selectSingleNode(string);
            WidgetInstanceStyleGroup widgetInstanceStyleGroup2 = this.backgroundStyleGroup((Element)image, this.m_widgetContentLoader);
            widgetInstanceStyleGroup = this.m_dashboardFactory.mergeWidgetInstanceStyleGroups(widgetInstanceStyleGroup, widgetInstanceStyleGroup2);
        }
        object2 = null;
        if (null != widgetInstanceStyleGroup) {
            string2 = widgetInstanceStyleGroup;
            string = this.widgetURL(element);
            image = this.widgetIcon(element, string, this.m_widgetContentLoader);
            object2 = this.m_dashboardFactory.widgetInstance(string, image, (WidgetInstanceStyleGroup)((Object)string2));
        }
        return object2;
    }

    private String widgetURL(Element element) {
        String string;
        String string2 = null;
        Element element2 = (Element)element.selectSingleNode("extension/type");
        if (null != element2 && "viewer".equals(string = element2.getText())) {
            string2 = element.elementText("widgetURI");
        }
        string = string2;
        return string;
    }

    private Image widgetIcon(Element element, String string, WidgetContentLoader widgetContentLoader) {
        String string2 = null;
        String string3 = null;
        Element element2 = element.element("extension");
        if (null != element2) {
            string2 = element2.elementText("thumbnail");
            string3 = element2.elementText("objectClass");
        }
        String string4 = this.m_dashboardFactory.staticIcon(string2, string3);
        Image image = widgetContentLoader.localImage(string4);
        return image;
    }

    private BackgroundStyleGroup dashboardBackgroundStyleGroup(Document document, String string, WidgetContentLoader widgetContentLoader) {
        List list = document.selectNodes(string);
        BackgroundStyleGroup backgroundStyleGroup = null;
        for (Element element : list) {
            String string2 = element.getText();
            String string3 = "/document/styleGroup[./name='" + string2 + "']";
            Element element2 = (Element)document.selectSingleNode(string3);
            WidgetInstanceStyleGroup widgetInstanceStyleGroup = this.backgroundStyleGroup(element2, widgetContentLoader);
            backgroundStyleGroup = this.m_dashboardFactory.mergeStyleGroups(backgroundStyleGroup, widgetInstanceStyleGroup);
        }
        return backgroundStyleGroup;
    }

    private WidgetInstanceStyleGroup backgroundStyleGroup(Element element, WidgetContentLoader widgetContentLoader) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Object object5;
        Color color = this.bgColor(element);
        Element element2 = element.element("boxStyle");
        Rectangle rectangle = null;
        if (null != element2 && null != (object5 = element2.element("extension"))) {
            object4 = this.childElemValInt(element2, "height");
            serializable = this.childElemValInt(element2, "width");
            object3 = this.childElemValInt((Element)object5, "x");
            object2 = this.childElemValInt((Element)object5, "y");
            object = object5.elementText("drawOrder");
            boolean bl = !Utilities.isNullOrBlank((String)object);
            boolean bl2 = bl = bl && !"auto".equals(((String)object).trim());
            this.m_widgetDrawOrder = bl ? Integer.parseInt((String)object) : ++this.m_widgetDrawOrder;
            rectangle = new Rectangle((Integer)object3, (Integer)object2, (Integer)serializable, (Integer)object4);
        }
        object5 = null;
        object4 = element.elementText("bgImageURL");
        serializable = null;
        if (!Utilities.isNullOrEmpty((String)object4)) {
            try {
                serializable = new URL((String)object4);
            }
            catch (MalformedURLException malformedURLException) {
                object2 = malformedURLException.getMessage();
                object = new CCSGeneralException((String)object2, new String[]{object4}, 404);
                String string = ((Throwable)object).getMessage();
                String string2 = ((CCSGeneralException)object).getSourceTrace();
                CCSLogger cCSLogger = CCSLogger.getInstance();
                cCSLogger.logRuntimeWarning("CMS Thumbnail Service background image URL error: " + string, null, null, null, string2);
            }
        }
        if (null != (object3 = widgetContentLoader.backgroundImage((URL)serializable)) && null != (object2 = element.element("bgImageProperties"))) {
            object = object2.elementText("repeat");
            String string = object2.elementText("position");
            object5 = this.m_dashboardFactory.bgImageProperties(string, (String)object);
        }
        object2 = this.m_dashboardFactory.backgroundStyleGroup(color, (Image)object3, (BackgroundImageProperties)object5);
        object = this.m_dashboardFactory.widgetInstanceStyleGroup(rectangle, this.m_widgetDrawOrder, (BackgroundStyleGroup)object2);
        return object;
    }

    private Integer childElemValInt(Element element, String string) {
        Element element2;
        Integer n = null;
        if (null != element && null != (element2 = (Element)element.selectSingleNode(string))) {
            String string2 = element2.elementText("val");
            try {
                Float f = Float.valueOf(Float.parseFloat(string2));
                int n2 = f.intValue();
                n = n2;
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = numberFormatException.getMessage();
                CCSGeneralException cCSGeneralException = new CCSGeneralException(string3, new String[]{string2}, 400);
                String string4 = cCSGeneralException.getMessage();
                String string5 = cCSGeneralException.getSourceTrace();
                CCSLogger cCSLogger = CCSLogger.getInstance();
                cCSLogger.logRuntimeWarning("CMS Thumbnail Service numeric value error: " + string4, null, null, null, string5);
            }
        }
        return n;
    }

    private Color bgColor(Element element) {
        Element element2;
        Color color = Color.white;
        if (null != element && null != (element2 = element.element("bgColor"))) {
            String string = element2.elementText("Red");
            Integer n = Integer.valueOf(string);
            String string2 = element2.elementText("Green");
            Integer n2 = Integer.valueOf(string2);
            String string3 = element2.elementText("Blue");
            Integer n3 = Integer.valueOf(string3);
            color = new Color(n, n2, n3);
        }
        return color;
    }

    @Override
    public Color bgColor() {
        Color color = Color.white;
        if (null != this.m_dashboardBackgroundStyleGroup) {
            color = this.m_dashboardBackgroundStyleGroup.bgColor();
        }
        return color;
    }

    @Override
    public BackgroundImageProperties bgImageProperties() {
        BackgroundImageProperties backgroundImageProperties = null;
        if (null != this.m_dashboardBackgroundStyleGroup) {
            backgroundImageProperties = this.m_dashboardBackgroundStyleGroup.bgImageProperties();
        }
        return backgroundImageProperties;
    }

    @Override
    public Image bgImage() {
        Image image = null;
        if (null != this.m_dashboardBackgroundStyleGroup) {
            image = this.m_dashboardBackgroundStyleGroup.bgImage();
        }
        return image;
    }

    @Override
    public PriorityQueue<WidgetInstance> widgetInstances() {
        return this.widgetInstances;
    }
}

